// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.athena.auth.AthenaAuthSchemeProvider
import aws.sdk.kotlin.services.athena.auth.DefaultAthenaAuthSchemeProvider
import aws.sdk.kotlin.services.athena.endpoints.AthenaEndpointParameters
import aws.sdk.kotlin.services.athena.endpoints.AthenaEndpointProvider
import aws.sdk.kotlin.services.athena.endpoints.DefaultAthenaEndpointProvider
import aws.sdk.kotlin.services.athena.model.BatchGetNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.BatchGetNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.BatchGetPreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.BatchGetPreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.BatchGetQueryExecutionRequest
import aws.sdk.kotlin.services.athena.model.BatchGetQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.CancelCapacityReservationRequest
import aws.sdk.kotlin.services.athena.model.CancelCapacityReservationResponse
import aws.sdk.kotlin.services.athena.model.CreateCapacityReservationRequest
import aws.sdk.kotlin.services.athena.model.CreateCapacityReservationResponse
import aws.sdk.kotlin.services.athena.model.CreateDataCatalogRequest
import aws.sdk.kotlin.services.athena.model.CreateDataCatalogResponse
import aws.sdk.kotlin.services.athena.model.CreateNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.CreateNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.CreateNotebookRequest
import aws.sdk.kotlin.services.athena.model.CreateNotebookResponse
import aws.sdk.kotlin.services.athena.model.CreatePreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.CreatePreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.CreatePresignedNotebookUrlRequest
import aws.sdk.kotlin.services.athena.model.CreatePresignedNotebookUrlResponse
import aws.sdk.kotlin.services.athena.model.CreateWorkGroupRequest
import aws.sdk.kotlin.services.athena.model.CreateWorkGroupResponse
import aws.sdk.kotlin.services.athena.model.DeleteCapacityReservationRequest
import aws.sdk.kotlin.services.athena.model.DeleteCapacityReservationResponse
import aws.sdk.kotlin.services.athena.model.DeleteDataCatalogRequest
import aws.sdk.kotlin.services.athena.model.DeleteDataCatalogResponse
import aws.sdk.kotlin.services.athena.model.DeleteNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.DeleteNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.DeleteNotebookRequest
import aws.sdk.kotlin.services.athena.model.DeleteNotebookResponse
import aws.sdk.kotlin.services.athena.model.DeletePreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.DeletePreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.DeleteWorkGroupRequest
import aws.sdk.kotlin.services.athena.model.DeleteWorkGroupResponse
import aws.sdk.kotlin.services.athena.model.ExportNotebookRequest
import aws.sdk.kotlin.services.athena.model.ExportNotebookResponse
import aws.sdk.kotlin.services.athena.model.GetCalculationExecutionCodeRequest
import aws.sdk.kotlin.services.athena.model.GetCalculationExecutionCodeResponse
import aws.sdk.kotlin.services.athena.model.GetCalculationExecutionRequest
import aws.sdk.kotlin.services.athena.model.GetCalculationExecutionResponse
import aws.sdk.kotlin.services.athena.model.GetCalculationExecutionStatusRequest
import aws.sdk.kotlin.services.athena.model.GetCalculationExecutionStatusResponse
import aws.sdk.kotlin.services.athena.model.GetCapacityAssignmentConfigurationRequest
import aws.sdk.kotlin.services.athena.model.GetCapacityAssignmentConfigurationResponse
import aws.sdk.kotlin.services.athena.model.GetCapacityReservationRequest
import aws.sdk.kotlin.services.athena.model.GetCapacityReservationResponse
import aws.sdk.kotlin.services.athena.model.GetDataCatalogRequest
import aws.sdk.kotlin.services.athena.model.GetDataCatalogResponse
import aws.sdk.kotlin.services.athena.model.GetDatabaseRequest
import aws.sdk.kotlin.services.athena.model.GetDatabaseResponse
import aws.sdk.kotlin.services.athena.model.GetNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.GetNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.GetNotebookMetadataRequest
import aws.sdk.kotlin.services.athena.model.GetNotebookMetadataResponse
import aws.sdk.kotlin.services.athena.model.GetPreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.GetPreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.GetQueryExecutionRequest
import aws.sdk.kotlin.services.athena.model.GetQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.GetQueryResultsRequest
import aws.sdk.kotlin.services.athena.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.athena.model.GetQueryRuntimeStatisticsRequest
import aws.sdk.kotlin.services.athena.model.GetQueryRuntimeStatisticsResponse
import aws.sdk.kotlin.services.athena.model.GetSessionRequest
import aws.sdk.kotlin.services.athena.model.GetSessionResponse
import aws.sdk.kotlin.services.athena.model.GetSessionStatusRequest
import aws.sdk.kotlin.services.athena.model.GetSessionStatusResponse
import aws.sdk.kotlin.services.athena.model.GetTableMetadataRequest
import aws.sdk.kotlin.services.athena.model.GetTableMetadataResponse
import aws.sdk.kotlin.services.athena.model.GetWorkGroupRequest
import aws.sdk.kotlin.services.athena.model.GetWorkGroupResponse
import aws.sdk.kotlin.services.athena.model.ImportNotebookRequest
import aws.sdk.kotlin.services.athena.model.ImportNotebookResponse
import aws.sdk.kotlin.services.athena.model.ListApplicationDpuSizesRequest
import aws.sdk.kotlin.services.athena.model.ListApplicationDpuSizesResponse
import aws.sdk.kotlin.services.athena.model.ListCalculationExecutionsRequest
import aws.sdk.kotlin.services.athena.model.ListCalculationExecutionsResponse
import aws.sdk.kotlin.services.athena.model.ListCapacityReservationsRequest
import aws.sdk.kotlin.services.athena.model.ListCapacityReservationsResponse
import aws.sdk.kotlin.services.athena.model.ListDataCatalogsRequest
import aws.sdk.kotlin.services.athena.model.ListDataCatalogsResponse
import aws.sdk.kotlin.services.athena.model.ListDatabasesRequest
import aws.sdk.kotlin.services.athena.model.ListDatabasesResponse
import aws.sdk.kotlin.services.athena.model.ListEngineVersionsRequest
import aws.sdk.kotlin.services.athena.model.ListEngineVersionsResponse
import aws.sdk.kotlin.services.athena.model.ListExecutorsRequest
import aws.sdk.kotlin.services.athena.model.ListExecutorsResponse
import aws.sdk.kotlin.services.athena.model.ListNamedQueriesRequest
import aws.sdk.kotlin.services.athena.model.ListNamedQueriesResponse
import aws.sdk.kotlin.services.athena.model.ListNotebookMetadataRequest
import aws.sdk.kotlin.services.athena.model.ListNotebookMetadataResponse
import aws.sdk.kotlin.services.athena.model.ListNotebookSessionsRequest
import aws.sdk.kotlin.services.athena.model.ListNotebookSessionsResponse
import aws.sdk.kotlin.services.athena.model.ListPreparedStatementsRequest
import aws.sdk.kotlin.services.athena.model.ListPreparedStatementsResponse
import aws.sdk.kotlin.services.athena.model.ListQueryExecutionsRequest
import aws.sdk.kotlin.services.athena.model.ListQueryExecutionsResponse
import aws.sdk.kotlin.services.athena.model.ListSessionsRequest
import aws.sdk.kotlin.services.athena.model.ListSessionsResponse
import aws.sdk.kotlin.services.athena.model.ListTableMetadataRequest
import aws.sdk.kotlin.services.athena.model.ListTableMetadataResponse
import aws.sdk.kotlin.services.athena.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.athena.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.athena.model.ListWorkGroupsRequest
import aws.sdk.kotlin.services.athena.model.ListWorkGroupsResponse
import aws.sdk.kotlin.services.athena.model.PutCapacityAssignmentConfigurationRequest
import aws.sdk.kotlin.services.athena.model.PutCapacityAssignmentConfigurationResponse
import aws.sdk.kotlin.services.athena.model.StartCalculationExecutionRequest
import aws.sdk.kotlin.services.athena.model.StartCalculationExecutionResponse
import aws.sdk.kotlin.services.athena.model.StartQueryExecutionRequest
import aws.sdk.kotlin.services.athena.model.StartQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.StartSessionRequest
import aws.sdk.kotlin.services.athena.model.StartSessionResponse
import aws.sdk.kotlin.services.athena.model.StopCalculationExecutionRequest
import aws.sdk.kotlin.services.athena.model.StopCalculationExecutionResponse
import aws.sdk.kotlin.services.athena.model.StopQueryExecutionRequest
import aws.sdk.kotlin.services.athena.model.StopQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.TagResourceRequest
import aws.sdk.kotlin.services.athena.model.TagResourceResponse
import aws.sdk.kotlin.services.athena.model.TerminateSessionRequest
import aws.sdk.kotlin.services.athena.model.TerminateSessionResponse
import aws.sdk.kotlin.services.athena.model.UntagResourceRequest
import aws.sdk.kotlin.services.athena.model.UntagResourceResponse
import aws.sdk.kotlin.services.athena.model.UpdateCapacityReservationRequest
import aws.sdk.kotlin.services.athena.model.UpdateCapacityReservationResponse
import aws.sdk.kotlin.services.athena.model.UpdateDataCatalogRequest
import aws.sdk.kotlin.services.athena.model.UpdateDataCatalogResponse
import aws.sdk.kotlin.services.athena.model.UpdateNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.UpdateNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.UpdateNotebookMetadataRequest
import aws.sdk.kotlin.services.athena.model.UpdateNotebookMetadataResponse
import aws.sdk.kotlin.services.athena.model.UpdateNotebookRequest
import aws.sdk.kotlin.services.athena.model.UpdateNotebookResponse
import aws.sdk.kotlin.services.athena.model.UpdatePreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.UpdatePreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.UpdateWorkGroupRequest
import aws.sdk.kotlin.services.athena.model.UpdateWorkGroupResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Athena"
public const val SdkVersion: String = "1.0.20"
public const val ServiceApiVersion: String = "2017-05-18"

/**
 * Amazon Athena is an interactive query service that lets you use standard SQL to analyze data directly in Amazon S3. You can point Athena at your data in Amazon S3 and run ad-hoc queries and get results in seconds. Athena is serverless, so there is no infrastructure to set up or manage. You pay only for the queries you run. Athena scales automatically—executing queries in parallel—so results are fast, even with large datasets and complex queries. For more information, see [What is Amazon Athena](http://docs.aws.amazon.com/athena/latest/ug/what-is.html) in the *Amazon Athena User Guide*.
 *
 * If you connect to Athena using the JDBC driver, use version 1.1.0 of the driver or later with the Amazon Athena API. Earlier version drivers do not support the API. For more information and to download the driver, see [Accessing Amazon Athena with JDBC](https://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html).
 */
public interface AthenaClient : SdkClient {
    /**
     * AthenaClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AthenaClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Athena",
                "ATHENA",
                "athena",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AthenaClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AthenaClient = DefaultAthenaClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AthenaEndpointProvider = builder.endpointProvider ?: DefaultAthenaEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AthenaAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAthenaAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Athena"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AthenaEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AthenaAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use ListNamedQueriesInput to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under UnprocessedNamedQueryId. Named queries differ from executed queries. Use BatchGetQueryExecutionInput to get details about each unique query execution, and ListQueryExecutionsInput to get a list of query execution IDs.
     */
    public suspend fun batchGetNamedQuery(input: BatchGetNamedQueryRequest): BatchGetNamedQueryResponse

    /**
     * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in `UnprocessedPreparedStatementNames`.
     */
    public suspend fun batchGetPreparedStatement(input: BatchGetPreparedStatementRequest): BatchGetPreparedStatementResponse

    /**
     * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup. Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput to get details about named queries.
     */
    public suspend fun batchGetQueryExecution(input: BatchGetQueryExecutionRequest): BatchGetQueryExecutionResponse

    /**
     * Cancels the capacity reservation with the specified name. Cancelled reservations remain in your account and will be deleted 45 days after cancellation. During the 45 days, you cannot re-purpose or reuse a reservation that has been cancelled, but you can refer to its tags and view it for historical reference.
     */
    public suspend fun cancelCapacityReservation(input: CancelCapacityReservationRequest): CancelCapacityReservationResponse

    /**
     * Creates a capacity reservation with the specified name and number of requested data processing units.
     */
    public suspend fun createCapacityReservation(input: CreateCapacityReservationRequest): CreateCapacityReservationResponse

    /**
     * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.
     */
    public suspend fun createDataCatalog(input: CreateDataCatalogRequest): CreateDataCatalogResponse

    /**
     * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
     */
    public suspend fun createNamedQuery(input: CreateNamedQueryRequest): CreateNamedQueryResponse

    /**
     * Creates an empty `ipynb` file in the specified Apache Spark enabled workgroup. Throws an error if a file in the workgroup with the same name already exists.
     */
    public suspend fun createNotebook(input: CreateNotebookRequest): CreateNotebookResponse

    /**
     * Creates a prepared statement for use with SQL queries in Athena.
     */
    public suspend fun createPreparedStatement(input: CreatePreparedStatementRequest): CreatePreparedStatementResponse

    /**
     * Gets an authentication token and the URL at which the notebook can be accessed. During programmatic access, `CreatePresignedNotebookUrl` must be called every 10 minutes to refresh the authentication token. For information about granting programmatic access, see [Grant programmatic access](https://docs.aws.amazon.com/athena/latest/ug/setting-up.html#setting-up-grant-programmatic-access).
     */
    public suspend fun createPresignedNotebookUrl(input: CreatePresignedNotebookUrlRequest): CreatePresignedNotebookUrlResponse

    /**
     * Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena SQL workgroup.
     */
    public suspend fun createWorkGroup(input: CreateWorkGroupRequest): CreateWorkGroupResponse

    /**
     * Deletes a cancelled capacity reservation. A reservation must be cancelled before it can be deleted. A deleted reservation is immediately removed from your account and can no longer be referenced, including by its ARN. A deleted reservation cannot be called by `GetCapacityReservation`, and deleted reservations do not appear in the output of `ListCapacityReservations`.
     */
    public suspend fun deleteCapacityReservation(input: DeleteCapacityReservationRequest): DeleteCapacityReservationResponse

    /**
     * Deletes a data catalog.
     */
    public suspend fun deleteDataCatalog(input: DeleteDataCatalogRequest): DeleteDataCatalogResponse

    /**
     * Deletes the named query if you have access to the workgroup in which the query was saved.
     */
    public suspend fun deleteNamedQuery(input: DeleteNamedQueryRequest): DeleteNamedQueryResponse

    /**
     * Deletes the specified notebook.
     */
    public suspend fun deleteNotebook(input: DeleteNotebookRequest): DeleteNotebookResponse

    /**
     * Deletes the prepared statement with the specified name from the specified workgroup.
     */
    public suspend fun deletePreparedStatement(input: DeletePreparedStatementRequest): DeletePreparedStatementResponse

    /**
     * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
     */
    public suspend fun deleteWorkGroup(input: DeleteWorkGroupRequest): DeleteWorkGroupResponse

    /**
     * Exports the specified notebook and its metadata.
     */
    public suspend fun exportNotebook(input: ExportNotebookRequest): ExportNotebookResponse

    /**
     * Describes a previously submitted calculation execution.
     */
    public suspend fun getCalculationExecution(input: GetCalculationExecutionRequest): GetCalculationExecutionResponse

    /**
     * Retrieves the unencrypted code that was executed for the calculation.
     */
    public suspend fun getCalculationExecutionCode(input: GetCalculationExecutionCodeRequest): GetCalculationExecutionCodeResponse

    /**
     * Gets the status of a current calculation.
     */
    public suspend fun getCalculationExecutionStatus(input: GetCalculationExecutionStatusRequest): GetCalculationExecutionStatusResponse

    /**
     * Gets the capacity assignment configuration for a capacity reservation, if one exists.
     */
    public suspend fun getCapacityAssignmentConfiguration(input: GetCapacityAssignmentConfigurationRequest): GetCapacityAssignmentConfigurationResponse

    /**
     * Returns information about the capacity reservation with the specified name.
     */
    public suspend fun getCapacityReservation(input: GetCapacityReservationRequest): GetCapacityReservationResponse

    /**
     * Returns the specified data catalog.
     */
    public suspend fun getDataCatalog(input: GetDataCatalogRequest): GetDataCatalogResponse

    /**
     * Returns a database object for the specified database and data catalog.
     */
    public suspend fun getDatabase(input: GetDatabaseRequest): GetDatabaseResponse

    /**
     * Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.
     */
    public suspend fun getNamedQuery(input: GetNamedQueryRequest): GetNamedQueryResponse

    /**
     * Retrieves notebook metadata for the specified notebook ID.
     */
    public suspend fun getNotebookMetadata(input: GetNotebookMetadataRequest): GetNotebookMetadataResponse

    /**
     * Retrieves the prepared statement with the specified name from the specified workgroup.
     */
    public suspend fun getPreparedStatement(input: GetPreparedStatementRequest): GetPreparedStatementResponse

    /**
     * Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.
     */
    public suspend fun getQueryExecution(input: GetQueryExecutionRequest): GetQueryExecutionResponse

    /**
     * Streams the results of a single query execution specified by `QueryExecutionId` from the Athena query results location in Amazon S3. For more information, see [Working with query results, recent queries, and output files](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*. This request does not execute the query but returns results. Use StartQueryExecution to run a query.
     *
     * To stream query results successfully, the IAM principal with permission to call `GetQueryResults` also must have permissions to the Amazon S3 `GetObject` action for the Athena query results location.
     *
     * IAM principals with permission to the Amazon S3 `GetObject` action for the query results location are able to retrieve query results from Amazon S3 even if permission to the `GetQueryResults` action is denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are denied.
     */
    public suspend fun getQueryResults(input: GetQueryResultsRequest): GetQueryResultsResponse

    /**
     * Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. Query execution runtime statistics are returned only when QueryExecutionStatus$State is in a SUCCEEDED or FAILED state. Stage-level input and output row count and data size statistics are not shown when a query has row-level filters defined in Lake Formation.
     */
    public suspend fun getQueryRuntimeStatistics(input: GetQueryRuntimeStatisticsRequest): GetQueryRuntimeStatisticsResponse

    /**
     * Gets the full details of a previously created session, including the session status and configuration.
     */
    public suspend fun getSession(input: GetSessionRequest): GetSessionResponse

    /**
     * Gets the current status of a session.
     */
    public suspend fun getSessionStatus(input: GetSessionStatusRequest): GetSessionStatusResponse

    /**
     * Returns table metadata for the specified catalog, database, and table.
     */
    public suspend fun getTableMetadata(input: GetTableMetadataRequest): GetTableMetadataResponse

    /**
     * Returns information about the workgroup with the specified name.
     */
    public suspend fun getWorkGroup(input: GetWorkGroupRequest): GetWorkGroupResponse

    /**
     * Imports a single `ipynb` file to a Spark enabled workgroup. The maximum file size that can be imported is 10 megabytes. If an `ipynb` file with the same name already exists in the workgroup, throws an error.
     */
    public suspend fun importNotebook(input: ImportNotebookRequest): ImportNotebookResponse

    /**
     * Returns the supported DPU sizes for the supported application runtimes (for example, `Athena notebook version 1`).
     */
    public suspend fun listApplicationDpuSizes(input: ListApplicationDpuSizesRequest = ListApplicationDpuSizesRequest { }): ListApplicationDpuSizesResponse

    /**
     * Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed first; older calculations are listed later.
     */
    public suspend fun listCalculationExecutions(input: ListCalculationExecutionsRequest): ListCalculationExecutionsResponse

    /**
     * Lists the capacity reservations for the current account.
     */
    public suspend fun listCapacityReservations(input: ListCapacityReservationsRequest = ListCapacityReservationsRequest { }): ListCapacityReservationsResponse

    /**
     * Lists the data catalogs in the current Amazon Web Services account.
     *
     * In the Athena console, data catalogs are listed as "data sources" on the **Data sources** page under the **Data source name** column.
     */
    public suspend fun listDataCatalogs(input: ListDataCatalogsRequest = ListDataCatalogsRequest { }): ListDataCatalogsResponse

    /**
     * Lists the databases in the specified data catalog.
     */
    public suspend fun listDatabases(input: ListDatabasesRequest): ListDatabasesResponse

    /**
     * Returns a list of engine versions that are available to choose from, including the Auto option.
     */
    public suspend fun listEngineVersions(input: ListEngineVersionsRequest = ListEngineVersionsRequest { }): ListEngineVersionsResponse

    /**
     * Lists, in descending order, the executors that joined a session. Newer executors are listed first; older executors are listed later. The result can be optionally filtered by state.
     */
    public suspend fun listExecutors(input: ListExecutorsRequest): ListExecutorsResponse

    /**
     * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.
     */
    public suspend fun listNamedQueries(input: ListNamedQueriesRequest = ListNamedQueriesRequest { }): ListNamedQueriesResponse

    /**
     * Displays the notebook files for the specified workgroup in paginated format.
     */
    public suspend fun listNotebookMetadata(input: ListNotebookMetadataRequest): ListNotebookMetadataResponse

    /**
     * Lists, in descending order, the sessions that have been created in a notebook that are in an active state like `CREATING`, `CREATED`, `IDLE` or `BUSY`. Newer sessions are listed first; older sessions are listed later.
     */
    public suspend fun listNotebookSessions(input: ListNotebookSessionsRequest): ListNotebookSessionsResponse

    /**
     * Lists the prepared statements in the specified workgroup.
     */
    public suspend fun listPreparedStatements(input: ListPreparedStatementsRequest): ListPreparedStatementsResponse

    /**
     * Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.
     */
    public suspend fun listQueryExecutions(input: ListQueryExecutionsRequest = ListQueryExecutionsRequest { }): ListQueryExecutionsResponse

    /**
     * Lists the sessions in a workgroup that are in an active state like `CREATING`, `CREATED`, `IDLE`, or `BUSY`. Newer sessions are listed first; older sessions are listed later.
     */
    public suspend fun listSessions(input: ListSessionsRequest): ListSessionsResponse

    /**
     * Lists the metadata for the tables in the specified data catalog database.
     */
    public suspend fun listTableMetadata(input: ListTableMetadataRequest): ListTableMetadataResponse

    /**
     * Lists the tags associated with an Athena resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists available workgroups for the account.
     */
    public suspend fun listWorkGroups(input: ListWorkGroupsRequest = ListWorkGroupsRequest { }): ListWorkGroupsResponse

    /**
     * Puts a new capacity assignment configuration for a specified capacity reservation. If a capacity assignment configuration already exists for the capacity reservation, replaces the existing capacity assignment configuration.
     */
    public suspend fun putCapacityAssignmentConfiguration(input: PutCapacityAssignmentConfigurationRequest): PutCapacityAssignmentConfigurationResponse

    /**
     * Submits calculations for execution within a session. You can supply the code to run as an inline code block within the request.
     *
     * The request syntax requires the StartCalculationExecutionRequest$CodeBlock parameter or the CalculationConfiguration$CodeBlock parameter, but not both. Because CalculationConfiguration$CodeBlock is deprecated, use the StartCalculationExecutionRequest$CodeBlock parameter instead.
     */
    public suspend fun startCalculationExecution(input: StartCalculationExecutionRequest): StartCalculationExecutionResponse

    /**
     * Runs the SQL query statements contained in the `Query`. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires GetDataCatalog permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    public suspend fun startQueryExecution(input: StartQueryExecutionRequest): StartQueryExecutionResponse

    /**
     * Creates a session for running calculations within a workgroup. The session is ready when it reaches an `IDLE` state.
     */
    public suspend fun startSession(input: StartSessionRequest): StartSessionResponse

    /**
     * Requests the cancellation of a calculation. A `StopCalculationExecution` call on a calculation that is already in a terminal state (for example, `STOPPED`, `FAILED`, or `COMPLETED`) succeeds but has no effect.
     *
     * Cancelling a calculation is done on a best effort basis. If a calculation cannot be cancelled, you can be charged for its completion. If you are concerned about being charged for a calculation that cannot be cancelled, consider terminating the session in which the calculation is running.
     */
    public suspend fun stopCalculationExecution(input: StopCalculationExecutionRequest): StopCalculationExecutionResponse

    /**
     * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
     */
    public suspend fun stopQueryExecution(input: StopQueryExecutionRequest): StopQueryExecutionResponse

    /**
     * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter the resources in your account. For best practices, see [Tagging Best Practices](https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html). Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Terminates an active session. A `TerminateSession` call on a session that is already inactive (for example, in a `FAILED`, `TERMINATED` or `TERMINATING` state) succeeds but has no effect. Calculations running in the session when `TerminateSession` is called are forcefully stopped, but may display as `FAILED` instead of `STOPPED`.
     */
    public suspend fun terminateSession(input: TerminateSessionRequest): TerminateSessionResponse

    /**
     * Removes one or more tags from an Athena resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the number of requested data processing units for the capacity reservation with the specified name.
     */
    public suspend fun updateCapacityReservation(input: UpdateCapacityReservationRequest): UpdateCapacityReservationResponse

    /**
     * Updates the data catalog that has the specified name.
     */
    public suspend fun updateDataCatalog(input: UpdateDataCatalogRequest): UpdateDataCatalogResponse

    /**
     * Updates a NamedQuery object. The database or workgroup cannot be updated.
     */
    public suspend fun updateNamedQuery(input: UpdateNamedQueryRequest): UpdateNamedQueryResponse

    /**
     * Updates the contents of a Spark notebook.
     */
    public suspend fun updateNotebook(input: UpdateNotebookRequest): UpdateNotebookResponse

    /**
     * Updates the metadata for a notebook.
     */
    public suspend fun updateNotebookMetadata(input: UpdateNotebookMetadataRequest): UpdateNotebookMetadataResponse

    /**
     * Updates a prepared statement.
     */
    public suspend fun updatePreparedStatement(input: UpdatePreparedStatementRequest): UpdatePreparedStatementResponse

    /**
     * Updates the workgroup with the specified name. The workgroup's name cannot be changed. Only `ConfigurationUpdates` can be specified.
     */
    public suspend fun updateWorkGroup(input: UpdateWorkGroupRequest): UpdateWorkGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AthenaClient.withConfig(block: AthenaClient.Config.Builder.() -> Unit): AthenaClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAthenaClient(newConfig)
}

/**
 * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use ListNamedQueriesInput to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under UnprocessedNamedQueryId. Named queries differ from executed queries. Use BatchGetQueryExecutionInput to get details about each unique query execution, and ListQueryExecutionsInput to get a list of query execution IDs.
 */
public suspend inline fun AthenaClient.batchGetNamedQuery(crossinline block: BatchGetNamedQueryRequest.Builder.() -> Unit): BatchGetNamedQueryResponse = batchGetNamedQuery(BatchGetNamedQueryRequest.Builder().apply(block).build())

/**
 * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in `UnprocessedPreparedStatementNames`.
 */
public suspend inline fun AthenaClient.batchGetPreparedStatement(crossinline block: BatchGetPreparedStatementRequest.Builder.() -> Unit): BatchGetPreparedStatementResponse = batchGetPreparedStatement(BatchGetPreparedStatementRequest.Builder().apply(block).build())

/**
 * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup. Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput to get details about named queries.
 */
public suspend inline fun AthenaClient.batchGetQueryExecution(crossinline block: BatchGetQueryExecutionRequest.Builder.() -> Unit): BatchGetQueryExecutionResponse = batchGetQueryExecution(BatchGetQueryExecutionRequest.Builder().apply(block).build())

/**
 * Cancels the capacity reservation with the specified name. Cancelled reservations remain in your account and will be deleted 45 days after cancellation. During the 45 days, you cannot re-purpose or reuse a reservation that has been cancelled, but you can refer to its tags and view it for historical reference.
 */
public suspend inline fun AthenaClient.cancelCapacityReservation(crossinline block: CancelCapacityReservationRequest.Builder.() -> Unit): CancelCapacityReservationResponse = cancelCapacityReservation(CancelCapacityReservationRequest.Builder().apply(block).build())

/**
 * Creates a capacity reservation with the specified name and number of requested data processing units.
 */
public suspend inline fun AthenaClient.createCapacityReservation(crossinline block: CreateCapacityReservationRequest.Builder.() -> Unit): CreateCapacityReservationResponse = createCapacityReservation(CreateCapacityReservationRequest.Builder().apply(block).build())

/**
 * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.
 */
public suspend inline fun AthenaClient.createDataCatalog(crossinline block: CreateDataCatalogRequest.Builder.() -> Unit): CreateDataCatalogResponse = createDataCatalog(CreateDataCatalogRequest.Builder().apply(block).build())

/**
 * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
 */
public suspend inline fun AthenaClient.createNamedQuery(crossinline block: CreateNamedQueryRequest.Builder.() -> Unit): CreateNamedQueryResponse = createNamedQuery(CreateNamedQueryRequest.Builder().apply(block).build())

/**
 * Creates an empty `ipynb` file in the specified Apache Spark enabled workgroup. Throws an error if a file in the workgroup with the same name already exists.
 */
public suspend inline fun AthenaClient.createNotebook(crossinline block: CreateNotebookRequest.Builder.() -> Unit): CreateNotebookResponse = createNotebook(CreateNotebookRequest.Builder().apply(block).build())

/**
 * Creates a prepared statement for use with SQL queries in Athena.
 */
public suspend inline fun AthenaClient.createPreparedStatement(crossinline block: CreatePreparedStatementRequest.Builder.() -> Unit): CreatePreparedStatementResponse = createPreparedStatement(CreatePreparedStatementRequest.Builder().apply(block).build())

/**
 * Gets an authentication token and the URL at which the notebook can be accessed. During programmatic access, `CreatePresignedNotebookUrl` must be called every 10 minutes to refresh the authentication token. For information about granting programmatic access, see [Grant programmatic access](https://docs.aws.amazon.com/athena/latest/ug/setting-up.html#setting-up-grant-programmatic-access).
 */
public suspend inline fun AthenaClient.createPresignedNotebookUrl(crossinline block: CreatePresignedNotebookUrlRequest.Builder.() -> Unit): CreatePresignedNotebookUrlResponse = createPresignedNotebookUrl(CreatePresignedNotebookUrlRequest.Builder().apply(block).build())

/**
 * Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena SQL workgroup.
 */
public suspend inline fun AthenaClient.createWorkGroup(crossinline block: CreateWorkGroupRequest.Builder.() -> Unit): CreateWorkGroupResponse = createWorkGroup(CreateWorkGroupRequest.Builder().apply(block).build())

/**
 * Deletes a cancelled capacity reservation. A reservation must be cancelled before it can be deleted. A deleted reservation is immediately removed from your account and can no longer be referenced, including by its ARN. A deleted reservation cannot be called by `GetCapacityReservation`, and deleted reservations do not appear in the output of `ListCapacityReservations`.
 */
public suspend inline fun AthenaClient.deleteCapacityReservation(crossinline block: DeleteCapacityReservationRequest.Builder.() -> Unit): DeleteCapacityReservationResponse = deleteCapacityReservation(DeleteCapacityReservationRequest.Builder().apply(block).build())

/**
 * Deletes a data catalog.
 */
public suspend inline fun AthenaClient.deleteDataCatalog(crossinline block: DeleteDataCatalogRequest.Builder.() -> Unit): DeleteDataCatalogResponse = deleteDataCatalog(DeleteDataCatalogRequest.Builder().apply(block).build())

/**
 * Deletes the named query if you have access to the workgroup in which the query was saved.
 */
public suspend inline fun AthenaClient.deleteNamedQuery(crossinline block: DeleteNamedQueryRequest.Builder.() -> Unit): DeleteNamedQueryResponse = deleteNamedQuery(DeleteNamedQueryRequest.Builder().apply(block).build())

/**
 * Deletes the specified notebook.
 */
public suspend inline fun AthenaClient.deleteNotebook(crossinline block: DeleteNotebookRequest.Builder.() -> Unit): DeleteNotebookResponse = deleteNotebook(DeleteNotebookRequest.Builder().apply(block).build())

/**
 * Deletes the prepared statement with the specified name from the specified workgroup.
 */
public suspend inline fun AthenaClient.deletePreparedStatement(crossinline block: DeletePreparedStatementRequest.Builder.() -> Unit): DeletePreparedStatementResponse = deletePreparedStatement(DeletePreparedStatementRequest.Builder().apply(block).build())

/**
 * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
 */
public suspend inline fun AthenaClient.deleteWorkGroup(crossinline block: DeleteWorkGroupRequest.Builder.() -> Unit): DeleteWorkGroupResponse = deleteWorkGroup(DeleteWorkGroupRequest.Builder().apply(block).build())

/**
 * Exports the specified notebook and its metadata.
 */
public suspend inline fun AthenaClient.exportNotebook(crossinline block: ExportNotebookRequest.Builder.() -> Unit): ExportNotebookResponse = exportNotebook(ExportNotebookRequest.Builder().apply(block).build())

/**
 * Describes a previously submitted calculation execution.
 */
public suspend inline fun AthenaClient.getCalculationExecution(crossinline block: GetCalculationExecutionRequest.Builder.() -> Unit): GetCalculationExecutionResponse = getCalculationExecution(GetCalculationExecutionRequest.Builder().apply(block).build())

/**
 * Retrieves the unencrypted code that was executed for the calculation.
 */
public suspend inline fun AthenaClient.getCalculationExecutionCode(crossinline block: GetCalculationExecutionCodeRequest.Builder.() -> Unit): GetCalculationExecutionCodeResponse = getCalculationExecutionCode(GetCalculationExecutionCodeRequest.Builder().apply(block).build())

/**
 * Gets the status of a current calculation.
 */
public suspend inline fun AthenaClient.getCalculationExecutionStatus(crossinline block: GetCalculationExecutionStatusRequest.Builder.() -> Unit): GetCalculationExecutionStatusResponse = getCalculationExecutionStatus(GetCalculationExecutionStatusRequest.Builder().apply(block).build())

/**
 * Gets the capacity assignment configuration for a capacity reservation, if one exists.
 */
public suspend inline fun AthenaClient.getCapacityAssignmentConfiguration(crossinline block: GetCapacityAssignmentConfigurationRequest.Builder.() -> Unit): GetCapacityAssignmentConfigurationResponse = getCapacityAssignmentConfiguration(GetCapacityAssignmentConfigurationRequest.Builder().apply(block).build())

/**
 * Returns information about the capacity reservation with the specified name.
 */
public suspend inline fun AthenaClient.getCapacityReservation(crossinline block: GetCapacityReservationRequest.Builder.() -> Unit): GetCapacityReservationResponse = getCapacityReservation(GetCapacityReservationRequest.Builder().apply(block).build())

/**
 * Returns the specified data catalog.
 */
public suspend inline fun AthenaClient.getDataCatalog(crossinline block: GetDataCatalogRequest.Builder.() -> Unit): GetDataCatalogResponse = getDataCatalog(GetDataCatalogRequest.Builder().apply(block).build())

/**
 * Returns a database object for the specified database and data catalog.
 */
public suspend inline fun AthenaClient.getDatabase(crossinline block: GetDatabaseRequest.Builder.() -> Unit): GetDatabaseResponse = getDatabase(GetDatabaseRequest.Builder().apply(block).build())

/**
 * Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.
 */
public suspend inline fun AthenaClient.getNamedQuery(crossinline block: GetNamedQueryRequest.Builder.() -> Unit): GetNamedQueryResponse = getNamedQuery(GetNamedQueryRequest.Builder().apply(block).build())

/**
 * Retrieves notebook metadata for the specified notebook ID.
 */
public suspend inline fun AthenaClient.getNotebookMetadata(crossinline block: GetNotebookMetadataRequest.Builder.() -> Unit): GetNotebookMetadataResponse = getNotebookMetadata(GetNotebookMetadataRequest.Builder().apply(block).build())

/**
 * Retrieves the prepared statement with the specified name from the specified workgroup.
 */
public suspend inline fun AthenaClient.getPreparedStatement(crossinline block: GetPreparedStatementRequest.Builder.() -> Unit): GetPreparedStatementResponse = getPreparedStatement(GetPreparedStatementRequest.Builder().apply(block).build())

/**
 * Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.
 */
public suspend inline fun AthenaClient.getQueryExecution(crossinline block: GetQueryExecutionRequest.Builder.() -> Unit): GetQueryExecutionResponse = getQueryExecution(GetQueryExecutionRequest.Builder().apply(block).build())

/**
 * Streams the results of a single query execution specified by `QueryExecutionId` from the Athena query results location in Amazon S3. For more information, see [Working with query results, recent queries, and output files](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*. This request does not execute the query but returns results. Use StartQueryExecution to run a query.
 *
 * To stream query results successfully, the IAM principal with permission to call `GetQueryResults` also must have permissions to the Amazon S3 `GetObject` action for the Athena query results location.
 *
 * IAM principals with permission to the Amazon S3 `GetObject` action for the query results location are able to retrieve query results from Amazon S3 even if permission to the `GetQueryResults` action is denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are denied.
 */
public suspend inline fun AthenaClient.getQueryResults(crossinline block: GetQueryResultsRequest.Builder.() -> Unit): GetQueryResultsResponse = getQueryResults(GetQueryResultsRequest.Builder().apply(block).build())

/**
 * Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. Query execution runtime statistics are returned only when QueryExecutionStatus$State is in a SUCCEEDED or FAILED state. Stage-level input and output row count and data size statistics are not shown when a query has row-level filters defined in Lake Formation.
 */
public suspend inline fun AthenaClient.getQueryRuntimeStatistics(crossinline block: GetQueryRuntimeStatisticsRequest.Builder.() -> Unit): GetQueryRuntimeStatisticsResponse = getQueryRuntimeStatistics(GetQueryRuntimeStatisticsRequest.Builder().apply(block).build())

/**
 * Gets the full details of a previously created session, including the session status and configuration.
 */
public suspend inline fun AthenaClient.getSession(crossinline block: GetSessionRequest.Builder.() -> Unit): GetSessionResponse = getSession(GetSessionRequest.Builder().apply(block).build())

/**
 * Gets the current status of a session.
 */
public suspend inline fun AthenaClient.getSessionStatus(crossinline block: GetSessionStatusRequest.Builder.() -> Unit): GetSessionStatusResponse = getSessionStatus(GetSessionStatusRequest.Builder().apply(block).build())

/**
 * Returns table metadata for the specified catalog, database, and table.
 */
public suspend inline fun AthenaClient.getTableMetadata(crossinline block: GetTableMetadataRequest.Builder.() -> Unit): GetTableMetadataResponse = getTableMetadata(GetTableMetadataRequest.Builder().apply(block).build())

/**
 * Returns information about the workgroup with the specified name.
 */
public suspend inline fun AthenaClient.getWorkGroup(crossinline block: GetWorkGroupRequest.Builder.() -> Unit): GetWorkGroupResponse = getWorkGroup(GetWorkGroupRequest.Builder().apply(block).build())

/**
 * Imports a single `ipynb` file to a Spark enabled workgroup. The maximum file size that can be imported is 10 megabytes. If an `ipynb` file with the same name already exists in the workgroup, throws an error.
 */
public suspend inline fun AthenaClient.importNotebook(crossinline block: ImportNotebookRequest.Builder.() -> Unit): ImportNotebookResponse = importNotebook(ImportNotebookRequest.Builder().apply(block).build())

/**
 * Returns the supported DPU sizes for the supported application runtimes (for example, `Athena notebook version 1`).
 */
public suspend inline fun AthenaClient.listApplicationDpuSizes(crossinline block: ListApplicationDpuSizesRequest.Builder.() -> Unit): ListApplicationDpuSizesResponse = listApplicationDpuSizes(ListApplicationDpuSizesRequest.Builder().apply(block).build())

/**
 * Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed first; older calculations are listed later.
 */
public suspend inline fun AthenaClient.listCalculationExecutions(crossinline block: ListCalculationExecutionsRequest.Builder.() -> Unit): ListCalculationExecutionsResponse = listCalculationExecutions(ListCalculationExecutionsRequest.Builder().apply(block).build())

/**
 * Lists the capacity reservations for the current account.
 */
public suspend inline fun AthenaClient.listCapacityReservations(crossinline block: ListCapacityReservationsRequest.Builder.() -> Unit): ListCapacityReservationsResponse = listCapacityReservations(ListCapacityReservationsRequest.Builder().apply(block).build())

/**
 * Lists the data catalogs in the current Amazon Web Services account.
 *
 * In the Athena console, data catalogs are listed as "data sources" on the **Data sources** page under the **Data source name** column.
 */
public suspend inline fun AthenaClient.listDataCatalogs(crossinline block: ListDataCatalogsRequest.Builder.() -> Unit): ListDataCatalogsResponse = listDataCatalogs(ListDataCatalogsRequest.Builder().apply(block).build())

/**
 * Lists the databases in the specified data catalog.
 */
public suspend inline fun AthenaClient.listDatabases(crossinline block: ListDatabasesRequest.Builder.() -> Unit): ListDatabasesResponse = listDatabases(ListDatabasesRequest.Builder().apply(block).build())

/**
 * Returns a list of engine versions that are available to choose from, including the Auto option.
 */
public suspend inline fun AthenaClient.listEngineVersions(crossinline block: ListEngineVersionsRequest.Builder.() -> Unit): ListEngineVersionsResponse = listEngineVersions(ListEngineVersionsRequest.Builder().apply(block).build())

/**
 * Lists, in descending order, the executors that joined a session. Newer executors are listed first; older executors are listed later. The result can be optionally filtered by state.
 */
public suspend inline fun AthenaClient.listExecutors(crossinline block: ListExecutorsRequest.Builder.() -> Unit): ListExecutorsResponse = listExecutors(ListExecutorsRequest.Builder().apply(block).build())

/**
 * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.
 */
public suspend inline fun AthenaClient.listNamedQueries(crossinline block: ListNamedQueriesRequest.Builder.() -> Unit): ListNamedQueriesResponse = listNamedQueries(ListNamedQueriesRequest.Builder().apply(block).build())

/**
 * Displays the notebook files for the specified workgroup in paginated format.
 */
public suspend inline fun AthenaClient.listNotebookMetadata(crossinline block: ListNotebookMetadataRequest.Builder.() -> Unit): ListNotebookMetadataResponse = listNotebookMetadata(ListNotebookMetadataRequest.Builder().apply(block).build())

/**
 * Lists, in descending order, the sessions that have been created in a notebook that are in an active state like `CREATING`, `CREATED`, `IDLE` or `BUSY`. Newer sessions are listed first; older sessions are listed later.
 */
public suspend inline fun AthenaClient.listNotebookSessions(crossinline block: ListNotebookSessionsRequest.Builder.() -> Unit): ListNotebookSessionsResponse = listNotebookSessions(ListNotebookSessionsRequest.Builder().apply(block).build())

/**
 * Lists the prepared statements in the specified workgroup.
 */
public suspend inline fun AthenaClient.listPreparedStatements(crossinline block: ListPreparedStatementsRequest.Builder.() -> Unit): ListPreparedStatementsResponse = listPreparedStatements(ListPreparedStatementsRequest.Builder().apply(block).build())

/**
 * Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.
 */
public suspend inline fun AthenaClient.listQueryExecutions(crossinline block: ListQueryExecutionsRequest.Builder.() -> Unit): ListQueryExecutionsResponse = listQueryExecutions(ListQueryExecutionsRequest.Builder().apply(block).build())

/**
 * Lists the sessions in a workgroup that are in an active state like `CREATING`, `CREATED`, `IDLE`, or `BUSY`. Newer sessions are listed first; older sessions are listed later.
 */
public suspend inline fun AthenaClient.listSessions(crossinline block: ListSessionsRequest.Builder.() -> Unit): ListSessionsResponse = listSessions(ListSessionsRequest.Builder().apply(block).build())

/**
 * Lists the metadata for the tables in the specified data catalog database.
 */
public suspend inline fun AthenaClient.listTableMetadata(crossinline block: ListTableMetadataRequest.Builder.() -> Unit): ListTableMetadataResponse = listTableMetadata(ListTableMetadataRequest.Builder().apply(block).build())

/**
 * Lists the tags associated with an Athena resource.
 */
public suspend inline fun AthenaClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists available workgroups for the account.
 */
public suspend inline fun AthenaClient.listWorkGroups(crossinline block: ListWorkGroupsRequest.Builder.() -> Unit): ListWorkGroupsResponse = listWorkGroups(ListWorkGroupsRequest.Builder().apply(block).build())

/**
 * Puts a new capacity assignment configuration for a specified capacity reservation. If a capacity assignment configuration already exists for the capacity reservation, replaces the existing capacity assignment configuration.
 */
public suspend inline fun AthenaClient.putCapacityAssignmentConfiguration(crossinline block: PutCapacityAssignmentConfigurationRequest.Builder.() -> Unit): PutCapacityAssignmentConfigurationResponse = putCapacityAssignmentConfiguration(PutCapacityAssignmentConfigurationRequest.Builder().apply(block).build())

/**
 * Submits calculations for execution within a session. You can supply the code to run as an inline code block within the request.
 *
 * The request syntax requires the StartCalculationExecutionRequest$CodeBlock parameter or the CalculationConfiguration$CodeBlock parameter, but not both. Because CalculationConfiguration$CodeBlock is deprecated, use the StartCalculationExecutionRequest$CodeBlock parameter instead.
 */
public suspend inline fun AthenaClient.startCalculationExecution(crossinline block: StartCalculationExecutionRequest.Builder.() -> Unit): StartCalculationExecutionResponse = startCalculationExecution(StartCalculationExecutionRequest.Builder().apply(block).build())

/**
 * Runs the SQL query statements contained in the `Query`. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires GetDataCatalog permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
 */
public suspend inline fun AthenaClient.startQueryExecution(crossinline block: StartQueryExecutionRequest.Builder.() -> Unit): StartQueryExecutionResponse = startQueryExecution(StartQueryExecutionRequest.Builder().apply(block).build())

/**
 * Creates a session for running calculations within a workgroup. The session is ready when it reaches an `IDLE` state.
 */
public suspend inline fun AthenaClient.startSession(crossinline block: StartSessionRequest.Builder.() -> Unit): StartSessionResponse = startSession(StartSessionRequest.Builder().apply(block).build())

/**
 * Requests the cancellation of a calculation. A `StopCalculationExecution` call on a calculation that is already in a terminal state (for example, `STOPPED`, `FAILED`, or `COMPLETED`) succeeds but has no effect.
 *
 * Cancelling a calculation is done on a best effort basis. If a calculation cannot be cancelled, you can be charged for its completion. If you are concerned about being charged for a calculation that cannot be cancelled, consider terminating the session in which the calculation is running.
 */
public suspend inline fun AthenaClient.stopCalculationExecution(crossinline block: StopCalculationExecutionRequest.Builder.() -> Unit): StopCalculationExecutionResponse = stopCalculationExecution(StopCalculationExecutionRequest.Builder().apply(block).build())

/**
 * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
 */
public suspend inline fun AthenaClient.stopQueryExecution(crossinline block: StopQueryExecutionRequest.Builder.() -> Unit): StopQueryExecutionResponse = stopQueryExecution(StopQueryExecutionRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter the resources in your account. For best practices, see [Tagging Best Practices](https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html). Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.
 */
public suspend inline fun AthenaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Terminates an active session. A `TerminateSession` call on a session that is already inactive (for example, in a `FAILED`, `TERMINATED` or `TERMINATING` state) succeeds but has no effect. Calculations running in the session when `TerminateSession` is called are forcefully stopped, but may display as `FAILED` instead of `STOPPED`.
 */
public suspend inline fun AthenaClient.terminateSession(crossinline block: TerminateSessionRequest.Builder.() -> Unit): TerminateSessionResponse = terminateSession(TerminateSessionRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from an Athena resource.
 */
public suspend inline fun AthenaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the number of requested data processing units for the capacity reservation with the specified name.
 */
public suspend inline fun AthenaClient.updateCapacityReservation(crossinline block: UpdateCapacityReservationRequest.Builder.() -> Unit): UpdateCapacityReservationResponse = updateCapacityReservation(UpdateCapacityReservationRequest.Builder().apply(block).build())

/**
 * Updates the data catalog that has the specified name.
 */
public suspend inline fun AthenaClient.updateDataCatalog(crossinline block: UpdateDataCatalogRequest.Builder.() -> Unit): UpdateDataCatalogResponse = updateDataCatalog(UpdateDataCatalogRequest.Builder().apply(block).build())

/**
 * Updates a NamedQuery object. The database or workgroup cannot be updated.
 */
public suspend inline fun AthenaClient.updateNamedQuery(crossinline block: UpdateNamedQueryRequest.Builder.() -> Unit): UpdateNamedQueryResponse = updateNamedQuery(UpdateNamedQueryRequest.Builder().apply(block).build())

/**
 * Updates the contents of a Spark notebook.
 */
public suspend inline fun AthenaClient.updateNotebook(crossinline block: UpdateNotebookRequest.Builder.() -> Unit): UpdateNotebookResponse = updateNotebook(UpdateNotebookRequest.Builder().apply(block).build())

/**
 * Updates the metadata for a notebook.
 */
public suspend inline fun AthenaClient.updateNotebookMetadata(crossinline block: UpdateNotebookMetadataRequest.Builder.() -> Unit): UpdateNotebookMetadataResponse = updateNotebookMetadata(UpdateNotebookMetadataRequest.Builder().apply(block).build())

/**
 * Updates a prepared statement.
 */
public suspend inline fun AthenaClient.updatePreparedStatement(crossinline block: UpdatePreparedStatementRequest.Builder.() -> Unit): UpdatePreparedStatementResponse = updatePreparedStatement(UpdatePreparedStatementRequest.Builder().apply(block).build())

/**
 * Updates the workgroup with the specified name. The workgroup's name cannot be changed. Only `ConfigurationUpdates` can be specified.
 */
public suspend inline fun AthenaClient.updateWorkGroup(crossinline block: UpdateWorkGroupRequest.Builder.() -> Unit): UpdateWorkGroupResponse = updateWorkGroup(UpdateWorkGroupRequest.Builder().apply(block).build())
