// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.athena.model.AthenaException
import aws.sdk.kotlin.services.athena.model.GetQueryRuntimeStatisticsResponse
import aws.sdk.kotlin.services.athena.model.QueryRuntimeStatistics
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetQueryRuntimeStatisticsOperationDeserializer: HttpDeserialize<GetQueryRuntimeStatisticsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetQueryRuntimeStatisticsResponse {
        if (!response.status.isSuccess()) {
            throwGetQueryRuntimeStatisticsError(context, response)
        }
        val builder = GetQueryRuntimeStatisticsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetQueryRuntimeStatisticsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetQueryRuntimeStatisticsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AthenaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AthenaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQueryRuntimeStatisticsOperationBody(builder: GetQueryRuntimeStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val QUERYRUNTIMESTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueryRuntimeStatistics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(QUERYRUNTIMESTATISTICS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                QUERYRUNTIMESTATISTICS_DESCRIPTOR.index -> builder.queryRuntimeStatistics = deserializeQueryRuntimeStatisticsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
