// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.athena.model.AthenaException
import aws.sdk.kotlin.services.athena.model.DataCatalog
import aws.sdk.kotlin.services.athena.model.GetDataCatalogResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDataCatalogOperationDeserializer: HttpDeserialize<GetDataCatalogResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDataCatalogResponse {
        if (!response.status.isSuccess()) {
            throwGetDataCatalogError(context, response)
        }
        val builder = GetDataCatalogResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDataCatalogOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDataCatalogError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AthenaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AthenaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDataCatalogOperationBody(builder: GetDataCatalogResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATACATALOG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataCatalog"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATACATALOG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATACATALOG_DESCRIPTOR.index -> builder.dataCatalog = deserializeDataCatalogDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
