// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.athena.model.AthenaException
import aws.sdk.kotlin.services.athena.model.BatchGetQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.QueryExecution
import aws.sdk.kotlin.services.athena.model.UnprocessedQueryExecutionId
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchGetQueryExecutionOperationDeserializer: HttpDeserialize<BatchGetQueryExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetQueryExecutionResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetQueryExecutionError(context, response)
        }
        val builder = BatchGetQueryExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetQueryExecutionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetQueryExecutionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AthenaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AthenaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetQueryExecutionOperationBody(builder: BatchGetQueryExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val QUERYEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("QueryExecutions"))
    val UNPROCESSEDQUERYEXECUTIONIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedQueryExecutionIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(QUERYEXECUTIONS_DESCRIPTOR)
        field(UNPROCESSEDQUERYEXECUTIONIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                QUERYEXECUTIONS_DESCRIPTOR.index -> builder.queryExecutions =
                    deserializer.deserializeList(QUERYEXECUTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<QueryExecution>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeQueryExecutionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDQUERYEXECUTIONIDS_DESCRIPTOR.index -> builder.unprocessedQueryExecutionIds =
                    deserializer.deserializeList(UNPROCESSEDQUERYEXECUTIONIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedQueryExecutionId>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedQueryExecutionIdDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
