// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.athena.model.AthenaException
import aws.sdk.kotlin.services.athena.model.BatchGetPreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.PreparedStatement
import aws.sdk.kotlin.services.athena.model.UnprocessedPreparedStatementName
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchGetPreparedStatementOperationDeserializer: HttpDeserialize<BatchGetPreparedStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetPreparedStatementResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetPreparedStatementError(context, response)
        }
        val builder = BatchGetPreparedStatementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetPreparedStatementOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetPreparedStatementError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AthenaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AthenaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetPreparedStatementOperationBody(builder: BatchGetPreparedStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PREPAREDSTATEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PreparedStatements"))
    val UNPROCESSEDPREPAREDSTATEMENTNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedPreparedStatementNames"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PREPAREDSTATEMENTS_DESCRIPTOR)
        field(UNPROCESSEDPREPAREDSTATEMENTNAMES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PREPAREDSTATEMENTS_DESCRIPTOR.index -> builder.preparedStatements =
                    deserializer.deserializeList(PREPAREDSTATEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PreparedStatement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePreparedStatementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDPREPAREDSTATEMENTNAMES_DESCRIPTOR.index -> builder.unprocessedPreparedStatementNames =
                    deserializer.deserializeList(UNPROCESSEDPREPAREDSTATEMENTNAMES_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedPreparedStatementName>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedPreparedStatementNameDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
