// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.athena.model.AthenaException
import aws.sdk.kotlin.services.athena.model.BatchGetNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.NamedQuery
import aws.sdk.kotlin.services.athena.model.UnprocessedNamedQueryId
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchGetNamedQueryOperationDeserializer: HttpDeserialize<BatchGetNamedQueryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetNamedQueryResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetNamedQueryError(context, response)
        }
        val builder = BatchGetNamedQueryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetNamedQueryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetNamedQueryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AthenaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AthenaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetNamedQueryOperationBody(builder: BatchGetNamedQueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NAMEDQUERIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NamedQueries"))
    val UNPROCESSEDNAMEDQUERYIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedNamedQueryIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAMEDQUERIES_DESCRIPTOR)
        field(UNPROCESSEDNAMEDQUERYIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NAMEDQUERIES_DESCRIPTOR.index -> builder.namedQueries =
                    deserializer.deserializeList(NAMEDQUERIES_DESCRIPTOR) {
                        val col0 = mutableListOf<NamedQuery>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNamedQueryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDNAMEDQUERYIDS_DESCRIPTOR.index -> builder.unprocessedNamedQueryIds =
                    deserializer.deserializeList(UNPROCESSEDNAMEDQUERYIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedNamedQueryId>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedNamedQueryIdDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
