// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.paginators

import aws.sdk.kotlin.services.athena.AthenaClient
import aws.sdk.kotlin.services.athena.model.DataCatalogSummary
import aws.sdk.kotlin.services.athena.model.Database
import aws.sdk.kotlin.services.athena.model.GetQueryResultsRequest
import aws.sdk.kotlin.services.athena.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.athena.model.ListDataCatalogsRequest
import aws.sdk.kotlin.services.athena.model.ListDataCatalogsResponse
import aws.sdk.kotlin.services.athena.model.ListDatabasesRequest
import aws.sdk.kotlin.services.athena.model.ListDatabasesResponse
import aws.sdk.kotlin.services.athena.model.ListEngineVersionsRequest
import aws.sdk.kotlin.services.athena.model.ListEngineVersionsResponse
import aws.sdk.kotlin.services.athena.model.ListNamedQueriesRequest
import aws.sdk.kotlin.services.athena.model.ListNamedQueriesResponse
import aws.sdk.kotlin.services.athena.model.ListPreparedStatementsRequest
import aws.sdk.kotlin.services.athena.model.ListPreparedStatementsResponse
import aws.sdk.kotlin.services.athena.model.ListQueryExecutionsRequest
import aws.sdk.kotlin.services.athena.model.ListQueryExecutionsResponse
import aws.sdk.kotlin.services.athena.model.ListTableMetadataRequest
import aws.sdk.kotlin.services.athena.model.ListTableMetadataResponse
import aws.sdk.kotlin.services.athena.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.athena.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.athena.model.ListWorkGroupsRequest
import aws.sdk.kotlin.services.athena.model.ListWorkGroupsResponse
import aws.sdk.kotlin.services.athena.model.TableMetadata
import aws.sdk.kotlin.services.athena.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetQueryResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetQueryResultsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetQueryResultsResponse]
 */
public fun AthenaClient.getQueryResultsPaginated(initialRequest: GetQueryResultsRequest): Flow<GetQueryResultsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getQueryResultsPaginated.getQueryResults(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetQueryResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetQueryResultsResponse]
 */
public fun AthenaClient.getQueryResultsPaginated(block: GetQueryResultsRequest.Builder.() -> Unit): Flow<GetQueryResultsResponse> =
    getQueryResultsPaginated(GetQueryResultsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDatabasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatabasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatabasesResponse]
 */
public fun AthenaClient.listDatabasesPaginated(initialRequest: ListDatabasesRequest): Flow<ListDatabasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatabasesPaginated.listDatabases(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatabasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatabasesResponse]
 */
public fun AthenaClient.listDatabasesPaginated(block: ListDatabasesRequest.Builder.() -> Unit): Flow<ListDatabasesResponse> =
    listDatabasesPaginated(ListDatabasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatabasesPaginated]
 * to access the nested member [Database]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Database]
 */
@JvmName("listDatabasesResponseDatabase")
public fun Flow<ListDatabasesResponse>.databaseList(): Flow<Database> =
    transform() { response ->
        response.databaseList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataCatalogsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataCatalogsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataCatalogsResponse]
 */
public fun AthenaClient.listDataCatalogsPaginated(initialRequest: ListDataCatalogsRequest): Flow<ListDataCatalogsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataCatalogsPaginated.listDataCatalogs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataCatalogsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataCatalogsResponse]
 */
public fun AthenaClient.listDataCatalogsPaginated(block: ListDataCatalogsRequest.Builder.() -> Unit): Flow<ListDataCatalogsResponse> =
    listDataCatalogsPaginated(ListDataCatalogsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataCatalogsPaginated]
 * to access the nested member [DataCatalogSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataCatalogSummary]
 */
@JvmName("listDataCatalogsResponseDataCatalogSummary")
public fun Flow<ListDataCatalogsResponse>.dataCatalogsSummary(): Flow<DataCatalogSummary> =
    transform() { response ->
        response.dataCatalogsSummary?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEngineVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEngineVersionsResponse]
 */
public fun AthenaClient.listEngineVersionsPaginated(initialRequest: ListEngineVersionsRequest): Flow<ListEngineVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEngineVersionsPaginated.listEngineVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEngineVersionsResponse]
 */
public fun AthenaClient.listEngineVersionsPaginated(block: ListEngineVersionsRequest.Builder.() -> Unit): Flow<ListEngineVersionsResponse> =
    listEngineVersionsPaginated(ListEngineVersionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNamedQueriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNamedQueriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNamedQueriesResponse]
 */
public fun AthenaClient.listNamedQueriesPaginated(initialRequest: ListNamedQueriesRequest): Flow<ListNamedQueriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNamedQueriesPaginated.listNamedQueries(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNamedQueriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNamedQueriesResponse]
 */
public fun AthenaClient.listNamedQueriesPaginated(block: ListNamedQueriesRequest.Builder.() -> Unit): Flow<ListNamedQueriesResponse> =
    listNamedQueriesPaginated(ListNamedQueriesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPreparedStatementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPreparedStatementsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPreparedStatementsResponse]
 */
public fun AthenaClient.listPreparedStatementsPaginated(initialRequest: ListPreparedStatementsRequest): Flow<ListPreparedStatementsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPreparedStatementsPaginated.listPreparedStatements(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPreparedStatementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPreparedStatementsResponse]
 */
public fun AthenaClient.listPreparedStatementsPaginated(block: ListPreparedStatementsRequest.Builder.() -> Unit): Flow<ListPreparedStatementsResponse> =
    listPreparedStatementsPaginated(ListPreparedStatementsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListQueryExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueryExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueryExecutionsResponse]
 */
public fun AthenaClient.listQueryExecutionsPaginated(initialRequest: ListQueryExecutionsRequest): Flow<ListQueryExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueryExecutionsPaginated.listQueryExecutions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQueryExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueryExecutionsResponse]
 */
public fun AthenaClient.listQueryExecutionsPaginated(block: ListQueryExecutionsRequest.Builder.() -> Unit): Flow<ListQueryExecutionsResponse> =
    listQueryExecutionsPaginated(ListQueryExecutionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTableMetadataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTableMetadataRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableMetadataResponse]
 */
public fun AthenaClient.listTableMetadataPaginated(initialRequest: ListTableMetadataRequest): Flow<ListTableMetadataResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTableMetadataPaginated.listTableMetadata(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTableMetadataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableMetadataResponse]
 */
public fun AthenaClient.listTableMetadataPaginated(block: ListTableMetadataRequest.Builder.() -> Unit): Flow<ListTableMetadataResponse> =
    listTableMetadataPaginated(ListTableMetadataRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTableMetadataPaginated]
 * to access the nested member [TableMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TableMetadata]
 */
@JvmName("listTableMetadataResponseTableMetadata")
public fun Flow<ListTableMetadataResponse>.tableMetadataList(): Flow<TableMetadata> =
    transform() { response ->
        response.tableMetadataList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun AthenaClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun AthenaClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkGroupsResponse]
 */
public fun AthenaClient.listWorkGroupsPaginated(initialRequest: ListWorkGroupsRequest): Flow<ListWorkGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkGroupsPaginated.listWorkGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkGroupsResponse]
 */
public fun AthenaClient.listWorkGroupsPaginated(block: ListWorkGroupsRequest.Builder.() -> Unit): Flow<ListWorkGroupsResponse> =
    listWorkGroupsPaginated(ListWorkGroupsRequest.Builder().apply(block).build())
