// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
 */
public class WorkGroupConfigurationUpdates private constructor(builder: Builder) {
    /**
     * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     */
    public val bytesScannedCutoffPerQuery: kotlin.Long? = builder.bytesScannedCutoffPerQuery
    /**
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side settings are used. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
     */
    public val enforceWorkGroupConfiguration: kotlin.Boolean? = builder.enforceWorkGroupConfiguration
    /**
     * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on the requested engine version. If no value was previously set, the default is Auto. Queries on the `AmazonAthenaPreviewFunctionality` workgroup run on the preview engine regardless of this setting.
     */
    public val engineVersion: aws.sdk.kotlin.services.athena.model.EngineVersion? = builder.engineVersion
    /**
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     */
    public val publishCloudWatchMetricsEnabled: kotlin.Boolean? = builder.publishCloudWatchMetricsEnabled
    /**
     * Indicates that the data usage control limit per query is removed. WorkGroupConfiguration$BytesScannedCutoffPerQuery
     */
    public val removeBytesScannedCutoffPerQuery: kotlin.Boolean? = builder.removeBytesScannedCutoffPerQuery
    /**
     * If set to `true`, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to `false`, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false`. For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide*.
     */
    public val requesterPaysEnabled: kotlin.Boolean? = builder.requesterPaysEnabled
    /**
     * The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results.
     */
    public val resultConfigurationUpdates: aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates? = builder.resultConfigurationUpdates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.WorkGroupConfigurationUpdates = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkGroupConfigurationUpdates(")
        append("bytesScannedCutoffPerQuery=$bytesScannedCutoffPerQuery,")
        append("enforceWorkGroupConfiguration=$enforceWorkGroupConfiguration,")
        append("engineVersion=$engineVersion,")
        append("publishCloudWatchMetricsEnabled=$publishCloudWatchMetricsEnabled,")
        append("removeBytesScannedCutoffPerQuery=$removeBytesScannedCutoffPerQuery,")
        append("requesterPaysEnabled=$requesterPaysEnabled,")
        append("resultConfigurationUpdates=$resultConfigurationUpdates)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesScannedCutoffPerQuery?.hashCode() ?: 0
        result = 31 * result + (enforceWorkGroupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (publishCloudWatchMetricsEnabled?.hashCode() ?: 0)
        result = 31 * result + (removeBytesScannedCutoffPerQuery?.hashCode() ?: 0)
        result = 31 * result + (requesterPaysEnabled?.hashCode() ?: 0)
        result = 31 * result + (resultConfigurationUpdates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkGroupConfigurationUpdates

        if (bytesScannedCutoffPerQuery != other.bytesScannedCutoffPerQuery) return false
        if (enforceWorkGroupConfiguration != other.enforceWorkGroupConfiguration) return false
        if (engineVersion != other.engineVersion) return false
        if (publishCloudWatchMetricsEnabled != other.publishCloudWatchMetricsEnabled) return false
        if (removeBytesScannedCutoffPerQuery != other.removeBytesScannedCutoffPerQuery) return false
        if (requesterPaysEnabled != other.requesterPaysEnabled) return false
        if (resultConfigurationUpdates != other.resultConfigurationUpdates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.WorkGroupConfigurationUpdates = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         */
        public var bytesScannedCutoffPerQuery: kotlin.Long? = null
        /**
         * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side settings are used. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
         */
        public var enforceWorkGroupConfiguration: kotlin.Boolean? = null
        /**
         * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on the requested engine version. If no value was previously set, the default is Auto. Queries on the `AmazonAthenaPreviewFunctionality` workgroup run on the preview engine regardless of this setting.
         */
        public var engineVersion: aws.sdk.kotlin.services.athena.model.EngineVersion? = null
        /**
         * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
         */
        public var publishCloudWatchMetricsEnabled: kotlin.Boolean? = null
        /**
         * Indicates that the data usage control limit per query is removed. WorkGroupConfiguration$BytesScannedCutoffPerQuery
         */
        public var removeBytesScannedCutoffPerQuery: kotlin.Boolean? = null
        /**
         * If set to `true`, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to `false`, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false`. For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide*.
         */
        public var requesterPaysEnabled: kotlin.Boolean? = null
        /**
         * The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results.
         */
        public var resultConfigurationUpdates: aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.WorkGroupConfigurationUpdates) : this() {
            this.bytesScannedCutoffPerQuery = x.bytesScannedCutoffPerQuery
            this.enforceWorkGroupConfiguration = x.enforceWorkGroupConfiguration
            this.engineVersion = x.engineVersion
            this.publishCloudWatchMetricsEnabled = x.publishCloudWatchMetricsEnabled
            this.removeBytesScannedCutoffPerQuery = x.removeBytesScannedCutoffPerQuery
            this.requesterPaysEnabled = x.requesterPaysEnabled
            this.resultConfigurationUpdates = x.resultConfigurationUpdates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.WorkGroupConfigurationUpdates = WorkGroupConfigurationUpdates(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.EngineVersion] inside the given [block]
         */
        public fun engineVersion(block: aws.sdk.kotlin.services.athena.model.EngineVersion.Builder.() -> kotlin.Unit) {
            this.engineVersion = aws.sdk.kotlin.services.athena.model.EngineVersion.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates] inside the given [block]
         */
        public fun resultConfigurationUpdates(block: aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates.Builder.() -> kotlin.Unit) {
            this.resultConfigurationUpdates = aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates.invoke(block)
        }
    }
}
