// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Stage statistics such as input and output rows and bytes, execution time and stage state. This information also includes substages and the query stage plan.
 */
public class QueryStage private constructor(builder: Builder) {
    /**
     * Time taken to execute this stage.
     */
    public val executionTime: kotlin.Long? = builder.executionTime
    /**
     * The number of bytes input into the stage for execution.
     */
    public val inputBytes: kotlin.Long? = builder.inputBytes
    /**
     * The number of rows input into the stage for execution.
     */
    public val inputRows: kotlin.Long? = builder.inputRows
    /**
     * The number of bytes output from the stage after execution.
     */
    public val outputBytes: kotlin.Long? = builder.outputBytes
    /**
     * The number of rows output from the stage after execution.
     */
    public val outputRows: kotlin.Long? = builder.outputRows
    /**
     * Stage plan information such as name, identifier, sub plans, and source stages.
     */
    public val queryStagePlan: aws.sdk.kotlin.services.athena.model.QueryStagePlanNode? = builder.queryStagePlan
    /**
     * The identifier for a stage.
     */
    public val stageId: kotlin.Long? = builder.stageId
    /**
     * State of the stage after query execution.
     */
    public val state: kotlin.String? = builder.state
    /**
     * List of sub query stages that form this stage execution plan.
     */
    public val subStages: List<QueryStage>? = builder.subStages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.QueryStage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryStage(")
        append("executionTime=$executionTime,")
        append("inputBytes=$inputBytes,")
        append("inputRows=$inputRows,")
        append("outputBytes=$outputBytes,")
        append("outputRows=$outputRows,")
        append("queryStagePlan=$queryStagePlan,")
        append("stageId=$stageId,")
        append("state=$state,")
        append("subStages=$subStages)")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionTime?.hashCode() ?: 0
        result = 31 * result + (inputBytes?.hashCode() ?: 0)
        result = 31 * result + (inputRows?.hashCode() ?: 0)
        result = 31 * result + (outputBytes?.hashCode() ?: 0)
        result = 31 * result + (outputRows?.hashCode() ?: 0)
        result = 31 * result + (queryStagePlan?.hashCode() ?: 0)
        result = 31 * result + (stageId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subStages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryStage

        if (executionTime != other.executionTime) return false
        if (inputBytes != other.inputBytes) return false
        if (inputRows != other.inputRows) return false
        if (outputBytes != other.outputBytes) return false
        if (outputRows != other.outputRows) return false
        if (queryStagePlan != other.queryStagePlan) return false
        if (stageId != other.stageId) return false
        if (state != other.state) return false
        if (subStages != other.subStages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.QueryStage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Time taken to execute this stage.
         */
        public var executionTime: kotlin.Long? = null
        /**
         * The number of bytes input into the stage for execution.
         */
        public var inputBytes: kotlin.Long? = null
        /**
         * The number of rows input into the stage for execution.
         */
        public var inputRows: kotlin.Long? = null
        /**
         * The number of bytes output from the stage after execution.
         */
        public var outputBytes: kotlin.Long? = null
        /**
         * The number of rows output from the stage after execution.
         */
        public var outputRows: kotlin.Long? = null
        /**
         * Stage plan information such as name, identifier, sub plans, and source stages.
         */
        public var queryStagePlan: aws.sdk.kotlin.services.athena.model.QueryStagePlanNode? = null
        /**
         * The identifier for a stage.
         */
        public var stageId: kotlin.Long? = null
        /**
         * State of the stage after query execution.
         */
        public var state: kotlin.String? = null
        /**
         * List of sub query stages that form this stage execution plan.
         */
        public var subStages: List<QueryStage>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.QueryStage) : this() {
            this.executionTime = x.executionTime
            this.inputBytes = x.inputBytes
            this.inputRows = x.inputRows
            this.outputBytes = x.outputBytes
            this.outputRows = x.outputRows
            this.queryStagePlan = x.queryStagePlan
            this.stageId = x.stageId
            this.state = x.state
            this.subStages = x.subStages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.QueryStage = QueryStage(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.QueryStagePlanNode] inside the given [block]
         */
        public fun queryStagePlan(block: aws.sdk.kotlin.services.athena.model.QueryStagePlanNode.Builder.() -> kotlin.Unit) {
            this.queryStagePlan = aws.sdk.kotlin.services.athena.model.QueryStagePlanNode.invoke(block)
        }
    }
}
