// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The completion date, current state, submission time, and state change reason (if applicable) for the query execution.
 */
public class QueryExecutionStatus private constructor(builder: Builder) {
    /**
     * Provides information about an Athena query error.
     */
    public val athenaError: aws.sdk.kotlin.services.athena.model.AthenaError? = builder.athenaError
    /**
     * The date and time that the query completed.
     */
    public val completionDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDateTime
    /**
     * The state of query execution. `QUEUED` indicates that the query has been submitted to the service, and Athena will execute the query as soon as resources are available. `RUNNING` indicates that the query is in execution phase. `SUCCEEDED` indicates that the query completed without errors. `FAILED` indicates that the query experienced an error and did not complete processing. `CANCELLED` indicates that a user input interrupted query execution.
     *
     * Athena automatically retries your queries in cases of certain transient errors. As a result, you may see the query state transition from `RUNNING` or `FAILED` to `QUEUED`.
     */
    public val state: aws.sdk.kotlin.services.athena.model.QueryExecutionState? = builder.state
    /**
     * Further detail about the status of the query.
     */
    public val stateChangeReason: kotlin.String? = builder.stateChangeReason
    /**
     * The date and time that the query was submitted.
     */
    public val submissionDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submissionDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.QueryExecutionStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryExecutionStatus(")
        append("athenaError=$athenaError,")
        append("completionDateTime=$completionDateTime,")
        append("state=$state,")
        append("stateChangeReason=$stateChangeReason,")
        append("submissionDateTime=$submissionDateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = athenaError?.hashCode() ?: 0
        result = 31 * result + (completionDateTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (submissionDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryExecutionStatus

        if (athenaError != other.athenaError) return false
        if (completionDateTime != other.completionDateTime) return false
        if (state != other.state) return false
        if (stateChangeReason != other.stateChangeReason) return false
        if (submissionDateTime != other.submissionDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.QueryExecutionStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides information about an Athena query error.
         */
        public var athenaError: aws.sdk.kotlin.services.athena.model.AthenaError? = null
        /**
         * The date and time that the query completed.
         */
        public var completionDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of query execution. `QUEUED` indicates that the query has been submitted to the service, and Athena will execute the query as soon as resources are available. `RUNNING` indicates that the query is in execution phase. `SUCCEEDED` indicates that the query completed without errors. `FAILED` indicates that the query experienced an error and did not complete processing. `CANCELLED` indicates that a user input interrupted query execution.
         *
         * Athena automatically retries your queries in cases of certain transient errors. As a result, you may see the query state transition from `RUNNING` or `FAILED` to `QUEUED`.
         */
        public var state: aws.sdk.kotlin.services.athena.model.QueryExecutionState? = null
        /**
         * Further detail about the status of the query.
         */
        public var stateChangeReason: kotlin.String? = null
        /**
         * The date and time that the query was submitted.
         */
        public var submissionDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.QueryExecutionStatus) : this() {
            this.athenaError = x.athenaError
            this.completionDateTime = x.completionDateTime
            this.state = x.state
            this.stateChangeReason = x.stateChangeReason
            this.submissionDateTime = x.submissionDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.QueryExecutionStatus = QueryExecutionStatus(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.AthenaError] inside the given [block]
         */
        public fun athenaError(block: aws.sdk.kotlin.services.athena.model.AthenaError.Builder.() -> kotlin.Unit) {
            this.athenaError = aws.sdk.kotlin.services.athena.model.AthenaError.invoke(block)
        }
    }
}
