// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * The amount of data scanned during the query execution and the amount of time that it took to execute, and the type of statement that was run.
 */
public class QueryExecutionStatistics private constructor(builder: Builder) {
    /**
     * The location and file name of a data manifest file. The manifest file is saved to the Athena query results location in Amazon S3. The manifest file tracks files that the query wrote to Amazon S3. If the query fails, the manifest file also tracks files that the query intended to write. The manifest is useful for identifying orphaned files resulting from a failed query. For more information, see [Working with Query Results, Output Files, and Query History](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*.
     */
    public val dataManifestLocation: kotlin.String? = builder.dataManifestLocation
    /**
     * The number of bytes in the data that was queried.
     */
    public val dataScannedInBytes: kotlin.Long? = builder.dataScannedInBytes
    /**
     * The number of milliseconds that the query took to execute.
     */
    public val engineExecutionTimeInMillis: kotlin.Long? = builder.engineExecutionTimeInMillis
    /**
     * The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent retrieving table partitions from the data source. Note that because the query engine performs the query planning, query planning time is a subset of engine processing time.
     */
    public val queryPlanningTimeInMillis: kotlin.Long? = builder.queryPlanningTimeInMillis
    /**
     * The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient errors occur, Athena might automatically add the query back to the queue.
     */
    public val queryQueueTimeInMillis: kotlin.Long? = builder.queryQueueTimeInMillis
    /**
     * The number of milliseconds that Athena took to finalize and publish the query results after the query engine finished running the query.
     */
    public val serviceProcessingTimeInMillis: kotlin.Long? = builder.serviceProcessingTimeInMillis
    /**
     * The number of milliseconds that Athena took to run the query.
     */
    public val totalExecutionTimeInMillis: kotlin.Long? = builder.totalExecutionTimeInMillis

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryExecutionStatistics(")
        append("dataManifestLocation=$dataManifestLocation,")
        append("dataScannedInBytes=$dataScannedInBytes,")
        append("engineExecutionTimeInMillis=$engineExecutionTimeInMillis,")
        append("queryPlanningTimeInMillis=$queryPlanningTimeInMillis,")
        append("queryQueueTimeInMillis=$queryQueueTimeInMillis,")
        append("serviceProcessingTimeInMillis=$serviceProcessingTimeInMillis,")
        append("totalExecutionTimeInMillis=$totalExecutionTimeInMillis)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataManifestLocation?.hashCode() ?: 0
        result = 31 * result + (dataScannedInBytes?.hashCode() ?: 0)
        result = 31 * result + (engineExecutionTimeInMillis?.hashCode() ?: 0)
        result = 31 * result + (queryPlanningTimeInMillis?.hashCode() ?: 0)
        result = 31 * result + (queryQueueTimeInMillis?.hashCode() ?: 0)
        result = 31 * result + (serviceProcessingTimeInMillis?.hashCode() ?: 0)
        result = 31 * result + (totalExecutionTimeInMillis?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryExecutionStatistics

        if (dataManifestLocation != other.dataManifestLocation) return false
        if (dataScannedInBytes != other.dataScannedInBytes) return false
        if (engineExecutionTimeInMillis != other.engineExecutionTimeInMillis) return false
        if (queryPlanningTimeInMillis != other.queryPlanningTimeInMillis) return false
        if (queryQueueTimeInMillis != other.queryQueueTimeInMillis) return false
        if (serviceProcessingTimeInMillis != other.serviceProcessingTimeInMillis) return false
        if (totalExecutionTimeInMillis != other.totalExecutionTimeInMillis) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The location and file name of a data manifest file. The manifest file is saved to the Athena query results location in Amazon S3. The manifest file tracks files that the query wrote to Amazon S3. If the query fails, the manifest file also tracks files that the query intended to write. The manifest is useful for identifying orphaned files resulting from a failed query. For more information, see [Working with Query Results, Output Files, and Query History](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*.
         */
        public var dataManifestLocation: kotlin.String? = null
        /**
         * The number of bytes in the data that was queried.
         */
        public var dataScannedInBytes: kotlin.Long? = null
        /**
         * The number of milliseconds that the query took to execute.
         */
        public var engineExecutionTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent retrieving table partitions from the data source. Note that because the query engine performs the query planning, query planning time is a subset of engine processing time.
         */
        public var queryPlanningTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient errors occur, Athena might automatically add the query back to the queue.
         */
        public var queryQueueTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that Athena took to finalize and publish the query results after the query engine finished running the query.
         */
        public var serviceProcessingTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that Athena took to run the query.
         */
        public var totalExecutionTimeInMillis: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics) : this() {
            this.dataManifestLocation = x.dataManifestLocation
            this.dataScannedInBytes = x.dataScannedInBytes
            this.engineExecutionTimeInMillis = x.engineExecutionTimeInMillis
            this.queryPlanningTimeInMillis = x.queryPlanningTimeInMillis
            this.queryQueueTimeInMillis = x.queryQueueTimeInMillis
            this.serviceProcessingTimeInMillis = x.serviceProcessingTimeInMillis
            this.totalExecutionTimeInMillis = x.totalExecutionTimeInMillis
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics = QueryExecutionStatistics(this)
    }
}
