// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS`) and key information.
 */
public class EncryptionConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used.
     *
     * If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
     */
    public val encryptionOption: aws.sdk.kotlin.services.athena.model.EncryptionOption? = builder.encryptionOption
    /**
     * For `SSE_KMS` and `CSE_KMS`, this is the KMS key ARN or ID.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.EncryptionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfiguration(")
        append("encryptionOption=$encryptionOption,")
        append("kmsKey=$kmsKey)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionOption?.hashCode() ?: 0
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfiguration

        if (encryptionOption != other.encryptionOption) return false
        if (kmsKey != other.kmsKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.EncryptionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used.
         *
         * If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
         */
        public var encryptionOption: aws.sdk.kotlin.services.athena.model.EncryptionOption? = null
        /**
         * For `SSE_KMS` and `CSE_KMS`, this is the KMS key ARN or ID.
         */
        public var kmsKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.EncryptionConfiguration) : this() {
            this.encryptionOption = x.encryptionOption
            this.kmsKey = x.kmsKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.EncryptionConfiguration = EncryptionConfiguration(this)
    }
}
