// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Contains information about a data catalog in an Amazon Web Services account.
 */
public class DataCatalog private constructor(builder: Builder) {
    /**
     * An optional description of the data catalog.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the data catalog. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The remainder of the length constraint of 256 is reserved for use by Athena.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the Lambda function or functions to use for the data catalog. This is a mapping whose values depend on the catalog type.
     * + For the `HIVE` data catalog type, use the following syntax. The `metadata-function` parameter is required. `The sdk-version` parameter is optional and defaults to the currently supported version.`metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> `
     * + For the `LAMBDA` data catalog type, use one of the following sets of required parameters, but not both.
     *    + If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.`metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> `
     *    +  If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.`function=<i>lambda_arn</i> `
     * + The `GLUE` type takes a catalog ID parameter and is required. The ` <i>catalog_id</i> ` is the account ID of the Amazon Web Services account to which the Glue catalog belongs.`catalog-id=<i>catalog_id</i> `
     *    + The `GLUE` data catalog type also applies to the default `AwsDataCatalog` that already exists in your account, of which you can have only one and cannot modify.
     *    + Queries that specify a Glue Data Catalog other than the default `AwsDataCatalog` must be run on Athena engine version 2.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The type of data catalog to create: `LAMBDA` for a federated catalog, `HIVE` for an external hive metastore, or `GLUE` for an Glue Data Catalog.
     */
    public val type: aws.sdk.kotlin.services.athena.model.DataCatalogType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.DataCatalog = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataCatalog(")
        append("description=$description,")
        append("name=$name,")
        append("parameters=$parameters,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataCatalog

        if (description != other.description) return false
        if (name != other.name) return false
        if (parameters != other.parameters) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.DataCatalog = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional description of the data catalog.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the data catalog. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The remainder of the length constraint of 256 is reserved for use by Athena.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the Lambda function or functions to use for the data catalog. This is a mapping whose values depend on the catalog type.
         * + For the `HIVE` data catalog type, use the following syntax. The `metadata-function` parameter is required. `The sdk-version` parameter is optional and defaults to the currently supported version.`metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> `
         * + For the `LAMBDA` data catalog type, use one of the following sets of required parameters, but not both.
         *    + If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.`metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> `
         *    +  If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.`function=<i>lambda_arn</i> `
         * + The `GLUE` type takes a catalog ID parameter and is required. The ` <i>catalog_id</i> ` is the account ID of the Amazon Web Services account to which the Glue catalog belongs.`catalog-id=<i>catalog_id</i> `
         *    + The `GLUE` data catalog type also applies to the default `AwsDataCatalog` that already exists in your account, of which you can have only one and cannot modify.
         *    + Queries that specify a Glue Data Catalog other than the default `AwsDataCatalog` must be run on Athena engine version 2.
         */
        public var parameters: Map<String, String>? = null
        /**
         * The type of data catalog to create: `LAMBDA` for a federated catalog, `HIVE` for an external hive metastore, or `GLUE` for an Glue Data Catalog.
         */
        public var type: aws.sdk.kotlin.services.athena.model.DataCatalogType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.DataCatalog) : this() {
            this.description = x.description
            this.name = x.name
            this.parameters = x.parameters
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.DataCatalog = DataCatalog(this)
    }
}
