// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class CreateNamedQueryRequest private constructor(builder: Builder) {
    /**
     * A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another `CreateNamedQuery` request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the `QueryString`, an error is returned.
     *
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The database to which the query belongs.
     */
    public val database: kotlin.String? = builder.database
    /**
     * The query description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The query name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The contents of the query with all query statements.
     */
    public val queryString: kotlin.String? = builder.queryString
    /**
     * The name of the workgroup in which the named query is being created.
     */
    public val workGroup: kotlin.String? = builder.workGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.CreateNamedQueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNamedQueryRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("database=$database,")
        append("description=$description,")
        append("name=$name,")
        append("queryString=$queryString,")
        append("workGroup=$workGroup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNamedQueryRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (database != other.database) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (queryString != other.queryString) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.CreateNamedQueryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another `CreateNamedQuery` request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the `QueryString`, an error is returned.
         *
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The database to which the query belongs.
         */
        public var database: kotlin.String? = null
        /**
         * The query description.
         */
        public var description: kotlin.String? = null
        /**
         * The query name.
         */
        public var name: kotlin.String? = null
        /**
         * The contents of the query with all query statements.
         */
        public var queryString: kotlin.String? = null
        /**
         * The name of the workgroup in which the named query is being created.
         */
        public var workGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.CreateNamedQueryRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.database = x.database
            this.description = x.description
            this.name = x.name
            this.queryString = x.queryString
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.CreateNamedQueryRequest = CreateNamedQueryRequest(this)
    }
}
