// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Provides information about an Athena query error. The `AthenaError` feature provides standardized error information to help you understand failed queries and take steps after a query failure occurs. `AthenaError` includes an `ErrorCategory` field that specifies whether the cause of the failed query is due to system error, user error, or other error.
 */
public class AthenaError private constructor(builder: Builder) {
    /**
     * An integer value that specifies the category of a query failure error. The following list shows the category for each integer value.
     *
     * **1** - System
     *
     * **2** - User
     *
     * **3** - Other
     */
    public val errorCategory: kotlin.Int? = builder.errorCategory
    /**
     * Contains a short description of the error that occurred.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * An integer value that provides specific information about an Athena query error. For the meaning of specific values, see the [Error Type Reference](https://docs.aws.amazon.com/athena/latest/ug/error-reference.html#error-reference-error-type-reference) in the *Amazon Athena User Guide*.
     */
    public val errorType: kotlin.Int? = builder.errorType
    /**
     * True if the query might succeed if resubmitted.
     */
    public val retryable: kotlin.Boolean = builder.retryable

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.AthenaError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AthenaError(")
        append("errorCategory=$errorCategory,")
        append("errorMessage=$errorMessage,")
        append("errorType=$errorType,")
        append("retryable=$retryable)")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCategory ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (errorType ?: 0)
        result = 31 * result + (retryable.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AthenaError

        if (errorCategory != other.errorCategory) return false
        if (errorMessage != other.errorMessage) return false
        if (errorType != other.errorType) return false
        if (retryable != other.retryable) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.AthenaError = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An integer value that specifies the category of a query failure error. The following list shows the category for each integer value.
         *
         * **1** - System
         *
         * **2** - User
         *
         * **3** - Other
         */
        public var errorCategory: kotlin.Int? = null
        /**
         * Contains a short description of the error that occurred.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * An integer value that provides specific information about an Athena query error. For the meaning of specific values, see the [Error Type Reference](https://docs.aws.amazon.com/athena/latest/ug/error-reference.html#error-reference-error-type-reference) in the *Amazon Athena User Guide*.
         */
        public var errorType: kotlin.Int? = null
        /**
         * True if the query might succeed if resubmitted.
         */
        public var retryable: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.AthenaError) : this() {
            this.errorCategory = x.errorCategory
            this.errorMessage = x.errorMessage
            this.errorType = x.errorType
            this.retryable = x.retryable
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.AthenaError = AthenaError(this)
    }
}
