// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. When Athena stores query results in Amazon S3, the canned ACL is set with the `x-amz-acl` request header. For more information about S3 Object Ownership, see [Object Ownership settings](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html#object-ownership-overview) in the *Amazon S3 User Guide*.
 */
public class AclConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL`. If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) in the *Amazon S3 User Guide*.
     */
    public val s3AclOption: aws.sdk.kotlin.services.athena.model.S3AclOption? = builder.s3AclOption

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.AclConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AclConfiguration(")
        append("s3AclOption=$s3AclOption)")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3AclOption?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AclConfiguration

        if (s3AclOption != other.s3AclOption) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.AclConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL`. If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) in the *Amazon S3 User Guide*.
         */
        public var s3AclOption: aws.sdk.kotlin.services.athena.model.S3AclOption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.AclConfiguration) : this() {
            this.s3AclOption = x.s3AclOption
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.AclConfiguration = AclConfiguration(this)
    }
}
