// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.athena.model.*
import aws.sdk.kotlin.services.athena.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Athena"
public const val ServiceApiVersion: String = "2017-05-18"
public const val SdkVersion: String = "0.17.5-beta"

internal class DefaultAthenaClient(override val config: AthenaClient.Config) : AthenaClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use ListNamedQueriesInput to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under UnprocessedNamedQueryId. Named queries differ from executed queries. Use BatchGetQueryExecutionInput to get details about each unique query execution, and ListQueryExecutionsInput to get a list of query execution IDs.
     */
    override suspend fun batchGetNamedQuery(input: BatchGetNamedQueryRequest): BatchGetNamedQueryResponse {
        val op = SdkHttpOperation.build<BatchGetNamedQueryRequest, BatchGetNamedQueryResponse> {
            serializer = BatchGetNamedQueryOperationSerializer()
            deserializer = BatchGetNamedQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetNamedQuery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in `UnprocessedPreparedStatementNames`.
     */
    override suspend fun batchGetPreparedStatement(input: BatchGetPreparedStatementRequest): BatchGetPreparedStatementResponse {
        val op = SdkHttpOperation.build<BatchGetPreparedStatementRequest, BatchGetPreparedStatementResponse> {
            serializer = BatchGetPreparedStatementOperationSerializer()
            deserializer = BatchGetPreparedStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetPreparedStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup. Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput to get details about named queries.
     */
    override suspend fun batchGetQueryExecution(input: BatchGetQueryExecutionRequest): BatchGetQueryExecutionResponse {
        val op = SdkHttpOperation.build<BatchGetQueryExecutionRequest, BatchGetQueryExecutionResponse> {
            serializer = BatchGetQueryExecutionOperationSerializer()
            deserializer = BatchGetQueryExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetQueryExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.
     */
    override suspend fun createDataCatalog(input: CreateDataCatalogRequest): CreateDataCatalogResponse {
        val op = SdkHttpOperation.build<CreateDataCatalogRequest, CreateDataCatalogResponse> {
            serializer = CreateDataCatalogOperationSerializer()
            deserializer = CreateDataCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    override suspend fun createNamedQuery(input: CreateNamedQueryRequest): CreateNamedQueryResponse {
        val op = SdkHttpOperation.build<CreateNamedQueryRequest, CreateNamedQueryResponse> {
            serializer = CreateNamedQueryOperationSerializer()
            deserializer = CreateNamedQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNamedQuery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a prepared statement for use with SQL queries in Athena.
     */
    override suspend fun createPreparedStatement(input: CreatePreparedStatementRequest): CreatePreparedStatementResponse {
        val op = SdkHttpOperation.build<CreatePreparedStatementRequest, CreatePreparedStatementResponse> {
            serializer = CreatePreparedStatementOperationSerializer()
            deserializer = CreatePreparedStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePreparedStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a workgroup with the specified name.
     */
    override suspend fun createWorkGroup(input: CreateWorkGroupRequest): CreateWorkGroupResponse {
        val op = SdkHttpOperation.build<CreateWorkGroupRequest, CreateWorkGroupResponse> {
            serializer = CreateWorkGroupOperationSerializer()
            deserializer = CreateWorkGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a data catalog.
     */
    override suspend fun deleteDataCatalog(input: DeleteDataCatalogRequest): DeleteDataCatalogResponse {
        val op = SdkHttpOperation.build<DeleteDataCatalogRequest, DeleteDataCatalogResponse> {
            serializer = DeleteDataCatalogOperationSerializer()
            deserializer = DeleteDataCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDataCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the named query if you have access to the workgroup in which the query was saved.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    override suspend fun deleteNamedQuery(input: DeleteNamedQueryRequest): DeleteNamedQueryResponse {
        val op = SdkHttpOperation.build<DeleteNamedQueryRequest, DeleteNamedQueryResponse> {
            serializer = DeleteNamedQueryOperationSerializer()
            deserializer = DeleteNamedQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNamedQuery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the prepared statement with the specified name from the specified workgroup.
     */
    override suspend fun deletePreparedStatement(input: DeletePreparedStatementRequest): DeletePreparedStatementResponse {
        val op = SdkHttpOperation.build<DeletePreparedStatementRequest, DeletePreparedStatementResponse> {
            serializer = DeletePreparedStatementOperationSerializer()
            deserializer = DeletePreparedStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePreparedStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
     */
    override suspend fun deleteWorkGroup(input: DeleteWorkGroupRequest): DeleteWorkGroupResponse {
        val op = SdkHttpOperation.build<DeleteWorkGroupRequest, DeleteWorkGroupResponse> {
            serializer = DeleteWorkGroupOperationSerializer()
            deserializer = DeleteWorkGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the specified data catalog.
     */
    override suspend fun getDataCatalog(input: GetDataCatalogRequest): GetDataCatalogResponse {
        val op = SdkHttpOperation.build<GetDataCatalogRequest, GetDataCatalogResponse> {
            serializer = GetDataCatalogOperationSerializer()
            deserializer = GetDataCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDataCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a database object for the specified database and data catalog.
     */
    override suspend fun getDatabase(input: GetDatabaseRequest): GetDatabaseResponse {
        val op = SdkHttpOperation.build<GetDatabaseRequest, GetDatabaseResponse> {
            serializer = GetDatabaseOperationSerializer()
            deserializer = GetDatabaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDatabase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.
     */
    override suspend fun getNamedQuery(input: GetNamedQueryRequest): GetNamedQueryResponse {
        val op = SdkHttpOperation.build<GetNamedQueryRequest, GetNamedQueryResponse> {
            serializer = GetNamedQueryOperationSerializer()
            deserializer = GetNamedQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNamedQuery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the prepared statement with the specified name from the specified workgroup.
     */
    override suspend fun getPreparedStatement(input: GetPreparedStatementRequest): GetPreparedStatementResponse {
        val op = SdkHttpOperation.build<GetPreparedStatementRequest, GetPreparedStatementResponse> {
            serializer = GetPreparedStatementOperationSerializer()
            deserializer = GetPreparedStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPreparedStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.
     */
    override suspend fun getQueryExecution(input: GetQueryExecutionRequest): GetQueryExecutionResponse {
        val op = SdkHttpOperation.build<GetQueryExecutionRequest, GetQueryExecutionResponse> {
            serializer = GetQueryExecutionOperationSerializer()
            deserializer = GetQueryExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetQueryExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Streams the results of a single query execution specified by `QueryExecutionId` from the Athena query results location in Amazon S3. For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*. This request does not execute the query but returns results. Use StartQueryExecution to run a query.
     *
     * To stream query results successfully, the IAM principal with permission to call `GetQueryResults` also must have permissions to the Amazon S3 `GetObject` action for the Athena query results location.
     *
     * IAM principals with permission to the Amazon S3 `GetObject` action for the query results location are able to retrieve query results from Amazon S3 even if permission to the `GetQueryResults` action is denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are denied.
     */
    override suspend fun getQueryResults(input: GetQueryResultsRequest): GetQueryResultsResponse {
        val op = SdkHttpOperation.build<GetQueryResultsRequest, GetQueryResultsResponse> {
            serializer = GetQueryResultsOperationSerializer()
            deserializer = GetQueryResultsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetQueryResults"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. The query execution runtime statistics is returned only when QueryExecutionStatus$State is in a SUCCEEDED or FAILED state.
     */
    override suspend fun getQueryRuntimeStatistics(input: GetQueryRuntimeStatisticsRequest): GetQueryRuntimeStatisticsResponse {
        val op = SdkHttpOperation.build<GetQueryRuntimeStatisticsRequest, GetQueryRuntimeStatisticsResponse> {
            serializer = GetQueryRuntimeStatisticsOperationSerializer()
            deserializer = GetQueryRuntimeStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetQueryRuntimeStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns table metadata for the specified catalog, database, and table.
     */
    override suspend fun getTableMetadata(input: GetTableMetadataRequest): GetTableMetadataResponse {
        val op = SdkHttpOperation.build<GetTableMetadataRequest, GetTableMetadataResponse> {
            serializer = GetTableMetadataOperationSerializer()
            deserializer = GetTableMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTableMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the workgroup with the specified name.
     */
    override suspend fun getWorkGroup(input: GetWorkGroupRequest): GetWorkGroupResponse {
        val op = SdkHttpOperation.build<GetWorkGroupRequest, GetWorkGroupResponse> {
            serializer = GetWorkGroupOperationSerializer()
            deserializer = GetWorkGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorkGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the data catalogs in the current Amazon Web Services account.
     */
    override suspend fun listDataCatalogs(input: ListDataCatalogsRequest): ListDataCatalogsResponse {
        val op = SdkHttpOperation.build<ListDataCatalogsRequest, ListDataCatalogsResponse> {
            serializer = ListDataCatalogsOperationSerializer()
            deserializer = ListDataCatalogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataCatalogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the databases in the specified data catalog.
     */
    override suspend fun listDatabases(input: ListDatabasesRequest): ListDatabasesResponse {
        val op = SdkHttpOperation.build<ListDatabasesRequest, ListDatabasesResponse> {
            serializer = ListDatabasesOperationSerializer()
            deserializer = ListDatabasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDatabases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of engine versions that are available to choose from, including the Auto option.
     */
    override suspend fun listEngineVersions(input: ListEngineVersionsRequest): ListEngineVersionsResponse {
        val op = SdkHttpOperation.build<ListEngineVersionsRequest, ListEngineVersionsResponse> {
            serializer = ListEngineVersionsOperationSerializer()
            deserializer = ListEngineVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEngineVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    override suspend fun listNamedQueries(input: ListNamedQueriesRequest): ListNamedQueriesResponse {
        val op = SdkHttpOperation.build<ListNamedQueriesRequest, ListNamedQueriesResponse> {
            serializer = ListNamedQueriesOperationSerializer()
            deserializer = ListNamedQueriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNamedQueries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the prepared statements in the specified workgroup.
     */
    override suspend fun listPreparedStatements(input: ListPreparedStatementsRequest): ListPreparedStatementsResponse {
        val op = SdkHttpOperation.build<ListPreparedStatementsRequest, ListPreparedStatementsResponse> {
            serializer = ListPreparedStatementsOperationSerializer()
            deserializer = ListPreparedStatementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPreparedStatements"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of available query execution IDs for the queries in the specified workgroup. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    override suspend fun listQueryExecutions(input: ListQueryExecutionsRequest): ListQueryExecutionsResponse {
        val op = SdkHttpOperation.build<ListQueryExecutionsRequest, ListQueryExecutionsResponse> {
            serializer = ListQueryExecutionsOperationSerializer()
            deserializer = ListQueryExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListQueryExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the metadata for the tables in the specified data catalog database.
     */
    override suspend fun listTableMetadata(input: ListTableMetadataRequest): ListTableMetadataResponse {
        val op = SdkHttpOperation.build<ListTableMetadataRequest, ListTableMetadataResponse> {
            serializer = ListTableMetadataOperationSerializer()
            deserializer = ListTableMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTableMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags associated with an Athena workgroup or data catalog resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists available workgroups for the account.
     */
    override suspend fun listWorkGroups(input: ListWorkGroupsRequest): ListWorkGroupsResponse {
        val op = SdkHttpOperation.build<ListWorkGroupsRequest, ListWorkGroupsResponse> {
            serializer = ListWorkGroupsOperationSerializer()
            deserializer = ListWorkGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Runs the SQL query statements contained in the `Query`. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires GetDataCatalog permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    override suspend fun startQueryExecution(input: StartQueryExecutionRequest): StartQueryExecutionResponse {
        val op = SdkHttpOperation.build<StartQueryExecutionRequest, StartQueryExecutionResponse> {
            serializer = StartQueryExecutionOperationSerializer()
            deserializer = StartQueryExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartQueryExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    override suspend fun stopQueryExecution(input: StopQueryExecutionRequest): StopQueryExecutionResponse {
        val op = SdkHttpOperation.build<StopQueryExecutionRequest, StopQueryExecutionResponse> {
            serializer = StopQueryExecutionOperationSerializer()
            deserializer = StopQueryExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopQueryExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. In Athena, a resource can be a workgroup or data catalog. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups or data catalogs by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter workgroups or data catalogs in your account. For best practices, see [Tagging Best Practices](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/). Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a data catalog or workgroup resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the data catalog that has the specified name.
     */
    override suspend fun updateDataCatalog(input: UpdateDataCatalogRequest): UpdateDataCatalogResponse {
        val op = SdkHttpOperation.build<UpdateDataCatalogRequest, UpdateDataCatalogResponse> {
            serializer = UpdateDataCatalogOperationSerializer()
            deserializer = UpdateDataCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a NamedQuery object. The database or workgroup cannot be updated.
     */
    override suspend fun updateNamedQuery(input: UpdateNamedQueryRequest): UpdateNamedQueryResponse {
        val op = SdkHttpOperation.build<UpdateNamedQueryRequest, UpdateNamedQueryResponse> {
            serializer = UpdateNamedQueryOperationSerializer()
            deserializer = UpdateNamedQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNamedQuery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a prepared statement.
     */
    override suspend fun updatePreparedStatement(input: UpdatePreparedStatementRequest): UpdatePreparedStatementResponse {
        val op = SdkHttpOperation.build<UpdatePreparedStatementRequest, UpdatePreparedStatementResponse> {
            serializer = UpdatePreparedStatementOperationSerializer()
            deserializer = UpdatePreparedStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePreparedStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the workgroup with the specified name. The workgroup's name cannot be changed.
     */
    override suspend fun updateWorkGroup(input: UpdateWorkGroupRequest): UpdateWorkGroupResponse {
        val op = SdkHttpOperation.build<UpdateWorkGroupRequest, UpdateWorkGroupResponse> {
            serializer = UpdateWorkGroupOperationSerializer()
            deserializer = UpdateWorkGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AmazonAthena", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "athena"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "athena")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
