// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.athena.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.athena.model.*
import aws.sdk.kotlin.services.athena.model.BatchGetNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.BatchGetNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.BatchGetPreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.BatchGetPreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.BatchGetQueryExecutionRequest
import aws.sdk.kotlin.services.athena.model.BatchGetQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.CreateDataCatalogRequest
import aws.sdk.kotlin.services.athena.model.CreateDataCatalogResponse
import aws.sdk.kotlin.services.athena.model.CreateNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.CreateNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.CreatePreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.CreatePreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.CreateWorkGroupRequest
import aws.sdk.kotlin.services.athena.model.CreateWorkGroupResponse
import aws.sdk.kotlin.services.athena.model.DeleteDataCatalogRequest
import aws.sdk.kotlin.services.athena.model.DeleteDataCatalogResponse
import aws.sdk.kotlin.services.athena.model.DeleteNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.DeleteNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.DeletePreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.DeletePreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.DeleteWorkGroupRequest
import aws.sdk.kotlin.services.athena.model.DeleteWorkGroupResponse
import aws.sdk.kotlin.services.athena.model.GetDataCatalogRequest
import aws.sdk.kotlin.services.athena.model.GetDataCatalogResponse
import aws.sdk.kotlin.services.athena.model.GetDatabaseRequest
import aws.sdk.kotlin.services.athena.model.GetDatabaseResponse
import aws.sdk.kotlin.services.athena.model.GetNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.GetNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.GetPreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.GetPreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.GetQueryExecutionRequest
import aws.sdk.kotlin.services.athena.model.GetQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.GetQueryResultsRequest
import aws.sdk.kotlin.services.athena.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.athena.model.GetQueryRuntimeStatisticsRequest
import aws.sdk.kotlin.services.athena.model.GetQueryRuntimeStatisticsResponse
import aws.sdk.kotlin.services.athena.model.GetTableMetadataRequest
import aws.sdk.kotlin.services.athena.model.GetTableMetadataResponse
import aws.sdk.kotlin.services.athena.model.GetWorkGroupRequest
import aws.sdk.kotlin.services.athena.model.GetWorkGroupResponse
import aws.sdk.kotlin.services.athena.model.ListDataCatalogsRequest
import aws.sdk.kotlin.services.athena.model.ListDataCatalogsResponse
import aws.sdk.kotlin.services.athena.model.ListDatabasesRequest
import aws.sdk.kotlin.services.athena.model.ListDatabasesResponse
import aws.sdk.kotlin.services.athena.model.ListEngineVersionsRequest
import aws.sdk.kotlin.services.athena.model.ListEngineVersionsResponse
import aws.sdk.kotlin.services.athena.model.ListNamedQueriesRequest
import aws.sdk.kotlin.services.athena.model.ListNamedQueriesResponse
import aws.sdk.kotlin.services.athena.model.ListPreparedStatementsRequest
import aws.sdk.kotlin.services.athena.model.ListPreparedStatementsResponse
import aws.sdk.kotlin.services.athena.model.ListQueryExecutionsRequest
import aws.sdk.kotlin.services.athena.model.ListQueryExecutionsResponse
import aws.sdk.kotlin.services.athena.model.ListTableMetadataRequest
import aws.sdk.kotlin.services.athena.model.ListTableMetadataResponse
import aws.sdk.kotlin.services.athena.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.athena.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.athena.model.ListWorkGroupsRequest
import aws.sdk.kotlin.services.athena.model.ListWorkGroupsResponse
import aws.sdk.kotlin.services.athena.model.StartQueryExecutionRequest
import aws.sdk.kotlin.services.athena.model.StartQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.StopQueryExecutionRequest
import aws.sdk.kotlin.services.athena.model.StopQueryExecutionResponse
import aws.sdk.kotlin.services.athena.model.TagResourceRequest
import aws.sdk.kotlin.services.athena.model.TagResourceResponse
import aws.sdk.kotlin.services.athena.model.UntagResourceRequest
import aws.sdk.kotlin.services.athena.model.UntagResourceResponse
import aws.sdk.kotlin.services.athena.model.UpdateDataCatalogRequest
import aws.sdk.kotlin.services.athena.model.UpdateDataCatalogResponse
import aws.sdk.kotlin.services.athena.model.UpdateNamedQueryRequest
import aws.sdk.kotlin.services.athena.model.UpdateNamedQueryResponse
import aws.sdk.kotlin.services.athena.model.UpdatePreparedStatementRequest
import aws.sdk.kotlin.services.athena.model.UpdatePreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.UpdateWorkGroupRequest
import aws.sdk.kotlin.services.athena.model.UpdateWorkGroupResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Athena is an interactive query service that lets you use standard SQL to analyze data directly in Amazon S3. You can point Athena at your data in Amazon S3 and run ad-hoc queries and get results in seconds. Athena is serverless, so there is no infrastructure to set up or manage. You pay only for the queries you run. Athena scales automatically—executing queries in parallel—so results are fast, even with large datasets and complex queries. For more information, see [What is Amazon Athena](http://docs.aws.amazon.com/athena/latest/ug/what-is.html) in the *Amazon Athena User Guide*.
 *
 * If you connect to Athena using the JDBC driver, use version 1.1.0 of the driver or later with the Amazon Athena API. Earlier version drivers do not support the API. For more information and to download the driver, see [Accessing Amazon Athena with JDBC](https://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html).
 *
 * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](https://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
 */
public interface AthenaClient : SdkClient {

    override val serviceName: String
        get() = "Athena"
    /**
     * AthenaClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): AthenaClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAthenaClient(config)
        }

        public operator fun invoke(config: Config): AthenaClient = DefaultAthenaClient(config)

        /**
         * Construct a [AthenaClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AthenaClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultAthenaClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use ListNamedQueriesInput to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under UnprocessedNamedQueryId. Named queries differ from executed queries. Use BatchGetQueryExecutionInput to get details about each unique query execution, and ListQueryExecutionsInput to get a list of query execution IDs.
     */
    public suspend fun batchGetNamedQuery(input: BatchGetNamedQueryRequest): BatchGetNamedQueryResponse

    /**
     * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in `UnprocessedPreparedStatementNames`.
     */
    public suspend fun batchGetPreparedStatement(input: BatchGetPreparedStatementRequest): BatchGetPreparedStatementResponse

    /**
     * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup. Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput to get details about named queries.
     */
    public suspend fun batchGetQueryExecution(input: BatchGetQueryExecutionRequest): BatchGetQueryExecutionResponse

    /**
     * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.
     */
    public suspend fun createDataCatalog(input: CreateDataCatalogRequest): CreateDataCatalogResponse

    /**
     * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    public suspend fun createNamedQuery(input: CreateNamedQueryRequest): CreateNamedQueryResponse

    /**
     * Creates a prepared statement for use with SQL queries in Athena.
     */
    public suspend fun createPreparedStatement(input: CreatePreparedStatementRequest): CreatePreparedStatementResponse

    /**
     * Creates a workgroup with the specified name.
     */
    public suspend fun createWorkGroup(input: CreateWorkGroupRequest): CreateWorkGroupResponse

    /**
     * Deletes a data catalog.
     */
    public suspend fun deleteDataCatalog(input: DeleteDataCatalogRequest): DeleteDataCatalogResponse

    /**
     * Deletes the named query if you have access to the workgroup in which the query was saved.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    public suspend fun deleteNamedQuery(input: DeleteNamedQueryRequest): DeleteNamedQueryResponse

    /**
     * Deletes the prepared statement with the specified name from the specified workgroup.
     */
    public suspend fun deletePreparedStatement(input: DeletePreparedStatementRequest): DeletePreparedStatementResponse

    /**
     * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
     */
    public suspend fun deleteWorkGroup(input: DeleteWorkGroupRequest): DeleteWorkGroupResponse

    /**
     * Returns the specified data catalog.
     */
    public suspend fun getDataCatalog(input: GetDataCatalogRequest): GetDataCatalogResponse

    /**
     * Returns a database object for the specified database and data catalog.
     */
    public suspend fun getDatabase(input: GetDatabaseRequest): GetDatabaseResponse

    /**
     * Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.
     */
    public suspend fun getNamedQuery(input: GetNamedQueryRequest): GetNamedQueryResponse

    /**
     * Retrieves the prepared statement with the specified name from the specified workgroup.
     */
    public suspend fun getPreparedStatement(input: GetPreparedStatementRequest): GetPreparedStatementResponse

    /**
     * Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.
     */
    public suspend fun getQueryExecution(input: GetQueryExecutionRequest): GetQueryExecutionResponse

    /**
     * Streams the results of a single query execution specified by `QueryExecutionId` from the Athena query results location in Amazon S3. For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*. This request does not execute the query but returns results. Use StartQueryExecution to run a query.
     *
     * To stream query results successfully, the IAM principal with permission to call `GetQueryResults` also must have permissions to the Amazon S3 `GetObject` action for the Athena query results location.
     *
     * IAM principals with permission to the Amazon S3 `GetObject` action for the query results location are able to retrieve query results from Amazon S3 even if permission to the `GetQueryResults` action is denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are denied.
     */
    public suspend fun getQueryResults(input: GetQueryResultsRequest): GetQueryResultsResponse

    /**
     * Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. The query execution runtime statistics is returned only when QueryExecutionStatus$State is in a SUCCEEDED or FAILED state.
     */
    public suspend fun getQueryRuntimeStatistics(input: GetQueryRuntimeStatisticsRequest): GetQueryRuntimeStatisticsResponse

    /**
     * Returns table metadata for the specified catalog, database, and table.
     */
    public suspend fun getTableMetadata(input: GetTableMetadataRequest): GetTableMetadataResponse

    /**
     * Returns information about the workgroup with the specified name.
     */
    public suspend fun getWorkGroup(input: GetWorkGroupRequest): GetWorkGroupResponse

    /**
     * Lists the data catalogs in the current Amazon Web Services account.
     */
    public suspend fun listDataCatalogs(input: ListDataCatalogsRequest = ListDataCatalogsRequest {}): ListDataCatalogsResponse

    /**
     * Lists the databases in the specified data catalog.
     */
    public suspend fun listDatabases(input: ListDatabasesRequest): ListDatabasesResponse

    /**
     * Returns a list of engine versions that are available to choose from, including the Auto option.
     */
    public suspend fun listEngineVersions(input: ListEngineVersionsRequest = ListEngineVersionsRequest {}): ListEngineVersionsResponse

    /**
     * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    public suspend fun listNamedQueries(input: ListNamedQueriesRequest = ListNamedQueriesRequest {}): ListNamedQueriesResponse

    /**
     * Lists the prepared statements in the specified workgroup.
     */
    public suspend fun listPreparedStatements(input: ListPreparedStatementsRequest): ListPreparedStatementsResponse

    /**
     * Provides a list of available query execution IDs for the queries in the specified workgroup. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    public suspend fun listQueryExecutions(input: ListQueryExecutionsRequest = ListQueryExecutionsRequest {}): ListQueryExecutionsResponse

    /**
     * Lists the metadata for the tables in the specified data catalog database.
     */
    public suspend fun listTableMetadata(input: ListTableMetadataRequest): ListTableMetadataResponse

    /**
     * Lists the tags associated with an Athena workgroup or data catalog resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists available workgroups for the account.
     */
    public suspend fun listWorkGroups(input: ListWorkGroupsRequest = ListWorkGroupsRequest {}): ListWorkGroupsResponse

    /**
     * Runs the SQL query statements contained in the `Query`. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires GetDataCatalog permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    public suspend fun startQueryExecution(input: StartQueryExecutionRequest): StartQueryExecutionResponse

    /**
     * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
     *
     * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
     */
    public suspend fun stopQueryExecution(input: StopQueryExecutionRequest): StopQueryExecutionResponse

    /**
     * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. In Athena, a resource can be a workgroup or data catalog. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups or data catalogs by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter workgroups or data catalogs in your account. For best practices, see [Tagging Best Practices](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/). Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a data catalog or workgroup resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the data catalog that has the specified name.
     */
    public suspend fun updateDataCatalog(input: UpdateDataCatalogRequest): UpdateDataCatalogResponse

    /**
     * Updates a NamedQuery object. The database or workgroup cannot be updated.
     */
    public suspend fun updateNamedQuery(input: UpdateNamedQueryRequest): UpdateNamedQueryResponse

    /**
     * Updates a prepared statement.
     */
    public suspend fun updatePreparedStatement(input: UpdatePreparedStatementRequest): UpdatePreparedStatementResponse

    /**
     * Updates the workgroup with the specified name. The workgroup's name cannot be changed.
     */
    public suspend fun updateWorkGroup(input: UpdateWorkGroupRequest): UpdateWorkGroupResponse
}

/**
 * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use ListNamedQueriesInput to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under UnprocessedNamedQueryId. Named queries differ from executed queries. Use BatchGetQueryExecutionInput to get details about each unique query execution, and ListQueryExecutionsInput to get a list of query execution IDs.
 */
public suspend inline fun AthenaClient.batchGetNamedQuery(crossinline block: BatchGetNamedQueryRequest.Builder.() -> Unit): BatchGetNamedQueryResponse = batchGetNamedQuery(BatchGetNamedQueryRequest.Builder().apply(block).build())

/**
 * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in `UnprocessedPreparedStatementNames`.
 */
public suspend inline fun AthenaClient.batchGetPreparedStatement(crossinline block: BatchGetPreparedStatementRequest.Builder.() -> Unit): BatchGetPreparedStatementResponse = batchGetPreparedStatement(BatchGetPreparedStatementRequest.Builder().apply(block).build())

/**
 * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup. Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput to get details about named queries.
 */
public suspend inline fun AthenaClient.batchGetQueryExecution(crossinline block: BatchGetQueryExecutionRequest.Builder.() -> Unit): BatchGetQueryExecutionResponse = batchGetQueryExecution(BatchGetQueryExecutionRequest.Builder().apply(block).build())

/**
 * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.
 */
public suspend inline fun AthenaClient.createDataCatalog(crossinline block: CreateDataCatalogRequest.Builder.() -> Unit): CreateDataCatalogResponse = createDataCatalog(CreateDataCatalogRequest.Builder().apply(block).build())

/**
 * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
 *
 * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
 */
public suspend inline fun AthenaClient.createNamedQuery(crossinline block: CreateNamedQueryRequest.Builder.() -> Unit): CreateNamedQueryResponse = createNamedQuery(CreateNamedQueryRequest.Builder().apply(block).build())

/**
 * Creates a prepared statement for use with SQL queries in Athena.
 */
public suspend inline fun AthenaClient.createPreparedStatement(crossinline block: CreatePreparedStatementRequest.Builder.() -> Unit): CreatePreparedStatementResponse = createPreparedStatement(CreatePreparedStatementRequest.Builder().apply(block).build())

/**
 * Creates a workgroup with the specified name.
 */
public suspend inline fun AthenaClient.createWorkGroup(crossinline block: CreateWorkGroupRequest.Builder.() -> Unit): CreateWorkGroupResponse = createWorkGroup(CreateWorkGroupRequest.Builder().apply(block).build())

/**
 * Deletes a data catalog.
 */
public suspend inline fun AthenaClient.deleteDataCatalog(crossinline block: DeleteDataCatalogRequest.Builder.() -> Unit): DeleteDataCatalogResponse = deleteDataCatalog(DeleteDataCatalogRequest.Builder().apply(block).build())

/**
 * Deletes the named query if you have access to the workgroup in which the query was saved.
 *
 * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
 */
public suspend inline fun AthenaClient.deleteNamedQuery(crossinline block: DeleteNamedQueryRequest.Builder.() -> Unit): DeleteNamedQueryResponse = deleteNamedQuery(DeleteNamedQueryRequest.Builder().apply(block).build())

/**
 * Deletes the prepared statement with the specified name from the specified workgroup.
 */
public suspend inline fun AthenaClient.deletePreparedStatement(crossinline block: DeletePreparedStatementRequest.Builder.() -> Unit): DeletePreparedStatementResponse = deletePreparedStatement(DeletePreparedStatementRequest.Builder().apply(block).build())

/**
 * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
 */
public suspend inline fun AthenaClient.deleteWorkGroup(crossinline block: DeleteWorkGroupRequest.Builder.() -> Unit): DeleteWorkGroupResponse = deleteWorkGroup(DeleteWorkGroupRequest.Builder().apply(block).build())

/**
 * Returns the specified data catalog.
 */
public suspend inline fun AthenaClient.getDataCatalog(crossinline block: GetDataCatalogRequest.Builder.() -> Unit): GetDataCatalogResponse = getDataCatalog(GetDataCatalogRequest.Builder().apply(block).build())

/**
 * Returns a database object for the specified database and data catalog.
 */
public suspend inline fun AthenaClient.getDatabase(crossinline block: GetDatabaseRequest.Builder.() -> Unit): GetDatabaseResponse = getDatabase(GetDatabaseRequest.Builder().apply(block).build())

/**
 * Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.
 */
public suspend inline fun AthenaClient.getNamedQuery(crossinline block: GetNamedQueryRequest.Builder.() -> Unit): GetNamedQueryResponse = getNamedQuery(GetNamedQueryRequest.Builder().apply(block).build())

/**
 * Retrieves the prepared statement with the specified name from the specified workgroup.
 */
public suspend inline fun AthenaClient.getPreparedStatement(crossinline block: GetPreparedStatementRequest.Builder.() -> Unit): GetPreparedStatementResponse = getPreparedStatement(GetPreparedStatementRequest.Builder().apply(block).build())

/**
 * Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.
 */
public suspend inline fun AthenaClient.getQueryExecution(crossinline block: GetQueryExecutionRequest.Builder.() -> Unit): GetQueryExecutionResponse = getQueryExecution(GetQueryExecutionRequest.Builder().apply(block).build())

/**
 * Streams the results of a single query execution specified by `QueryExecutionId` from the Athena query results location in Amazon S3. For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*. This request does not execute the query but returns results. Use StartQueryExecution to run a query.
 *
 * To stream query results successfully, the IAM principal with permission to call `GetQueryResults` also must have permissions to the Amazon S3 `GetObject` action for the Athena query results location.
 *
 * IAM principals with permission to the Amazon S3 `GetObject` action for the query results location are able to retrieve query results from Amazon S3 even if permission to the `GetQueryResults` action is denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are denied.
 */
public suspend inline fun AthenaClient.getQueryResults(crossinline block: GetQueryResultsRequest.Builder.() -> Unit): GetQueryResultsResponse = getQueryResults(GetQueryResultsRequest.Builder().apply(block).build())

/**
 * Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. The query execution runtime statistics is returned only when QueryExecutionStatus$State is in a SUCCEEDED or FAILED state.
 */
public suspend inline fun AthenaClient.getQueryRuntimeStatistics(crossinline block: GetQueryRuntimeStatisticsRequest.Builder.() -> Unit): GetQueryRuntimeStatisticsResponse = getQueryRuntimeStatistics(GetQueryRuntimeStatisticsRequest.Builder().apply(block).build())

/**
 * Returns table metadata for the specified catalog, database, and table.
 */
public suspend inline fun AthenaClient.getTableMetadata(crossinline block: GetTableMetadataRequest.Builder.() -> Unit): GetTableMetadataResponse = getTableMetadata(GetTableMetadataRequest.Builder().apply(block).build())

/**
 * Returns information about the workgroup with the specified name.
 */
public suspend inline fun AthenaClient.getWorkGroup(crossinline block: GetWorkGroupRequest.Builder.() -> Unit): GetWorkGroupResponse = getWorkGroup(GetWorkGroupRequest.Builder().apply(block).build())

/**
 * Lists the data catalogs in the current Amazon Web Services account.
 */
public suspend inline fun AthenaClient.listDataCatalogs(crossinline block: ListDataCatalogsRequest.Builder.() -> Unit): ListDataCatalogsResponse = listDataCatalogs(ListDataCatalogsRequest.Builder().apply(block).build())

/**
 * Lists the databases in the specified data catalog.
 */
public suspend inline fun AthenaClient.listDatabases(crossinline block: ListDatabasesRequest.Builder.() -> Unit): ListDatabasesResponse = listDatabases(ListDatabasesRequest.Builder().apply(block).build())

/**
 * Returns a list of engine versions that are available to choose from, including the Auto option.
 */
public suspend inline fun AthenaClient.listEngineVersions(crossinline block: ListEngineVersionsRequest.Builder.() -> Unit): ListEngineVersionsResponse = listEngineVersions(ListEngineVersionsRequest.Builder().apply(block).build())

/**
 * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.
 *
 * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
 */
public suspend inline fun AthenaClient.listNamedQueries(crossinline block: ListNamedQueriesRequest.Builder.() -> Unit): ListNamedQueriesResponse = listNamedQueries(ListNamedQueriesRequest.Builder().apply(block).build())

/**
 * Lists the prepared statements in the specified workgroup.
 */
public suspend inline fun AthenaClient.listPreparedStatements(crossinline block: ListPreparedStatementsRequest.Builder.() -> Unit): ListPreparedStatementsResponse = listPreparedStatements(ListPreparedStatementsRequest.Builder().apply(block).build())

/**
 * Provides a list of available query execution IDs for the queries in the specified workgroup. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.
 *
 * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
 */
public suspend inline fun AthenaClient.listQueryExecutions(crossinline block: ListQueryExecutionsRequest.Builder.() -> Unit): ListQueryExecutionsResponse = listQueryExecutions(ListQueryExecutionsRequest.Builder().apply(block).build())

/**
 * Lists the metadata for the tables in the specified data catalog database.
 */
public suspend inline fun AthenaClient.listTableMetadata(crossinline block: ListTableMetadataRequest.Builder.() -> Unit): ListTableMetadataResponse = listTableMetadata(ListTableMetadataRequest.Builder().apply(block).build())

/**
 * Lists the tags associated with an Athena workgroup or data catalog resource.
 */
public suspend inline fun AthenaClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists available workgroups for the account.
 */
public suspend inline fun AthenaClient.listWorkGroups(crossinline block: ListWorkGroupsRequest.Builder.() -> Unit): ListWorkGroupsResponse = listWorkGroups(ListWorkGroupsRequest.Builder().apply(block).build())

/**
 * Runs the SQL query statements contained in the `Query`. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires GetDataCatalog permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
 */
public suspend inline fun AthenaClient.startQueryExecution(crossinline block: StartQueryExecutionRequest.Builder.() -> Unit): StartQueryExecutionResponse = startQueryExecution(StartQueryExecutionRequest.Builder().apply(block).build())

/**
 * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
 *
 * For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
 */
public suspend inline fun AthenaClient.stopQueryExecution(crossinline block: StopQueryExecutionRequest.Builder.() -> Unit): StopQueryExecutionResponse = stopQueryExecution(StopQueryExecutionRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. In Athena, a resource can be a workgroup or data catalog. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups or data catalogs by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter workgroups or data catalogs in your account. For best practices, see [Tagging Best Practices](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/). Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.
 */
public suspend inline fun AthenaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a data catalog or workgroup resource.
 */
public suspend inline fun AthenaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the data catalog that has the specified name.
 */
public suspend inline fun AthenaClient.updateDataCatalog(crossinline block: UpdateDataCatalogRequest.Builder.() -> Unit): UpdateDataCatalogResponse = updateDataCatalog(UpdateDataCatalogRequest.Builder().apply(block).build())

/**
 * Updates a NamedQuery object. The database or workgroup cannot be updated.
 */
public suspend inline fun AthenaClient.updateNamedQuery(crossinline block: UpdateNamedQueryRequest.Builder.() -> Unit): UpdateNamedQueryResponse = updateNamedQuery(UpdateNamedQueryRequest.Builder().apply(block).build())

/**
 * Updates a prepared statement.
 */
public suspend inline fun AthenaClient.updatePreparedStatement(crossinline block: UpdatePreparedStatementRequest.Builder.() -> Unit): UpdatePreparedStatementResponse = updatePreparedStatement(UpdatePreparedStatementRequest.Builder().apply(block).build())

/**
 * Updates the workgroup with the specified name. The workgroup's name cannot be changed.
 */
public suspend inline fun AthenaClient.updateWorkGroup(crossinline block: UpdateWorkGroupRequest.Builder.() -> Unit): UpdateWorkGroupResponse = updateWorkGroup(UpdateWorkGroupRequest.Builder().apply(block).build())
