// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.artifact.paginators

import aws.sdk.kotlin.services.artifact.ArtifactClient
import aws.sdk.kotlin.services.artifact.model.ListReportsRequest
import aws.sdk.kotlin.services.artifact.model.ListReportsResponse
import aws.sdk.kotlin.services.artifact.model.ReportSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportsResponse]
 */
public fun ArtifactClient.listReportsPaginated(initialRequest: ListReportsRequest = ListReportsRequest { }): Flow<ListReportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReportsPaginated.listReports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportsResponse]
 */
public fun ArtifactClient.listReportsPaginated(block: ListReportsRequest.Builder.() -> Unit): Flow<ListReportsResponse> =
    listReportsPaginated(ListReportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReportsPaginated]
 * to access the nested member [ReportSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReportSummary]
 */
@JvmName("listReportsResponseReportSummary")
public fun Flow<ListReportsResponse>.reports(): Flow<ReportSummary> =
    transform() { response ->
        response.reports?.forEach {
            emit(it)
        }
    }
