// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.serde

import aws.sdk.kotlin.services.arczonalshift.model.ArcZonalShiftException
import aws.sdk.kotlin.services.arczonalshift.model.StartPracticeRunResponse
import aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class StartPracticeRunOperationDeserializer: HttpDeserializer.NonStreaming<StartPracticeRunResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartPracticeRunResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartPracticeRunError(context, call, payload)
        }
        val builder = StartPracticeRunResponse.Builder()

        if (payload != null) {
            deserializeStartPracticeRunOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartPracticeRunError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ArcZonalShiftException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ArcZonalShiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartPracticeRunOperationBody(builder: StartPracticeRunResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWAYFROM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awayFrom"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("comment"))
    val EXPIRYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expiryTime"))
    val RESOURCEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceIdentifier"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val ZONALSHIFTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("zonalShiftId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWAYFROM_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(EXPIRYTIME_DESCRIPTOR)
        field(RESOURCEIDENTIFIER_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(ZONALSHIFTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWAYFROM_DESCRIPTOR.index -> builder.awayFrom = deserializeString()
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeString()
                EXPIRYTIME_DESCRIPTOR.index -> builder.expiryTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                RESOURCEIDENTIFIER_DESCRIPTOR.index -> builder.resourceIdentifier = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ZonalShiftStatus.fromValue(it) }
                ZONALSHIFTID_DESCRIPTOR.index -> builder.zonalShiftId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
