// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.serde

import aws.sdk.kotlin.services.arczonalshift.model.ArcZonalShiftException
import aws.sdk.kotlin.services.arczonalshift.model.AutoshiftInResource
import aws.sdk.kotlin.services.arczonalshift.model.GetManagedResourceResponse
import aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration
import aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus
import aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftInResource
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetManagedResourceOperationDeserializer: HttpDeserializer.NonStreaming<GetManagedResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetManagedResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetManagedResourceError(context, call, payload)
        }
        val builder = GetManagedResourceResponse.Builder()

        if (payload != null) {
            deserializeGetManagedResourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetManagedResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ArcZonalShiftException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ArcZonalShiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetManagedResourceOperationBody(builder: GetManagedResourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLIEDWEIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("appliedWeights"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val AUTOSHIFTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("autoshifts"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PRACTICERUNCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("practiceRunConfiguration"))
    val ZONALAUTOSHIFTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("zonalAutoshiftStatus"))
    val ZONALSHIFTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("zonalShifts"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLIEDWEIGHTS_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(AUTOSHIFTS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRACTICERUNCONFIGURATION_DESCRIPTOR)
        field(ZONALAUTOSHIFTSTATUS_DESCRIPTOR)
        field(ZONALSHIFTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLIEDWEIGHTS_DESCRIPTOR.index -> builder.appliedWeights =
                    deserializer.deserializeMap(APPLIEDWEIGHTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Float>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeFloat() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTOSHIFTS_DESCRIPTOR.index -> builder.autoshifts =
                    deserializer.deserializeList(AUTOSHIFTS_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoshiftInResource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoshiftInResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PRACTICERUNCONFIGURATION_DESCRIPTOR.index -> builder.practiceRunConfiguration = deserializePracticeRunConfigurationDocument(deserializer)
                ZONALAUTOSHIFTSTATUS_DESCRIPTOR.index -> builder.zonalAutoshiftStatus = deserializeString().let { ZonalAutoshiftStatus.fromValue(it) }
                ZONALSHIFTS_DESCRIPTOR.index -> builder.zonalShifts =
                    deserializer.deserializeList(ZONALSHIFTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ZonalShiftInResource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeZonalShiftInResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
