// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.paginators

import aws.sdk.kotlin.services.arczonalshift.ArcZonalShiftClient
import aws.sdk.kotlin.services.arczonalshift.model.AutoshiftSummary
import aws.sdk.kotlin.services.arczonalshift.model.ListAutoshiftsRequest
import aws.sdk.kotlin.services.arczonalshift.model.ListAutoshiftsResponse
import aws.sdk.kotlin.services.arczonalshift.model.ListManagedResourcesRequest
import aws.sdk.kotlin.services.arczonalshift.model.ListManagedResourcesResponse
import aws.sdk.kotlin.services.arczonalshift.model.ListZonalShiftsRequest
import aws.sdk.kotlin.services.arczonalshift.model.ListZonalShiftsResponse
import aws.sdk.kotlin.services.arczonalshift.model.ManagedResourceSummary
import aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAutoshiftsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAutoshiftsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAutoshiftsResponse]
 */
public fun ArcZonalShiftClient.listAutoshiftsPaginated(initialRequest: ListAutoshiftsRequest = ListAutoshiftsRequest { }): Flow<ListAutoshiftsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAutoshiftsPaginated.listAutoshifts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAutoshiftsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAutoshiftsResponse]
 */
public fun ArcZonalShiftClient.listAutoshiftsPaginated(block: ListAutoshiftsRequest.Builder.() -> Unit): Flow<ListAutoshiftsResponse> =
    listAutoshiftsPaginated(ListAutoshiftsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAutoshiftsPaginated]
 * to access the nested member [AutoshiftSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AutoshiftSummary]
 */
@JvmName("listAutoshiftsResponseAutoshiftSummary")
public fun Flow<ListAutoshiftsResponse>.items(): Flow<AutoshiftSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListManagedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListManagedResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListManagedResourcesResponse]
 */
public fun ArcZonalShiftClient.listManagedResourcesPaginated(initialRequest: ListManagedResourcesRequest = ListManagedResourcesRequest { }): Flow<ListManagedResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listManagedResourcesPaginated.listManagedResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListManagedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListManagedResourcesResponse]
 */
public fun ArcZonalShiftClient.listManagedResourcesPaginated(block: ListManagedResourcesRequest.Builder.() -> Unit): Flow<ListManagedResourcesResponse> =
    listManagedResourcesPaginated(ListManagedResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listManagedResourcesPaginated]
 * to access the nested member [ManagedResourceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ManagedResourceSummary]
 */
@JvmName("listManagedResourcesResponseManagedResourceSummary")
public fun Flow<ListManagedResourcesResponse>.items(): Flow<ManagedResourceSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListZonalShiftsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListZonalShiftsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListZonalShiftsResponse]
 */
public fun ArcZonalShiftClient.listZonalShiftsPaginated(initialRequest: ListZonalShiftsRequest = ListZonalShiftsRequest { }): Flow<ListZonalShiftsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listZonalShiftsPaginated.listZonalShifts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListZonalShiftsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListZonalShiftsResponse]
 */
public fun ArcZonalShiftClient.listZonalShiftsPaginated(block: ListZonalShiftsRequest.Builder.() -> Unit): Flow<ListZonalShiftsResponse> =
    listZonalShiftsPaginated(ListZonalShiftsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listZonalShiftsPaginated]
 * to access the nested member [ZonalShiftSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ZonalShiftSummary]
 */
@JvmName("listZonalShiftsResponseZonalShiftSummary")
public fun Flow<ListZonalShiftsResponse>.items(): Flow<ZonalShiftSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
