// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Lists information about zonal shifts in Amazon Application Recovery Controller, including zonal shifts that you start yourself and zonal shifts that ARC starts on your behalf for practice runs with zonal autoshift.
 *
 * Zonal shifts are temporary, including customer-initiated zonal shifts and the zonal autoshift practice run zonal shifts that ARC starts weekly, on your behalf. A zonal shift that a customer starts can be active for up to three days (72 hours). A practice run zonal shift has a 30 minute duration.
 */
public class ZonalShiftSummary private constructor(builder: Builder) {
    /**
     * The Availability Zone (for example, `use1-az1`) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.
     */
    public val awayFrom: kotlin.String = requireNotNull(builder.awayFrom) { "A non-null value must be provided for awayFrom" }
    /**
     * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. That is, a new comment overwrites any existing comment string.
     */
    public val comment: kotlin.String = requireNotNull(builder.comment) { "A non-null value must be provided for comment" }
    /**
     * The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at any time.
     *
     * When you start a zonal shift, you specify how long you want it to be active, which ARC converts to an expiry time (expiration time). You can cancel a zonal shift when you're ready to restore traffic to the Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify another length of time to expire in.
     */
    public val expiryTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.expiryTime) { "A non-null value must be provided for expiryTime" }
    /**
     * The outcome, or end state, of a practice run. The following values can be returned:
     * + **PENDING:** Outcome value when the practice run is in progress.
     * + **SUCCEEDED:** Outcome value when the outcome alarm specified for the practice run configuration does not go into an `ALARM` state during the practice run, and the practice run was not interrupted before it completed.
     * + **INTERRUPTED:** Outcome value when the practice run did not run for the expected 30 minutes or there was another problem with the practice run that created an inconclusive outcome.
     * + **FAILED:** Outcome value when the outcome alarm specified for the practice run configuration goes into an `ALARM` state during the practice run, and the practice run was not interrupted before it completed.
     * + **CAPACITY_CHECK_FAILED:** The check for balanced capacity across Availability Zones for your load balancing and Auto Scaling group resources failed.
     *
     * For more information about practice run outcomes, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html) in the Amazon Application Recovery Controller Developer Guide.
     */
    public val practiceRunOutcome: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunOutcome? = builder.practiceRunOutcome
    /**
     * The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.
     *
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
     * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
     * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
     * + [Application Load Balancers](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
     * + [Network Load Balancers](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
     */
    public val resourceIdentifier: kotlin.String = requireNotNull(builder.resourceIdentifier) { "A non-null value must be provided for resourceIdentifier" }
    /**
     * Defines the zonal shift type.
     */
    public val shiftType: aws.sdk.kotlin.services.arczonalshift.model.ShiftType? = builder.shiftType
    /**
     * The time (UTC) when the zonal shift starts.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * A status for a zonal shift.
     *
     * The `Status` for a zonal shift can have one of the following values:
     * + **ACTIVE:** The zonal shift has been started and is active.
     * + **EXPIRED:** The zonal shift has expired (the expiry time was exceeded).
     * + **CANCELED:** The zonal shift was canceled.
     */
    public val status: aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The identifier of a zonal shift.
     */
    public val zonalShiftId: kotlin.String = requireNotNull(builder.zonalShiftId) { "A non-null value must be provided for zonalShiftId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ZonalShiftSummary(")
        append("awayFrom=$awayFrom,")
        append("comment=$comment,")
        append("expiryTime=$expiryTime,")
        append("practiceRunOutcome=$practiceRunOutcome,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("shiftType=$shiftType,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("zonalShiftId=$zonalShiftId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awayFrom.hashCode()
        result = 31 * result + (comment.hashCode())
        result = 31 * result + (expiryTime.hashCode())
        result = 31 * result + (practiceRunOutcome?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier.hashCode())
        result = 31 * result + (shiftType?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (zonalShiftId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ZonalShiftSummary

        if (awayFrom != other.awayFrom) return false
        if (comment != other.comment) return false
        if (expiryTime != other.expiryTime) return false
        if (practiceRunOutcome != other.practiceRunOutcome) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (shiftType != other.shiftType) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (zonalShiftId != other.zonalShiftId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone (for example, `use1-az1`) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.
         */
        public var awayFrom: kotlin.String? = null
        /**
         * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. That is, a new comment overwrites any existing comment string.
         */
        public var comment: kotlin.String? = null
        /**
         * The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at any time.
         *
         * When you start a zonal shift, you specify how long you want it to be active, which ARC converts to an expiry time (expiration time). You can cancel a zonal shift when you're ready to restore traffic to the Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify another length of time to expire in.
         */
        public var expiryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The outcome, or end state, of a practice run. The following values can be returned:
         * + **PENDING:** Outcome value when the practice run is in progress.
         * + **SUCCEEDED:** Outcome value when the outcome alarm specified for the practice run configuration does not go into an `ALARM` state during the practice run, and the practice run was not interrupted before it completed.
         * + **INTERRUPTED:** Outcome value when the practice run did not run for the expected 30 minutes or there was another problem with the practice run that created an inconclusive outcome.
         * + **FAILED:** Outcome value when the outcome alarm specified for the practice run configuration goes into an `ALARM` state during the practice run, and the practice run was not interrupted before it completed.
         * + **CAPACITY_CHECK_FAILED:** The check for balanced capacity across Availability Zones for your load balancing and Auto Scaling group resources failed.
         *
         * For more information about practice run outcomes, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html) in the Amazon Application Recovery Controller Developer Guide.
         */
        public var practiceRunOutcome: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunOutcome? = null
        /**
         * The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.
         *
         * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
         * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
         * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
         * + [Application Load Balancers](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
         * + [Network Load Balancers](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
         */
        public var resourceIdentifier: kotlin.String? = null
        /**
         * Defines the zonal shift type.
         */
        public var shiftType: aws.sdk.kotlin.services.arczonalshift.model.ShiftType? = null
        /**
         * The time (UTC) when the zonal shift starts.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A status for a zonal shift.
         *
         * The `Status` for a zonal shift can have one of the following values:
         * + **ACTIVE:** The zonal shift has been started and is active.
         * + **EXPIRED:** The zonal shift has expired (the expiry time was exceeded).
         * + **CANCELED:** The zonal shift was canceled.
         */
        public var status: aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftStatus? = null
        /**
         * The identifier of a zonal shift.
         */
        public var zonalShiftId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftSummary) : this() {
            this.awayFrom = x.awayFrom
            this.comment = x.comment
            this.expiryTime = x.expiryTime
            this.practiceRunOutcome = x.practiceRunOutcome
            this.resourceIdentifier = x.resourceIdentifier
            this.shiftType = x.shiftType
            this.startTime = x.startTime
            this.status = x.status
            this.zonalShiftId = x.zonalShiftId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftSummary = ZonalShiftSummary(this)

        internal fun correctErrors(): Builder {
            if (awayFrom == null) awayFrom = ""
            if (comment == null) comment = ""
            if (expiryTime == null) expiryTime = Instant.fromEpochSeconds(0)
            if (resourceIdentifier == null) resourceIdentifier = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = ZonalShiftStatus.SdkUnknown("no value provided")
            if (zonalShiftId == null) zonalShiftId = ""
            return this
        }
    }
}
