// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A complex structure that lists the zonal shifts for a managed resource and their statuses for the resource.
 */
public class ZonalShiftInResource private constructor(builder: Builder) {
    /**
     * The `appliedStatus` field specifies which application traffic shift is in effect for a resource when there is more than one active traffic shift. There can be more than one application traffic shift in progress at the same time - that is, practice run zonal shifts, customer-initiated zonal shifts, or an autoshift. The `appliedStatus` field for a shift that is in progress for a resource can have one of two values: `APPLIED` or `NOT_APPLIED`. The zonal shift or autoshift that is currently in effect for the resource has an `appliedStatus` set to `APPLIED`.
     *
     * The overall principle for precedence is that zonal shifts that you start as a customer take precedence autoshifts, which take precedence over practice runs. That is, customer-initiated zonal shifts > autoshifts > practice run zonal shifts.
     *
     * For more information, see [How zonal autoshift and practice runs work](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html) in the Amazon Application Recovery Controller Developer Guide.
     */
    public val appliedStatus: aws.sdk.kotlin.services.arczonalshift.model.AppliedStatus = requireNotNull(builder.appliedStatus) { "A non-null value must be provided for appliedStatus" }
    /**
     * The Availability Zone (for example, `use1-az1`) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.
     */
    public val awayFrom: kotlin.String = requireNotNull(builder.awayFrom) { "A non-null value must be provided for awayFrom" }
    /**
     * A comment that you enter for a customer-initiated zonal shift. Only the latest comment is retained; no comment history is maintained. That is, a new comment overwrites any existing comment string.
     */
    public val comment: kotlin.String = requireNotNull(builder.comment) { "A non-null value must be provided for comment" }
    /**
     * The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at any time.
     *
     * When you start a zonal shift, you specify how long you want it to be active, which ARC converts to an expiry time (expiration time). You can cancel a zonal shift when you're ready to restore traffic to the Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify another length of time to expire in.
     */
    public val expiryTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.expiryTime) { "A non-null value must be provided for expiryTime" }
    /**
     * The outcome, or end state, returned for a practice run. The following values can be returned:
     * + **PENDING:** Outcome value when a practice run is in progress.
     * + **SUCCEEDED:** Outcome value when the outcome alarm specified for the practice run configuration does not go into an `ALARM` state during the practice run, and the practice run was not interrupted before it completed the expected 30 minute zonal shift.
     * + **INTERRUPTED:** Outcome value when the practice run was stopped before the expected 30 minute zonal shift duration, or there was another problem with the practice run that created an inconclusive outcome.
     * + **FAILED:** Outcome value when the outcome alarm specified for the practice run configuration goes into an `ALARM` state during the practice run, and the practice run was not interrupted before it completed.
     * + **CAPACITY_CHECK_FAILED:** The check for balanced capacity across Availability Zones for your load balancing and Auto Scaling group resources failed.
     *
     * For more information about practice run outcomes, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html) in the Amazon Application Recovery Controller Developer Guide.
     */
    public val practiceRunOutcome: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunOutcome? = builder.practiceRunOutcome
    /**
     * The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.
     *
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
     * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
     * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
     * + [Application Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
     * + [Network Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
     */
    public val resourceIdentifier: kotlin.String = requireNotNull(builder.resourceIdentifier) { "A non-null value must be provided for resourceIdentifier" }
    /**
     * Defines the zonal shift type.
     */
    public val shiftType: aws.sdk.kotlin.services.arczonalshift.model.ShiftType? = builder.shiftType
    /**
     * The time (UTC) when the zonal shift starts.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The identifier of a zonal shift.
     */
    public val zonalShiftId: kotlin.String = requireNotNull(builder.zonalShiftId) { "A non-null value must be provided for zonalShiftId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftInResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ZonalShiftInResource(")
        append("appliedStatus=$appliedStatus,")
        append("awayFrom=$awayFrom,")
        append("comment=$comment,")
        append("expiryTime=$expiryTime,")
        append("practiceRunOutcome=$practiceRunOutcome,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("shiftType=$shiftType,")
        append("startTime=$startTime,")
        append("zonalShiftId=$zonalShiftId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appliedStatus.hashCode()
        result = 31 * result + (awayFrom.hashCode())
        result = 31 * result + (comment.hashCode())
        result = 31 * result + (expiryTime.hashCode())
        result = 31 * result + (practiceRunOutcome?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier.hashCode())
        result = 31 * result + (shiftType?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (zonalShiftId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ZonalShiftInResource

        if (appliedStatus != other.appliedStatus) return false
        if (awayFrom != other.awayFrom) return false
        if (comment != other.comment) return false
        if (expiryTime != other.expiryTime) return false
        if (practiceRunOutcome != other.practiceRunOutcome) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (shiftType != other.shiftType) return false
        if (startTime != other.startTime) return false
        if (zonalShiftId != other.zonalShiftId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftInResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `appliedStatus` field specifies which application traffic shift is in effect for a resource when there is more than one active traffic shift. There can be more than one application traffic shift in progress at the same time - that is, practice run zonal shifts, customer-initiated zonal shifts, or an autoshift. The `appliedStatus` field for a shift that is in progress for a resource can have one of two values: `APPLIED` or `NOT_APPLIED`. The zonal shift or autoshift that is currently in effect for the resource has an `appliedStatus` set to `APPLIED`.
         *
         * The overall principle for precedence is that zonal shifts that you start as a customer take precedence autoshifts, which take precedence over practice runs. That is, customer-initiated zonal shifts > autoshifts > practice run zonal shifts.
         *
         * For more information, see [How zonal autoshift and practice runs work](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html) in the Amazon Application Recovery Controller Developer Guide.
         */
        public var appliedStatus: aws.sdk.kotlin.services.arczonalshift.model.AppliedStatus? = null
        /**
         * The Availability Zone (for example, `use1-az1`) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.
         */
        public var awayFrom: kotlin.String? = null
        /**
         * A comment that you enter for a customer-initiated zonal shift. Only the latest comment is retained; no comment history is maintained. That is, a new comment overwrites any existing comment string.
         */
        public var comment: kotlin.String? = null
        /**
         * The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at any time.
         *
         * When you start a zonal shift, you specify how long you want it to be active, which ARC converts to an expiry time (expiration time). You can cancel a zonal shift when you're ready to restore traffic to the Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify another length of time to expire in.
         */
        public var expiryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The outcome, or end state, returned for a practice run. The following values can be returned:
         * + **PENDING:** Outcome value when a practice run is in progress.
         * + **SUCCEEDED:** Outcome value when the outcome alarm specified for the practice run configuration does not go into an `ALARM` state during the practice run, and the practice run was not interrupted before it completed the expected 30 minute zonal shift.
         * + **INTERRUPTED:** Outcome value when the practice run was stopped before the expected 30 minute zonal shift duration, or there was another problem with the practice run that created an inconclusive outcome.
         * + **FAILED:** Outcome value when the outcome alarm specified for the practice run configuration goes into an `ALARM` state during the practice run, and the practice run was not interrupted before it completed.
         * + **CAPACITY_CHECK_FAILED:** The check for balanced capacity across Availability Zones for your load balancing and Auto Scaling group resources failed.
         *
         * For more information about practice run outcomes, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html) in the Amazon Application Recovery Controller Developer Guide.
         */
        public var practiceRunOutcome: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunOutcome? = null
        /**
         * The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.
         *
         * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
         * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
         * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
         * + [Application Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
         * + [Network Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
         */
        public var resourceIdentifier: kotlin.String? = null
        /**
         * Defines the zonal shift type.
         */
        public var shiftType: aws.sdk.kotlin.services.arczonalshift.model.ShiftType? = null
        /**
         * The time (UTC) when the zonal shift starts.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of a zonal shift.
         */
        public var zonalShiftId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftInResource) : this() {
            this.appliedStatus = x.appliedStatus
            this.awayFrom = x.awayFrom
            this.comment = x.comment
            this.expiryTime = x.expiryTime
            this.practiceRunOutcome = x.practiceRunOutcome
            this.resourceIdentifier = x.resourceIdentifier
            this.shiftType = x.shiftType
            this.startTime = x.startTime
            this.zonalShiftId = x.zonalShiftId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftInResource = ZonalShiftInResource(this)

        internal fun correctErrors(): Builder {
            if (appliedStatus == null) appliedStatus = AppliedStatus.SdkUnknown("no value provided")
            if (awayFrom == null) awayFrom = ""
            if (comment == null) comment = ""
            if (expiryTime == null) expiryTime = Instant.fromEpochSeconds(0)
            if (resourceIdentifier == null) resourceIdentifier = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (zonalShiftId == null) zonalShiftId = ""
            return this
        }
    }
}
