// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateZonalShiftRequest private constructor(builder: Builder) {
    /**
     * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. A new comment overwrites any existing comment string.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The length of time that you want a zonal shift to be active, which ARC converts to an expiry time (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three days (72 hours).
     *
     * If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a new expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to restore traffic to the Availability Zone.
     *
     * To set a length of time for a zonal shift to be active, specify a whole number, and then one of the following, with no space:
     * + **A lowercase letter m:** To specify that the value is in minutes.
     * + **A lowercase letter h:** To specify that the value is in hours.
     *
     * For example: `20h` means the zonal shift expires in 20 hours. `120m` means the zonal shift expires in 120 minutes (2 hours).
     */
    public val expiresIn: kotlin.String? = builder.expiresIn
    /**
     * The identifier of a zonal shift.
     */
    public val zonalShiftId: kotlin.String? = builder.zonalShiftId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.UpdateZonalShiftRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateZonalShiftRequest(")
        append("comment=$comment,")
        append("expiresIn=$expiresIn,")
        append("zonalShiftId=$zonalShiftId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (expiresIn?.hashCode() ?: 0)
        result = 31 * result + (zonalShiftId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateZonalShiftRequest

        if (comment != other.comment) return false
        if (expiresIn != other.expiresIn) return false
        if (zonalShiftId != other.zonalShiftId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.UpdateZonalShiftRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. A new comment overwrites any existing comment string.
         */
        public var comment: kotlin.String? = null
        /**
         * The length of time that you want a zonal shift to be active, which ARC converts to an expiry time (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three days (72 hours).
         *
         * If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a new expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to restore traffic to the Availability Zone.
         *
         * To set a length of time for a zonal shift to be active, specify a whole number, and then one of the following, with no space:
         * + **A lowercase letter m:** To specify that the value is in minutes.
         * + **A lowercase letter h:** To specify that the value is in hours.
         *
         * For example: `20h` means the zonal shift expires in 20 hours. `120m` means the zonal shift expires in 120 minutes (2 hours).
         */
        public var expiresIn: kotlin.String? = null
        /**
         * The identifier of a zonal shift.
         */
        public var zonalShiftId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.UpdateZonalShiftRequest) : this() {
            this.comment = x.comment
            this.expiresIn = x.expiresIn
            this.zonalShiftId = x.zonalShiftId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.UpdateZonalShiftRequest = UpdateZonalShiftRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
