// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdatePracticeRunConfigurationRequest private constructor(builder: Builder) {
    /**
     * Add, change, or remove windows of days and times for when you can, optionally, allow ARC to start a practice run for a resource.
     *
     * The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple allowed windows with spaces.
     *
     * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this scenario, you could set the following recurring days and times as allowed windows, for example: `Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00`.
     *
     * The `allowedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
     */
    public val allowedWindows: List<String>? = builder.allowedWindows
    /**
     * Add, change, or remove blocked dates for a practice run in zonal autoshift.
     *
     * Optionally, you can block practice runs for specific calendar dates. The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Separate multiple blocked dates with spaces.
     *
     * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want practice runs to shift traffic away at that time, you could set a blocked date for `2024-05-01`.
     */
    public val blockedDates: List<String>? = builder.blockedDates
    /**
     * Add, change, or remove windows of days and times for when you can, optionally, block ARC from starting a practice run for a resource.
     *
     * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple blocked windows with spaces.
     *
     * For example, say you run business report summaries three days a week. For this scenario, you might set the following recurring days and times as blocked windows, for example: `MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30`.
     */
    public val blockedWindows: List<String>? = builder.blockedWindows
    /**
     * Add, change, or remove the Amazon CloudWatch alarms that you optionally specify as the blocking alarms for practice runs.
     */
    public val blockingAlarms: List<ControlCondition>? = builder.blockingAlarms
    /**
     * Specify one or more Amazon CloudWatch alarms as the outcome alarms for practice runs.
     */
    public val outcomeAlarms: List<ControlCondition>? = builder.outcomeAlarms
    /**
     * The identifier for the resource that you want to update the practice run configuration for. The identifier is the Amazon Resource Name (ARN) for the resource.
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.UpdatePracticeRunConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePracticeRunConfigurationRequest(")
        append("allowedWindows=$allowedWindows,")
        append("blockedDates=$blockedDates,")
        append("blockedWindows=$blockedWindows,")
        append("blockingAlarms=$blockingAlarms,")
        append("outcomeAlarms=$outcomeAlarms,")
        append("resourceIdentifier=$resourceIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedWindows?.hashCode() ?: 0
        result = 31 * result + (blockedDates?.hashCode() ?: 0)
        result = 31 * result + (blockedWindows?.hashCode() ?: 0)
        result = 31 * result + (blockingAlarms?.hashCode() ?: 0)
        result = 31 * result + (outcomeAlarms?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePracticeRunConfigurationRequest

        if (allowedWindows != other.allowedWindows) return false
        if (blockedDates != other.blockedDates) return false
        if (blockedWindows != other.blockedWindows) return false
        if (blockingAlarms != other.blockingAlarms) return false
        if (outcomeAlarms != other.outcomeAlarms) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.UpdatePracticeRunConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Add, change, or remove windows of days and times for when you can, optionally, allow ARC to start a practice run for a resource.
         *
         * The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple allowed windows with spaces.
         *
         * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this scenario, you could set the following recurring days and times as allowed windows, for example: `Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00`.
         *
         * The `allowedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
         */
        public var allowedWindows: List<String>? = null
        /**
         * Add, change, or remove blocked dates for a practice run in zonal autoshift.
         *
         * Optionally, you can block practice runs for specific calendar dates. The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Separate multiple blocked dates with spaces.
         *
         * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want practice runs to shift traffic away at that time, you could set a blocked date for `2024-05-01`.
         */
        public var blockedDates: List<String>? = null
        /**
         * Add, change, or remove windows of days and times for when you can, optionally, block ARC from starting a practice run for a resource.
         *
         * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple blocked windows with spaces.
         *
         * For example, say you run business report summaries three days a week. For this scenario, you might set the following recurring days and times as blocked windows, for example: `MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30`.
         */
        public var blockedWindows: List<String>? = null
        /**
         * Add, change, or remove the Amazon CloudWatch alarms that you optionally specify as the blocking alarms for practice runs.
         */
        public var blockingAlarms: List<ControlCondition>? = null
        /**
         * Specify one or more Amazon CloudWatch alarms as the outcome alarms for practice runs.
         */
        public var outcomeAlarms: List<ControlCondition>? = null
        /**
         * The identifier for the resource that you want to update the practice run configuration for. The identifier is the Amazon Resource Name (ARN) for the resource.
         */
        public var resourceIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.UpdatePracticeRunConfigurationRequest) : this() {
            this.allowedWindows = x.allowedWindows
            this.blockedDates = x.blockedDates
            this.blockedWindows = x.blockedWindows
            this.blockingAlarms = x.blockingAlarms
            this.outcomeAlarms = x.outcomeAlarms
            this.resourceIdentifier = x.resourceIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.UpdatePracticeRunConfigurationRequest = UpdatePracticeRunConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
