// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartZonalShiftRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone (for example, `use1-az1`) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.
     */
    public val awayFrom: kotlin.String? = builder.awayFrom
    /**
     * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. A new comment overwrites any existing comment string.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The length of time that you want a zonal shift to be active, which ARC converts to an expiry time (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three days (72 hours).
     *
     * If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a new expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to restore traffic to the Availability Zone.
     *
     * To set a length of time for a zonal shift to be active, specify a whole number, and then one of the following, with no space:
     * + **A lowercase letter m:** To specify that the value is in minutes.
     * + **A lowercase letter h:** To specify that the value is in hours.
     *
     * For example: `20h` means the zonal shift expires in 20 hours. `120m` means the zonal shift expires in 120 minutes (2 hours).
     */
    public val expiresIn: kotlin.String? = builder.expiresIn
    /**
     * The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the Amazon Resource Name (ARN) for the resource.
     *
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
     * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
     * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
     * + [Application Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
     * + [Network Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.StartZonalShiftRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartZonalShiftRequest(")
        append("awayFrom=$awayFrom,")
        append("comment=$comment,")
        append("expiresIn=$expiresIn,")
        append("resourceIdentifier=$resourceIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awayFrom?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (expiresIn?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartZonalShiftRequest

        if (awayFrom != other.awayFrom) return false
        if (comment != other.comment) return false
        if (expiresIn != other.expiresIn) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.StartZonalShiftRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone (for example, `use1-az1`) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.
         */
        public var awayFrom: kotlin.String? = null
        /**
         * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. A new comment overwrites any existing comment string.
         */
        public var comment: kotlin.String? = null
        /**
         * The length of time that you want a zonal shift to be active, which ARC converts to an expiry time (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three days (72 hours).
         *
         * If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a new expiration. You can also cancel a zonal shift, before it expires, for example, if you're ready to restore traffic to the Availability Zone.
         *
         * To set a length of time for a zonal shift to be active, specify a whole number, and then one of the following, with no space:
         * + **A lowercase letter m:** To specify that the value is in minutes.
         * + **A lowercase letter h:** To specify that the value is in hours.
         *
         * For example: `20h` means the zonal shift expires in 20 hours. `120m` means the zonal shift expires in 120 minutes (2 hours).
         */
        public var expiresIn: kotlin.String? = null
        /**
         * The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the Amazon Resource Name (ARN) for the resource.
         *
         * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
         * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
         * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
         * + [Application Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
         * + [Network Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
         */
        public var resourceIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.StartZonalShiftRequest) : this() {
            this.awayFrom = x.awayFrom
            this.comment = x.comment
            this.expiresIn = x.expiresIn
            this.resourceIdentifier = x.resourceIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.StartZonalShiftRequest = StartZonalShiftRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
