// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run. When a resource has a practice run configuration, ARC shifts traffic for the resource weekly for practice runs.
 *
 * Practice runs are required for zonal autoshift. The zonal shifts that ARC starts for practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.
 *
 * You can update or delete a practice run configuration. Before you delete a practice run configuration, you must disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.
 */
public class PracticeRunConfiguration private constructor(builder: Builder) {
    /**
     * An array of one or more windows of days and times that you can allow ARC to start practice runs for a resource.
     *
     * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this scenario, you could set the following recurring days and times as allowed windows, for example: `Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00`.
     *
     * The `allowedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
     */
    public val allowedWindows: List<String>? = builder.allowedWindows
    /**
     * An array of one or more dates that you can specify when Amazon Web Services does not start practice runs for a resource.
     *
     * Specify blocked dates, in UTC, in the format `YYYY-MM-DD`, separated by spaces.
     */
    public val blockedDates: List<String> = builder.blockedDates
    /**
     * An array of one or more windows of days and times that you can block ARC from starting practice runs for a resource.
     *
     * Specify the blocked windows in UTC, using the format `DAY:HH:MM-DAY:HH:MM`, separated by spaces. For example, `MON:18:30-MON:19:30 TUE:18:30-TUE:19:30`.
     *
     * The `blockedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
     */
    public val blockedWindows: List<String>? = builder.blockedWindows
    /**
     * *Blocking alarms* for practice runs are optional alarms that you can specify that block practice runs when one or more of the alarms is in an `ALARM` state.
     */
    public val blockingAlarms: List<ControlCondition>? = builder.blockingAlarms
    /**
     * *Outcome alarms* for practice runs are alarms that you specify that end a practice run when one or more of the alarms is in an `ALARM` state.
     */
    public val outcomeAlarms: List<ControlCondition> = requireNotNull(builder.outcomeAlarms) { "A non-null value must be provided for outcomeAlarms" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PracticeRunConfiguration(")
        append("allowedWindows=$allowedWindows,")
        append("blockedDates=$blockedDates,")
        append("blockedWindows=$blockedWindows,")
        append("blockingAlarms=$blockingAlarms,")
        append("outcomeAlarms=$outcomeAlarms")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedWindows?.hashCode() ?: 0
        result = 31 * result + (blockedDates.hashCode())
        result = 31 * result + (blockedWindows?.hashCode() ?: 0)
        result = 31 * result + (blockingAlarms?.hashCode() ?: 0)
        result = 31 * result + (outcomeAlarms.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PracticeRunConfiguration

        if (allowedWindows != other.allowedWindows) return false
        if (blockedDates != other.blockedDates) return false
        if (blockedWindows != other.blockedWindows) return false
        if (blockingAlarms != other.blockingAlarms) return false
        if (outcomeAlarms != other.outcomeAlarms) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of one or more windows of days and times that you can allow ARC to start practice runs for a resource.
         *
         * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this scenario, you could set the following recurring days and times as allowed windows, for example: `Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00`.
         *
         * The `allowedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
         */
        public var allowedWindows: List<String>? = null
        /**
         * An array of one or more dates that you can specify when Amazon Web Services does not start practice runs for a resource.
         *
         * Specify blocked dates, in UTC, in the format `YYYY-MM-DD`, separated by spaces.
         */
        public var blockedDates: List<String> = listOf()
        /**
         * An array of one or more windows of days and times that you can block ARC from starting practice runs for a resource.
         *
         * Specify the blocked windows in UTC, using the format `DAY:HH:MM-DAY:HH:MM`, separated by spaces. For example, `MON:18:30-MON:19:30 TUE:18:30-TUE:19:30`.
         *
         * The `blockedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
         */
        public var blockedWindows: List<String>? = null
        /**
         * *Blocking alarms* for practice runs are optional alarms that you can specify that block practice runs when one or more of the alarms is in an `ALARM` state.
         */
        public var blockingAlarms: List<ControlCondition>? = null
        /**
         * *Outcome alarms* for practice runs are alarms that you specify that end a practice run when one or more of the alarms is in an `ALARM` state.
         */
        public var outcomeAlarms: List<ControlCondition>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration) : this() {
            this.allowedWindows = x.allowedWindows
            this.blockedDates = x.blockedDates
            this.blockedWindows = x.blockedWindows
            this.blockingAlarms = x.blockingAlarms
            this.outcomeAlarms = x.outcomeAlarms
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration = PracticeRunConfiguration(this)

        internal fun correctErrors(): Builder {
            if (outcomeAlarms == null) outcomeAlarms = emptyList()
            return this
        }
    }
}
