// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex structure for a managed resource in an Amazon Web Services account with information about zonal shifts and autoshifts.
 *
 * You can start a zonal shift in ARC for a managed resource to temporarily move traffic for the resource away from an Availability Zone in an Amazon Web Services Region. You can also configure zonal autoshift for a managed resource.
 *
 * At this time, managed resources are Amazon EC2 Auto Scaling groups, Amazon Elastic Kubernetes Service, Network Load Balancers, and Application Load Balancer.
 */
public class ManagedResourceSummary private constructor(builder: Builder) {
    /**
     * A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
     */
    public val appliedWeights: Map<String, Float>? = builder.appliedWeights
    /**
     * The Amazon Resource Name (ARN) for the managed resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * An array of the autoshifts that have been completed for a resource.
     */
    public val autoshifts: List<AutoshiftInResource>? = builder.autoshifts
    /**
     * The Availability Zones that a resource is deployed in.
     */
    public val availabilityZones: List<String> = requireNotNull(builder.availabilityZones) { "A non-null value must be provided for availabilityZones" }
    /**
     * The name of the managed resource.
     */
    public val name: kotlin.String? = builder.name
    /**
     * This status tracks whether a practice run configuration exists for a resource. When you configure a practice run for a resource so that a practice run configuration exists, ARC sets this value to `ENABLED`. If a you have not configured a practice run for the resource, or delete a practice run configuration, ARC sets the value to `DISABLED`.
     *
     * ARC updates this status; you can't set a practice run status to `ENABLED` or `DISABLED`.
     */
    public val practiceRunStatus: aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus? = builder.practiceRunStatus
    /**
     * The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set the value of the status to `ENABLED` or `DISABLED`.
     */
    public val zonalAutoshiftStatus: aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus? = builder.zonalAutoshiftStatus
    /**
     * An array of the zonal shifts for a resource.
     */
    public val zonalShifts: List<ZonalShiftInResource>? = builder.zonalShifts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.ManagedResourceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedResourceSummary(")
        append("appliedWeights=$appliedWeights,")
        append("arn=$arn,")
        append("autoshifts=$autoshifts,")
        append("availabilityZones=$availabilityZones,")
        append("name=$name,")
        append("practiceRunStatus=$practiceRunStatus,")
        append("zonalAutoshiftStatus=$zonalAutoshiftStatus,")
        append("zonalShifts=$zonalShifts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appliedWeights?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (autoshifts?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (practiceRunStatus?.hashCode() ?: 0)
        result = 31 * result + (zonalAutoshiftStatus?.hashCode() ?: 0)
        result = 31 * result + (zonalShifts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedResourceSummary

        if (appliedWeights != other.appliedWeights) return false
        if (arn != other.arn) return false
        if (autoshifts != other.autoshifts) return false
        if (availabilityZones != other.availabilityZones) return false
        if (name != other.name) return false
        if (practiceRunStatus != other.practiceRunStatus) return false
        if (zonalAutoshiftStatus != other.zonalAutoshiftStatus) return false
        if (zonalShifts != other.zonalShifts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.ManagedResourceSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
         */
        public var appliedWeights: Map<String, Float>? = null
        /**
         * The Amazon Resource Name (ARN) for the managed resource.
         */
        public var arn: kotlin.String? = null
        /**
         * An array of the autoshifts that have been completed for a resource.
         */
        public var autoshifts: List<AutoshiftInResource>? = null
        /**
         * The Availability Zones that a resource is deployed in.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The name of the managed resource.
         */
        public var name: kotlin.String? = null
        /**
         * This status tracks whether a practice run configuration exists for a resource. When you configure a practice run for a resource so that a practice run configuration exists, ARC sets this value to `ENABLED`. If a you have not configured a practice run for the resource, or delete a practice run configuration, ARC sets the value to `DISABLED`.
         *
         * ARC updates this status; you can't set a practice run status to `ENABLED` or `DISABLED`.
         */
        public var practiceRunStatus: aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus? = null
        /**
         * The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set the value of the status to `ENABLED` or `DISABLED`.
         */
        public var zonalAutoshiftStatus: aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus? = null
        /**
         * An array of the zonal shifts for a resource.
         */
        public var zonalShifts: List<ZonalShiftInResource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.ManagedResourceSummary) : this() {
            this.appliedWeights = x.appliedWeights
            this.arn = x.arn
            this.autoshifts = x.autoshifts
            this.availabilityZones = x.availabilityZones
            this.name = x.name
            this.practiceRunStatus = x.practiceRunStatus
            this.zonalAutoshiftStatus = x.zonalAutoshiftStatus
            this.zonalShifts = x.zonalShifts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.ManagedResourceSummary = ManagedResourceSummary(this)

        internal fun correctErrors(): Builder {
            if (availabilityZones == null) availabilityZones = emptyList()
            return this
        }
    }
}
