// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetManagedResourceResponse private constructor(builder: Builder) {
    /**
     * A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
     */
    public val appliedWeights: Map<String, Float> = requireNotNull(builder.appliedWeights) { "A non-null value must be provided for appliedWeights" }
    /**
     * The Amazon Resource Name (ARN) for the resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * An array of the autoshifts that are active for the resource.
     */
    public val autoshifts: List<AutoshiftInResource>? = builder.autoshifts
    /**
     * The name of the resource.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The practice run configuration for zonal autoshift that's associated with the resource.
     */
    public val practiceRunConfiguration: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration? = builder.practiceRunConfiguration
    /**
     * The status for zonal autoshift for a resource. When the autoshift status is `ENABLED`, Amazon Web Services shifts traffic for a resource away from an Availability Zone, on your behalf, when Amazon Web Services determines that there's an issue in the Availability Zone that could potentially affect customers.
     */
    public val zonalAutoshiftStatus: aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus? = builder.zonalAutoshiftStatus
    /**
     * The zonal shifts that are currently active for a resource.
     */
    public val zonalShifts: List<ZonalShiftInResource> = requireNotNull(builder.zonalShifts) { "A non-null value must be provided for zonalShifts" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.GetManagedResourceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetManagedResourceResponse(")
        append("appliedWeights=$appliedWeights,")
        append("arn=$arn,")
        append("autoshifts=$autoshifts,")
        append("name=$name,")
        append("practiceRunConfiguration=$practiceRunConfiguration,")
        append("zonalAutoshiftStatus=$zonalAutoshiftStatus,")
        append("zonalShifts=$zonalShifts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appliedWeights.hashCode()
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (autoshifts?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (practiceRunConfiguration?.hashCode() ?: 0)
        result = 31 * result + (zonalAutoshiftStatus?.hashCode() ?: 0)
        result = 31 * result + (zonalShifts.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetManagedResourceResponse

        if (appliedWeights != other.appliedWeights) return false
        if (arn != other.arn) return false
        if (autoshifts != other.autoshifts) return false
        if (name != other.name) return false
        if (practiceRunConfiguration != other.practiceRunConfiguration) return false
        if (zonalAutoshiftStatus != other.zonalAutoshiftStatus) return false
        if (zonalShifts != other.zonalShifts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.GetManagedResourceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
         */
        public var appliedWeights: Map<String, Float>? = null
        /**
         * The Amazon Resource Name (ARN) for the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * An array of the autoshifts that are active for the resource.
         */
        public var autoshifts: List<AutoshiftInResource>? = null
        /**
         * The name of the resource.
         */
        public var name: kotlin.String? = null
        /**
         * The practice run configuration for zonal autoshift that's associated with the resource.
         */
        public var practiceRunConfiguration: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration? = null
        /**
         * The status for zonal autoshift for a resource. When the autoshift status is `ENABLED`, Amazon Web Services shifts traffic for a resource away from an Availability Zone, on your behalf, when Amazon Web Services determines that there's an issue in the Availability Zone that could potentially affect customers.
         */
        public var zonalAutoshiftStatus: aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus? = null
        /**
         * The zonal shifts that are currently active for a resource.
         */
        public var zonalShifts: List<ZonalShiftInResource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.GetManagedResourceResponse) : this() {
            this.appliedWeights = x.appliedWeights
            this.arn = x.arn
            this.autoshifts = x.autoshifts
            this.name = x.name
            this.practiceRunConfiguration = x.practiceRunConfiguration
            this.zonalAutoshiftStatus = x.zonalAutoshiftStatus
            this.zonalShifts = x.zonalShifts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.GetManagedResourceResponse = GetManagedResourceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration] inside the given [block]
         */
        public fun practiceRunConfiguration(block: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration.Builder.() -> kotlin.Unit) {
            this.practiceRunConfiguration = aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appliedWeights == null) appliedWeights = emptyMap()
            if (zonalShifts == null) zonalShifts = emptyList()
            return this
        }
    }
}
