// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePracticeRunConfigurationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource that you configured the practice run for.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The name of the resource that you configured the practice run for.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A practice run configuration for a resource. Configurations include the outcome alarm that you specify for practice runs, and, optionally, a blocking alarm and blocking dates and windows.
     */
    public val practiceRunConfiguration: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration? = builder.practiceRunConfiguration
    /**
     * The status for zonal autoshift for a resource. When you specify `ENABLED` for the autoshift status, Amazon Web Services shifts traffic away from shifts away application resource traffic from an Availability Zone, on your behalf, when internal telemetry indicates that there is an Availability Zone impairment that could potentially impact customers.
     *
     * When you enable zonal autoshift, you must also configure practice runs for the resource.
     */
    public val zonalAutoshiftStatus: aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus = requireNotNull(builder.zonalAutoshiftStatus) { "A non-null value must be provided for zonalAutoshiftStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePracticeRunConfigurationResponse(")
        append("arn=$arn,")
        append("name=$name,")
        append("practiceRunConfiguration=$practiceRunConfiguration,")
        append("zonalAutoshiftStatus=$zonalAutoshiftStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (practiceRunConfiguration?.hashCode() ?: 0)
        result = 31 * result + (zonalAutoshiftStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePracticeRunConfigurationResponse

        if (arn != other.arn) return false
        if (name != other.name) return false
        if (practiceRunConfiguration != other.practiceRunConfiguration) return false
        if (zonalAutoshiftStatus != other.zonalAutoshiftStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource that you configured the practice run for.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the resource that you configured the practice run for.
         */
        public var name: kotlin.String? = null
        /**
         * A practice run configuration for a resource. Configurations include the outcome alarm that you specify for practice runs, and, optionally, a blocking alarm and blocking dates and windows.
         */
        public var practiceRunConfiguration: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration? = null
        /**
         * The status for zonal autoshift for a resource. When you specify `ENABLED` for the autoshift status, Amazon Web Services shifts traffic away from shifts away application resource traffic from an Availability Zone, on your behalf, when internal telemetry indicates that there is an Availability Zone impairment that could potentially impact customers.
         *
         * When you enable zonal autoshift, you must also configure practice runs for the resource.
         */
        public var zonalAutoshiftStatus: aws.sdk.kotlin.services.arczonalshift.model.ZonalAutoshiftStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationResponse) : this() {
            this.arn = x.arn
            this.name = x.name
            this.practiceRunConfiguration = x.practiceRunConfiguration
            this.zonalAutoshiftStatus = x.zonalAutoshiftStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationResponse = CreatePracticeRunConfigurationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration] inside the given [block]
         */
        public fun practiceRunConfiguration(block: aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration.Builder.() -> kotlin.Unit) {
            this.practiceRunConfiguration = aws.sdk.kotlin.services.arczonalshift.model.PracticeRunConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (name == null) name = ""
            if (zonalAutoshiftStatus == null) zonalAutoshiftStatus = ZonalAutoshiftStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
