// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePracticeRunConfigurationRequest private constructor(builder: Builder) {
    /**
     * Optionally, you can allow ARC to start practice runs for specific windows of days and times.
     *
     * The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple allowed windows with spaces.
     *
     * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this scenario, you could set the following recurring days and times as allowed windows, for example: `Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00`.
     *
     * The `allowedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
     */
    public val allowedWindows: List<String>? = builder.allowedWindows
    /**
     * Optionally, you can block ARC from starting practice runs for a resource on specific calendar dates.
     *
     * The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Separate multiple blocked dates with spaces.
     *
     * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want practice runs to shift traffic away at that time, you could set a blocked date for `2024-05-01`.
     */
    public val blockedDates: List<String>? = builder.blockedDates
    /**
     * Optionally, you can block ARC from starting practice runs for specific windows of days and times.
     *
     * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple blocked windows with spaces.
     *
     * For example, say you run business report summaries three days a week. For this scenario, you could set the following recurring days and times as blocked windows, for example: `Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30 Fri-20:30-Fri:21:30`.
     *
     * The `blockedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
     */
    public val blockedWindows: List<String>? = builder.blockedWindows
    /**
     * *Blocking alarms* for practice runs are optional alarms that you can specify that block practice runs when one or more of the alarms is in an `ALARM` state.
     */
    public val blockingAlarms: List<ControlCondition>? = builder.blockingAlarms
    /**
     * *Outcome alarms* for practice runs are alarms that you specify that end a practice run when one or more of the alarms is in an `ALARM` state.
     *
     * Configure one or more of these alarms to monitor the health of your application when traffic is shifted away from an Availability Zone during each practice run. You should configure these alarms to go into an `ALARM` state if you want to stop a zonal shift, to let traffic for the resource return to the original Availability Zone.
     */
    public val outcomeAlarms: List<ControlCondition>? = builder.outcomeAlarms
    /**
     * The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.
     *
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
     * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
     * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
     * + [Application Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
     * + [Network Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePracticeRunConfigurationRequest(")
        append("allowedWindows=$allowedWindows,")
        append("blockedDates=$blockedDates,")
        append("blockedWindows=$blockedWindows,")
        append("blockingAlarms=$blockingAlarms,")
        append("outcomeAlarms=$outcomeAlarms,")
        append("resourceIdentifier=$resourceIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedWindows?.hashCode() ?: 0
        result = 31 * result + (blockedDates?.hashCode() ?: 0)
        result = 31 * result + (blockedWindows?.hashCode() ?: 0)
        result = 31 * result + (blockingAlarms?.hashCode() ?: 0)
        result = 31 * result + (outcomeAlarms?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePracticeRunConfigurationRequest

        if (allowedWindows != other.allowedWindows) return false
        if (blockedDates != other.blockedDates) return false
        if (blockedWindows != other.blockedWindows) return false
        if (blockingAlarms != other.blockingAlarms) return false
        if (outcomeAlarms != other.outcomeAlarms) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optionally, you can allow ARC to start practice runs for specific windows of days and times.
         *
         * The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple allowed windows with spaces.
         *
         * For example, say you want to allow practice runs only on Wednesdays and Fridays from noon to 5 p.m. For this scenario, you could set the following recurring days and times as allowed windows, for example: `Wed-12:00-Wed:17:00 Fri-12:00-Fri:17:00`.
         *
         * The `allowedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
         */
        public var allowedWindows: List<String>? = null
        /**
         * Optionally, you can block ARC from starting practice runs for a resource on specific calendar dates.
         *
         * The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Separate multiple blocked dates with spaces.
         *
         * For example, if you have an application update scheduled to launch on May 1, 2024, and you don't want practice runs to shift traffic away at that time, you could set a blocked date for `2024-05-01`.
         */
        public var blockedDates: List<String>? = null
        /**
         * Optionally, you can block ARC from starting practice runs for specific windows of days and times.
         *
         * The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple blocked windows with spaces.
         *
         * For example, say you run business report summaries three days a week. For this scenario, you could set the following recurring days and times as blocked windows, for example: `Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30 Fri-20:30-Fri:21:30`.
         *
         * The `blockedWindows` have to start and end on the same day. Windows that span multiple days aren't supported.
         */
        public var blockedWindows: List<String>? = null
        /**
         * *Blocking alarms* for practice runs are optional alarms that you can specify that block practice runs when one or more of the alarms is in an `ALARM` state.
         */
        public var blockingAlarms: List<ControlCondition>? = null
        /**
         * *Outcome alarms* for practice runs are alarms that you specify that end a practice run when one or more of the alarms is in an `ALARM` state.
         *
         * Configure one or more of these alarms to monitor the health of your application when traffic is shifted away from an Availability Zone during each practice run. You should configure these alarms to go into an `ALARM` state if you want to stop a zonal shift, to let traffic for the resource return to the original Availability Zone.
         */
        public var outcomeAlarms: List<ControlCondition>? = null
        /**
         * The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.
         *
         * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
         * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
         * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
         * + [Application Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
         * + [Network Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
         */
        public var resourceIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationRequest) : this() {
            this.allowedWindows = x.allowedWindows
            this.blockedDates = x.blockedDates
            this.blockedWindows = x.blockedWindows
            this.blockingAlarms = x.blockingAlarms
            this.outcomeAlarms = x.outcomeAlarms
            this.resourceIdentifier = x.resourceIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationRequest = CreatePracticeRunConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
