// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A control condition is an alarm that you specify for a practice run. When you configure practice runs with zonal autoshift for a resource, you specify Amazon CloudWatch alarms, which you create in CloudWatch to use with the practice run. The alarms that you specify are an *outcome alarm*, to monitor application health during practice runs and, optionally, a *blocking alarm*, to block practice runs from starting or to interrupt a practice run in progress.
 *
 * Control condition alarms do not apply for autoshifts.
 *
 * For more information, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html) in the Amazon Application Recovery Controller Developer Guide.
 */
public class ControlCondition private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a practice run.
     */
    public val alarmIdentifier: kotlin.String = requireNotNull(builder.alarmIdentifier) { "A non-null value must be provided for alarmIdentifier" }
    /**
     * The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice runs, so the only valid value is `CLOUDWATCH`.
     */
    public val type: aws.sdk.kotlin.services.arczonalshift.model.ControlConditionType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.ControlCondition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlCondition(")
        append("alarmIdentifier=$alarmIdentifier,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmIdentifier.hashCode()
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlCondition

        if (alarmIdentifier != other.alarmIdentifier) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.ControlCondition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a practice run.
         */
        public var alarmIdentifier: kotlin.String? = null
        /**
         * The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice runs, so the only valid value is `CLOUDWATCH`.
         */
        public var type: aws.sdk.kotlin.services.arczonalshift.model.ControlConditionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.ControlCondition) : this() {
            this.alarmIdentifier = x.alarmIdentifier
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.ControlCondition = ControlCondition(this)

        internal fun correctErrors(): Builder {
            if (alarmIdentifier == null) alarmIdentifier = ""
            if (type == null) type = ControlConditionType.SdkUnknown("no value provided")
            return this
        }
    }
}
