// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CancelPracticeRunResponse private constructor(builder: Builder) {
    /**
     * The Availability Zone (for example, `use1-az1`) that traffic was moved away from for a resource that you specified for the practice run.
     */
    public val awayFrom: kotlin.String = requireNotNull(builder.awayFrom) { "A non-null value must be provided for awayFrom" }
    /**
     * The initial comment that you entered about the practice run. Be aware that this comment can be overwritten by Amazon Web Services if the automatic check for balanced capacity fails. For more information, see [ Capacity checks for practice runs](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html) in the Amazon Application Recovery Controller Developer Guide.
     */
    public val comment: kotlin.String = requireNotNull(builder.comment) { "A non-null value must be provided for comment" }
    /**
     * The expiry time (expiration time) for an on-demand practice run zonal shift is 30 minutes from the time when you start the practice run, unless you cancel it before that time. However, be aware that the `expiryTime` field for practice run zonal shifts always has a value of 1 minute.
     */
    public val expiryTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.expiryTime) { "A non-null value must be provided for expiryTime" }
    /**
     * The identifier for the resource that you canceled a practice run zonal shift for. The identifier is the Amazon Resource Name (ARN) for the resource.
     */
    public val resourceIdentifier: kotlin.String = requireNotNull(builder.resourceIdentifier) { "A non-null value must be provided for resourceIdentifier" }
    /**
     * The time (UTC) when the zonal shift starts.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * A status for the practice run that you canceled (expected status is **CANCELED**).
     *
     * The `Status` for a practice run zonal shift can have one of the following values:
     */
    public val status: aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The identifier of the practice run zonal shift in Amazon Application Recovery Controller that was canceled.
     */
    public val zonalShiftId: kotlin.String = requireNotNull(builder.zonalShiftId) { "A non-null value must be provided for zonalShiftId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.CancelPracticeRunResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CancelPracticeRunResponse(")
        append("awayFrom=$awayFrom,")
        append("comment=$comment,")
        append("expiryTime=$expiryTime,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("zonalShiftId=$zonalShiftId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awayFrom.hashCode()
        result = 31 * result + (comment.hashCode())
        result = 31 * result + (expiryTime.hashCode())
        result = 31 * result + (resourceIdentifier.hashCode())
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (zonalShiftId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CancelPracticeRunResponse

        if (awayFrom != other.awayFrom) return false
        if (comment != other.comment) return false
        if (expiryTime != other.expiryTime) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (zonalShiftId != other.zonalShiftId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.CancelPracticeRunResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone (for example, `use1-az1`) that traffic was moved away from for a resource that you specified for the practice run.
         */
        public var awayFrom: kotlin.String? = null
        /**
         * The initial comment that you entered about the practice run. Be aware that this comment can be overwritten by Amazon Web Services if the automatic check for balanced capacity fails. For more information, see [ Capacity checks for practice runs](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html) in the Amazon Application Recovery Controller Developer Guide.
         */
        public var comment: kotlin.String? = null
        /**
         * The expiry time (expiration time) for an on-demand practice run zonal shift is 30 minutes from the time when you start the practice run, unless you cancel it before that time. However, be aware that the `expiryTime` field for practice run zonal shifts always has a value of 1 minute.
         */
        public var expiryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier for the resource that you canceled a practice run zonal shift for. The identifier is the Amazon Resource Name (ARN) for the resource.
         */
        public var resourceIdentifier: kotlin.String? = null
        /**
         * The time (UTC) when the zonal shift starts.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A status for the practice run that you canceled (expected status is **CANCELED**).
         *
         * The `Status` for a practice run zonal shift can have one of the following values:
         */
        public var status: aws.sdk.kotlin.services.arczonalshift.model.ZonalShiftStatus? = null
        /**
         * The identifier of the practice run zonal shift in Amazon Application Recovery Controller that was canceled.
         */
        public var zonalShiftId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.CancelPracticeRunResponse) : this() {
            this.awayFrom = x.awayFrom
            this.comment = x.comment
            this.expiryTime = x.expiryTime
            this.resourceIdentifier = x.resourceIdentifier
            this.startTime = x.startTime
            this.status = x.status
            this.zonalShiftId = x.zonalShiftId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.CancelPracticeRunResponse = CancelPracticeRunResponse(this)

        internal fun correctErrors(): Builder {
            if (awayFrom == null) awayFrom = ""
            if (comment == null) comment = ""
            if (expiryTime == null) expiryTime = Instant.fromEpochSeconds(0)
            if (resourceIdentifier == null) resourceIdentifier = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = ZonalShiftStatus.SdkUnknown("no value provided")
            if (zonalShiftId == null) zonalShiftId = ""
            return this
        }
    }
}
