// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an autoshift. Amazon Web Services starts an autoshift to temporarily move traffic for a resource away from an Availability Zone in an Amazon Web Services Region when Amazon Web Services determines that there's an issue in the Availability Zone that could potentially affect customers. You can configure zonal autoshift in ARC for managed resources in your Amazon Web Services account in a Region. Supported Amazon Web Services resources are automatically registered with ARC.
 *
 * Autoshifts are temporary. When the Availability Zone recovers, Amazon Web Services ends the autoshift, and traffic for the resource is no longer directed to the other Availability Zones in the Region.
 *
 * You can stop an autoshift for a resource by disabling zonal autoshift.
 */
public class AutoshiftSummary private constructor(builder: Builder) {
    /**
     * The Availability Zone (for example, `use1-az1`) that traffic is shifted away from for a resource when Amazon Web Services starts an autoshift. Until the autoshift ends, traffic for the resource is instead directed to other Availability Zones in the Amazon Web Services Region. An autoshift can end for a resource, for example, when Amazon Web Services ends the autoshift for the Availability Zone or when you disable zonal autoshift for the resource.
     */
    public val awayFrom: kotlin.String = requireNotNull(builder.awayFrom) { "A non-null value must be provided for awayFrom" }
    /**
     * The time (in UTC) when the autoshift ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The time (in UTC) when the autoshift started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The status for an autoshift.
     */
    public val status: aws.sdk.kotlin.services.arczonalshift.model.AutoshiftExecutionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.AutoshiftSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoshiftSummary(")
        append("awayFrom=$awayFrom,")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awayFrom.hashCode()
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoshiftSummary

        if (awayFrom != other.awayFrom) return false
        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.AutoshiftSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone (for example, `use1-az1`) that traffic is shifted away from for a resource when Amazon Web Services starts an autoshift. Until the autoshift ends, traffic for the resource is instead directed to other Availability Zones in the Amazon Web Services Region. An autoshift can end for a resource, for example, when Amazon Web Services ends the autoshift for the Availability Zone or when you disable zonal autoshift for the resource.
         */
        public var awayFrom: kotlin.String? = null
        /**
         * The time (in UTC) when the autoshift ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time (in UTC) when the autoshift started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status for an autoshift.
         */
        public var status: aws.sdk.kotlin.services.arczonalshift.model.AutoshiftExecutionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.AutoshiftSummary) : this() {
            this.awayFrom = x.awayFrom
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.AutoshiftSummary = AutoshiftSummary(this)

        internal fun correctErrors(): Builder {
            if (awayFrom == null) awayFrom = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = AutoshiftExecutionStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
