// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A complex structure that lists an autoshift that is currently active for a managed resource and information about the autoshift.
 *
 * For more information, see [How zonal autoshift and practice runs work](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html) in the Amazon Application Recovery Controller Developer Guide.
 */
public class AutoshiftInResource private constructor(builder: Builder) {
    /**
     * The `appliedStatus` field specifies which application traffic shift is in effect for a resource when there is more than one active traffic shift. There can be more than one application traffic shift in progress at the same time - that is, practice run zonal shifts, customer-initiated zonal shifts, or an autoshift. The `appliedStatus` field for a shift that is in progress for a resource can have one of two values: `APPLIED` or `NOT_APPLIED`. The zonal shift or autoshift that is currently in effect for the resource has an `appliedStatus` set to `APPLIED`.
     *
     * The overall principle for precedence is that zonal shifts that you start as a customer take precedence autoshifts, which take precedence over practice runs. That is, customer-initiated zonal shifts > autoshifts > practice run zonal shifts.
     *
     * For more information, see [How zonal autoshift and practice runs work](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html) in the Amazon Application Recovery Controller Developer Guide.
     */
    public val appliedStatus: aws.sdk.kotlin.services.arczonalshift.model.AutoshiftAppliedStatus = requireNotNull(builder.appliedStatus) { "A non-null value must be provided for appliedStatus" }
    /**
     * The Availability Zone (for example, `use1-az1`) that traffic is shifted away from for a resource, when Amazon Web Services starts an autoshift. Until the autoshift ends, traffic for the resource is instead directed to other Availability Zones in the Amazon Web Services Region. An autoshift can end for a resource, for example, when Amazon Web Services ends the autoshift for the Availability Zone or when you disable zonal autoshift for the resource.
     */
    public val awayFrom: kotlin.String = requireNotNull(builder.awayFrom) { "A non-null value must be provided for awayFrom" }
    /**
     * The time (UTC) when the autoshift started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.arczonalshift.model.AutoshiftInResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoshiftInResource(")
        append("appliedStatus=$appliedStatus,")
        append("awayFrom=$awayFrom,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appliedStatus.hashCode()
        result = 31 * result + (awayFrom.hashCode())
        result = 31 * result + (startTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoshiftInResource

        if (appliedStatus != other.appliedStatus) return false
        if (awayFrom != other.awayFrom) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.arczonalshift.model.AutoshiftInResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `appliedStatus` field specifies which application traffic shift is in effect for a resource when there is more than one active traffic shift. There can be more than one application traffic shift in progress at the same time - that is, practice run zonal shifts, customer-initiated zonal shifts, or an autoshift. The `appliedStatus` field for a shift that is in progress for a resource can have one of two values: `APPLIED` or `NOT_APPLIED`. The zonal shift or autoshift that is currently in effect for the resource has an `appliedStatus` set to `APPLIED`.
         *
         * The overall principle for precedence is that zonal shifts that you start as a customer take precedence autoshifts, which take precedence over practice runs. That is, customer-initiated zonal shifts > autoshifts > practice run zonal shifts.
         *
         * For more information, see [How zonal autoshift and practice runs work](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html) in the Amazon Application Recovery Controller Developer Guide.
         */
        public var appliedStatus: aws.sdk.kotlin.services.arczonalshift.model.AutoshiftAppliedStatus? = null
        /**
         * The Availability Zone (for example, `use1-az1`) that traffic is shifted away from for a resource, when Amazon Web Services starts an autoshift. Until the autoshift ends, traffic for the resource is instead directed to other Availability Zones in the Amazon Web Services Region. An autoshift can end for a resource, for example, when Amazon Web Services ends the autoshift for the Availability Zone or when you disable zonal autoshift for the resource.
         */
        public var awayFrom: kotlin.String? = null
        /**
         * The time (UTC) when the autoshift started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.arczonalshift.model.AutoshiftInResource) : this() {
            this.appliedStatus = x.appliedStatus
            this.awayFrom = x.awayFrom
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.arczonalshift.model.AutoshiftInResource = AutoshiftInResource(this)

        internal fun correctErrors(): Builder {
            if (appliedStatus == null) appliedStatus = AutoshiftAppliedStatus.SdkUnknown("no value provided")
            if (awayFrom == null) awayFrom = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
