// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.arczonalshift

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.arczonalshift.auth.ArcZonalShiftAuthSchemeProvider
import aws.sdk.kotlin.services.arczonalshift.auth.DefaultArcZonalShiftAuthSchemeProvider
import aws.sdk.kotlin.services.arczonalshift.endpoints.ArcZonalShiftEndpointParameters
import aws.sdk.kotlin.services.arczonalshift.endpoints.ArcZonalShiftEndpointProvider
import aws.sdk.kotlin.services.arczonalshift.endpoints.DefaultArcZonalShiftEndpointProvider
import aws.sdk.kotlin.services.arczonalshift.model.CancelPracticeRunRequest
import aws.sdk.kotlin.services.arczonalshift.model.CancelPracticeRunResponse
import aws.sdk.kotlin.services.arczonalshift.model.CancelZonalShiftRequest
import aws.sdk.kotlin.services.arczonalshift.model.CancelZonalShiftResponse
import aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationRequest
import aws.sdk.kotlin.services.arczonalshift.model.CreatePracticeRunConfigurationResponse
import aws.sdk.kotlin.services.arczonalshift.model.DeletePracticeRunConfigurationRequest
import aws.sdk.kotlin.services.arczonalshift.model.DeletePracticeRunConfigurationResponse
import aws.sdk.kotlin.services.arczonalshift.model.GetAutoshiftObserverNotificationStatusRequest
import aws.sdk.kotlin.services.arczonalshift.model.GetAutoshiftObserverNotificationStatusResponse
import aws.sdk.kotlin.services.arczonalshift.model.GetManagedResourceRequest
import aws.sdk.kotlin.services.arczonalshift.model.GetManagedResourceResponse
import aws.sdk.kotlin.services.arczonalshift.model.ListAutoshiftsRequest
import aws.sdk.kotlin.services.arczonalshift.model.ListAutoshiftsResponse
import aws.sdk.kotlin.services.arczonalshift.model.ListManagedResourcesRequest
import aws.sdk.kotlin.services.arczonalshift.model.ListManagedResourcesResponse
import aws.sdk.kotlin.services.arczonalshift.model.ListZonalShiftsRequest
import aws.sdk.kotlin.services.arczonalshift.model.ListZonalShiftsResponse
import aws.sdk.kotlin.services.arczonalshift.model.StartPracticeRunRequest
import aws.sdk.kotlin.services.arczonalshift.model.StartPracticeRunResponse
import aws.sdk.kotlin.services.arczonalshift.model.StartZonalShiftRequest
import aws.sdk.kotlin.services.arczonalshift.model.StartZonalShiftResponse
import aws.sdk.kotlin.services.arczonalshift.model.UpdateAutoshiftObserverNotificationStatusRequest
import aws.sdk.kotlin.services.arczonalshift.model.UpdateAutoshiftObserverNotificationStatusResponse
import aws.sdk.kotlin.services.arczonalshift.model.UpdatePracticeRunConfigurationRequest
import aws.sdk.kotlin.services.arczonalshift.model.UpdatePracticeRunConfigurationResponse
import aws.sdk.kotlin.services.arczonalshift.model.UpdateZonalAutoshiftConfigurationRequest
import aws.sdk.kotlin.services.arczonalshift.model.UpdateZonalAutoshiftConfigurationResponse
import aws.sdk.kotlin.services.arczonalshift.model.UpdateZonalShiftRequest
import aws.sdk.kotlin.services.arczonalshift.model.UpdateZonalShiftResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "ARC Zonal Shift"
public const val SdkVersion: String = "1.5.27"
public const val ServiceApiVersion: String = "2022-10-30"

/**
 * Welcome to the API Reference Guide for zonal shift and zonal autoshift in Amazon Application Recovery Controller (ARC).
 *
 * You can start a zonal shift to move traffic for a load balancer resource away from an Availability Zone to help your application recover quickly from an impairment in an Availability Zone. For example, you can recover your application from a developer's bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone.
 *
 * You can also configure zonal autoshift for supported load balancer resources. Zonal autoshift is a capability in ARC where you authorize Amazon Web Services to shift away application resource traffic from an Availability Zone during events, on your behalf, to help reduce your time to recovery. Amazon Web Services starts an autoshift when internal telemetry indicates that there is an Availability Zone impairment that could potentially impact customers.
 *
 * For more information about using zonal shift and zonal autoshift, see the [Amazon Application Recovery Controller Developer Guide](https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route53-recovery.html).
 */
public interface ArcZonalShiftClient : SdkClient {
    /**
     * ArcZonalShiftClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ArcZonalShiftClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ArcZonalShift",
                "ARC_ZONAL_SHIFT",
                "arc_zonal_shift",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ArcZonalShiftClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ArcZonalShiftClient = DefaultArcZonalShiftClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ArcZonalShiftEndpointProvider = builder.endpointProvider ?: DefaultArcZonalShiftEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ArcZonalShiftAuthSchemeProvider = builder.authSchemeProvider ?: DefaultArcZonalShiftAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ARC Zonal Shift"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ArcZonalShiftEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ArcZonalShiftAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancel an in-progress practice run zonal shift in Amazon Application Recovery Controller.
     */
    public suspend fun cancelPracticeRun(input: CancelPracticeRunRequest): CancelPracticeRunResponse

    /**
     * Cancel a zonal shift in Amazon Application Recovery Controller. To cancel the zonal shift, specify the zonal shift ID.
     *
     * A zonal shift can be one that you've started for a resource in your Amazon Web Services account in an Amazon Web Services Region, or it can be a zonal shift started by a practice run with zonal autoshift.
     */
    public suspend fun cancelZonalShift(input: CancelZonalShiftRequest): CancelZonalShiftResponse

    /**
     * A practice run configuration for zonal autoshift is required when you enable zonal autoshift. A practice run configuration includes specifications for blocked dates and blocked time windows, and for Amazon CloudWatch alarms that you create to use with practice runs. The alarms that you specify are an *outcome alarm*, to monitor application health during practice runs and, optionally, a *blocking alarm*, to block practice runs from starting.
     *
     * When a resource has a practice run configuration, ARC starts zonal shifts for the resource weekly, to shift traffic for practice runs. Practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.
     *
     * For more information, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html) in the Amazon Application Recovery Controller Developer Guide.
     */
    public suspend fun createPracticeRunConfiguration(input: CreatePracticeRunConfigurationRequest): CreatePracticeRunConfigurationResponse

    /**
     * Deletes the practice run configuration for a resource. Before you can delete a practice run configuration for a resource., you must disable zonal autoshift for the resource. Practice runs must be configured for zonal autoshift to be enabled.
     */
    public suspend fun deletePracticeRunConfiguration(input: DeletePracticeRunConfigurationRequest): DeletePracticeRunConfigurationResponse

    /**
     * Returns the status of the autoshift observer notification. Autoshift observer notifications notify you through Amazon EventBridge when there is an autoshift event for zonal autoshift. The status can be `ENABLED` or `DISABLED`. When `ENABLED`, a notification is sent when an autoshift is triggered. When `DISABLED`, notifications are not sent.
     */
    public suspend fun getAutoshiftObserverNotificationStatus(input: GetAutoshiftObserverNotificationStatusRequest = GetAutoshiftObserverNotificationStatusRequest { }): GetAutoshiftObserverNotificationStatusResponse

    /**
     * Get information about a resource that's been registered for zonal shifts with Amazon Application Recovery Controller in this Amazon Web Services Region. Resources that are registered for zonal shifts are managed resources in ARC. You can start zonal shifts and configure zonal autoshift for managed resources.
     */
    public suspend fun getManagedResource(input: GetManagedResourceRequest): GetManagedResourceResponse

    /**
     * Returns the autoshifts for an Amazon Web Services Region. By default, the call returns only `ACTIVE` autoshifts. Optionally, you can specify the `status` parameter to return `COMPLETED` autoshifts.
     */
    public suspend fun listAutoshifts(input: ListAutoshiftsRequest = ListAutoshiftsRequest { }): ListAutoshiftsResponse

    /**
     * Lists all the resources in your Amazon Web Services account in this Amazon Web Services Region that are managed for zonal shifts in Amazon Application Recovery Controller, and information about them. The information includes the zonal autoshift status for the resource, as well as the Amazon Resource Name (ARN), the Availability Zones that each resource is deployed in, and the resource name.
     */
    public suspend fun listManagedResources(input: ListManagedResourcesRequest = ListManagedResourcesRequest { }): ListManagedResourcesResponse

    /**
     * Lists all active and completed zonal shifts in Amazon Application Recovery Controller in your Amazon Web Services account in this Amazon Web Services Region. `ListZonalShifts` returns customer-initiated zonal shifts, as well as practice run zonal shifts that ARC started on your behalf for zonal autoshift.
     *
     * For more information about listing autoshifts, see [">ListAutoshifts](https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListAutoshifts.html).
     */
    public suspend fun listZonalShifts(input: ListZonalShiftsRequest = ListZonalShiftsRequest { }): ListZonalShiftsResponse

    /**
     * Start an on-demand practice run zonal shift in Amazon Application Recovery Controller. With zonal autoshift enabled, you can start an on-demand practice run to verify preparedness at any time. Amazon Web Services also runs automated practice runs about weekly when you have enabled zonal autoshift.
     *
     * For more information, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html) in the Amazon Application Recovery Controller Developer Guide.
     */
    public suspend fun startPracticeRun(input: StartPracticeRunRequest): StartPracticeRunResponse

    /**
     * You start a zonal shift to temporarily move load balancer traffic away from an Availability Zone in an Amazon Web Services Region, to help your application recover immediately, for example, from a developer's bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone. You can start a zonal shift in ARC only for managed resources in your Amazon Web Services account in an Amazon Web Services Region. Resources are automatically registered with ARC by Amazon Web Services services.
     *
     * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
     * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
     * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
     * + [Application Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
     * + [Network Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
     *
     * When you start a zonal shift, traffic for the resource is no longer routed to the Availability Zone. The zonal shift is created immediately in ARC. However, it can take a short time, typically up to a few minutes, for existing, in-progress connections in the Availability Zone to complete.
     *
     * For more information, see [Zonal shift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.html) in the Amazon Application Recovery Controller Developer Guide.
     */
    public suspend fun startZonalShift(input: StartZonalShiftRequest): StartZonalShiftResponse

    /**
     * Update the status of autoshift observer notification. Autoshift observer notification enables you to be notified, through Amazon EventBridge, when there is an autoshift event for zonal autoshift.
     *
     * If the status is `ENABLED`, ARC includes all autoshift events when you use the EventBridge pattern `Autoshift In Progress`. When the status is `DISABLED`, ARC includes only autoshift events for autoshifts when one or more of your resources is included in the autoshift.
     *
     * For more information, see [ Notifications for practice runs and autoshifts](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html#ZAShiftNotification) in the Amazon Application Recovery Controller Developer Guide.
     */
    public suspend fun updateAutoshiftObserverNotificationStatus(input: UpdateAutoshiftObserverNotificationStatusRequest): UpdateAutoshiftObserverNotificationStatusResponse

    /**
     * Update a practice run configuration to change one or more of the following: add, change, or remove the blocking alarm; change the outcome alarm; or add, change, or remove blocking dates or time windows.
     */
    public suspend fun updatePracticeRunConfiguration(input: UpdatePracticeRunConfigurationRequest): UpdatePracticeRunConfigurationResponse

    /**
     * The zonal autoshift configuration for a resource includes the practice run configuration and the status for running autoshifts, zonal autoshift status. When a resource has a practice run configuration, ARC starts weekly zonal shifts for the resource, to shift traffic away from an Availability Zone. Weekly practice runs help you to make sure that your application can continue to operate normally with the loss of one Availability Zone.
     *
     * You can update the zonal autoshift status to enable or disable zonal autoshift. When zonal autoshift is `ENABLED`, you authorize Amazon Web Services to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery. Traffic is also shifted away for the required weekly practice runs.
     */
    public suspend fun updateZonalAutoshiftConfiguration(input: UpdateZonalAutoshiftConfigurationRequest): UpdateZonalAutoshiftConfigurationResponse

    /**
     * Update an active zonal shift in Amazon Application Recovery Controller in your Amazon Web Services account. You can update a zonal shift to set a new expiration, or edit or replace the comment for the zonal shift.
     */
    public suspend fun updateZonalShift(input: UpdateZonalShiftRequest): UpdateZonalShiftResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ArcZonalShiftClient.withConfig(block: ArcZonalShiftClient.Config.Builder.() -> Unit): ArcZonalShiftClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultArcZonalShiftClient(newConfig)
}

/**
 * Cancel an in-progress practice run zonal shift in Amazon Application Recovery Controller.
 */
public suspend inline fun ArcZonalShiftClient.cancelPracticeRun(crossinline block: CancelPracticeRunRequest.Builder.() -> Unit): CancelPracticeRunResponse = cancelPracticeRun(CancelPracticeRunRequest.Builder().apply(block).build())

/**
 * Cancel a zonal shift in Amazon Application Recovery Controller. To cancel the zonal shift, specify the zonal shift ID.
 *
 * A zonal shift can be one that you've started for a resource in your Amazon Web Services account in an Amazon Web Services Region, or it can be a zonal shift started by a practice run with zonal autoshift.
 */
public suspend inline fun ArcZonalShiftClient.cancelZonalShift(crossinline block: CancelZonalShiftRequest.Builder.() -> Unit): CancelZonalShiftResponse = cancelZonalShift(CancelZonalShiftRequest.Builder().apply(block).build())

/**
 * A practice run configuration for zonal autoshift is required when you enable zonal autoshift. A practice run configuration includes specifications for blocked dates and blocked time windows, and for Amazon CloudWatch alarms that you create to use with practice runs. The alarms that you specify are an *outcome alarm*, to monitor application health during practice runs and, optionally, a *blocking alarm*, to block practice runs from starting.
 *
 * When a resource has a practice run configuration, ARC starts zonal shifts for the resource weekly, to shift traffic for practice runs. Practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.
 *
 * For more information, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html) in the Amazon Application Recovery Controller Developer Guide.
 */
public suspend inline fun ArcZonalShiftClient.createPracticeRunConfiguration(crossinline block: CreatePracticeRunConfigurationRequest.Builder.() -> Unit): CreatePracticeRunConfigurationResponse = createPracticeRunConfiguration(CreatePracticeRunConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the practice run configuration for a resource. Before you can delete a practice run configuration for a resource., you must disable zonal autoshift for the resource. Practice runs must be configured for zonal autoshift to be enabled.
 */
public suspend inline fun ArcZonalShiftClient.deletePracticeRunConfiguration(crossinline block: DeletePracticeRunConfigurationRequest.Builder.() -> Unit): DeletePracticeRunConfigurationResponse = deletePracticeRunConfiguration(DeletePracticeRunConfigurationRequest.Builder().apply(block).build())

/**
 * Returns the status of the autoshift observer notification. Autoshift observer notifications notify you through Amazon EventBridge when there is an autoshift event for zonal autoshift. The status can be `ENABLED` or `DISABLED`. When `ENABLED`, a notification is sent when an autoshift is triggered. When `DISABLED`, notifications are not sent.
 */
public suspend inline fun ArcZonalShiftClient.getAutoshiftObserverNotificationStatus(crossinline block: GetAutoshiftObserverNotificationStatusRequest.Builder.() -> Unit): GetAutoshiftObserverNotificationStatusResponse = getAutoshiftObserverNotificationStatus(GetAutoshiftObserverNotificationStatusRequest.Builder().apply(block).build())

/**
 * Get information about a resource that's been registered for zonal shifts with Amazon Application Recovery Controller in this Amazon Web Services Region. Resources that are registered for zonal shifts are managed resources in ARC. You can start zonal shifts and configure zonal autoshift for managed resources.
 */
public suspend inline fun ArcZonalShiftClient.getManagedResource(crossinline block: GetManagedResourceRequest.Builder.() -> Unit): GetManagedResourceResponse = getManagedResource(GetManagedResourceRequest.Builder().apply(block).build())

/**
 * Returns the autoshifts for an Amazon Web Services Region. By default, the call returns only `ACTIVE` autoshifts. Optionally, you can specify the `status` parameter to return `COMPLETED` autoshifts.
 */
public suspend inline fun ArcZonalShiftClient.listAutoshifts(crossinline block: ListAutoshiftsRequest.Builder.() -> Unit): ListAutoshiftsResponse = listAutoshifts(ListAutoshiftsRequest.Builder().apply(block).build())

/**
 * Lists all the resources in your Amazon Web Services account in this Amazon Web Services Region that are managed for zonal shifts in Amazon Application Recovery Controller, and information about them. The information includes the zonal autoshift status for the resource, as well as the Amazon Resource Name (ARN), the Availability Zones that each resource is deployed in, and the resource name.
 */
public suspend inline fun ArcZonalShiftClient.listManagedResources(crossinline block: ListManagedResourcesRequest.Builder.() -> Unit): ListManagedResourcesResponse = listManagedResources(ListManagedResourcesRequest.Builder().apply(block).build())

/**
 * Lists all active and completed zonal shifts in Amazon Application Recovery Controller in your Amazon Web Services account in this Amazon Web Services Region. `ListZonalShifts` returns customer-initiated zonal shifts, as well as practice run zonal shifts that ARC started on your behalf for zonal autoshift.
 *
 * For more information about listing autoshifts, see [">ListAutoshifts](https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListAutoshifts.html).
 */
public suspend inline fun ArcZonalShiftClient.listZonalShifts(crossinline block: ListZonalShiftsRequest.Builder.() -> Unit): ListZonalShiftsResponse = listZonalShifts(ListZonalShiftsRequest.Builder().apply(block).build())

/**
 * Start an on-demand practice run zonal shift in Amazon Application Recovery Controller. With zonal autoshift enabled, you can start an on-demand practice run to verify preparedness at any time. Amazon Web Services also runs automated practice runs about weekly when you have enabled zonal autoshift.
 *
 * For more information, see [ Considerations when you configure zonal autoshift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html) in the Amazon Application Recovery Controller Developer Guide.
 */
public suspend inline fun ArcZonalShiftClient.startPracticeRun(crossinline block: StartPracticeRunRequest.Builder.() -> Unit): StartPracticeRunResponse = startPracticeRun(StartPracticeRunRequest.Builder().apply(block).build())

/**
 * You start a zonal shift to temporarily move load balancer traffic away from an Availability Zone in an Amazon Web Services Region, to help your application recover immediately, for example, from a developer's bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone. You can start a zonal shift in ARC only for managed resources in your Amazon Web Services account in an Amazon Web Services Region. Resources are automatically registered with ARC by Amazon Web Services services.
 *
 * Amazon Application Recovery Controller currently supports enabling the following resources for zonal shift and zonal autoshift:
 * + [Amazon EC2 Auto Scaling groups](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html)
 * + [Amazon Elastic Kubernetes Service](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html)
 * + [Application Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html)
 * + [Network Load Balancer](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html)
 *
 * When you start a zonal shift, traffic for the resource is no longer routed to the Availability Zone. The zonal shift is created immediately in ARC. However, it can take a short time, typically up to a few minutes, for existing, in-progress connections in the Availability Zone to complete.
 *
 * For more information, see [Zonal shift](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.html) in the Amazon Application Recovery Controller Developer Guide.
 */
public suspend inline fun ArcZonalShiftClient.startZonalShift(crossinline block: StartZonalShiftRequest.Builder.() -> Unit): StartZonalShiftResponse = startZonalShift(StartZonalShiftRequest.Builder().apply(block).build())

/**
 * Update the status of autoshift observer notification. Autoshift observer notification enables you to be notified, through Amazon EventBridge, when there is an autoshift event for zonal autoshift.
 *
 * If the status is `ENABLED`, ARC includes all autoshift events when you use the EventBridge pattern `Autoshift In Progress`. When the status is `DISABLED`, ARC includes only autoshift events for autoshifts when one or more of your resources is included in the autoshift.
 *
 * For more information, see [ Notifications for practice runs and autoshifts](https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html#ZAShiftNotification) in the Amazon Application Recovery Controller Developer Guide.
 */
public suspend inline fun ArcZonalShiftClient.updateAutoshiftObserverNotificationStatus(crossinline block: UpdateAutoshiftObserverNotificationStatusRequest.Builder.() -> Unit): UpdateAutoshiftObserverNotificationStatusResponse = updateAutoshiftObserverNotificationStatus(UpdateAutoshiftObserverNotificationStatusRequest.Builder().apply(block).build())

/**
 * Update a practice run configuration to change one or more of the following: add, change, or remove the blocking alarm; change the outcome alarm; or add, change, or remove blocking dates or time windows.
 */
public suspend inline fun ArcZonalShiftClient.updatePracticeRunConfiguration(crossinline block: UpdatePracticeRunConfigurationRequest.Builder.() -> Unit): UpdatePracticeRunConfigurationResponse = updatePracticeRunConfiguration(UpdatePracticeRunConfigurationRequest.Builder().apply(block).build())

/**
 * The zonal autoshift configuration for a resource includes the practice run configuration and the status for running autoshifts, zonal autoshift status. When a resource has a practice run configuration, ARC starts weekly zonal shifts for the resource, to shift traffic away from an Availability Zone. Weekly practice runs help you to make sure that your application can continue to operate normally with the loss of one Availability Zone.
 *
 * You can update the zonal autoshift status to enable or disable zonal autoshift. When zonal autoshift is `ENABLED`, you authorize Amazon Web Services to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery. Traffic is also shifted away for the required weekly practice runs.
 */
public suspend inline fun ArcZonalShiftClient.updateZonalAutoshiftConfiguration(crossinline block: UpdateZonalAutoshiftConfigurationRequest.Builder.() -> Unit): UpdateZonalAutoshiftConfigurationResponse = updateZonalAutoshiftConfiguration(UpdateZonalAutoshiftConfigurationRequest.Builder().apply(block).build())

/**
 * Update an active zonal shift in Amazon Application Recovery Controller in your Amazon Web Services account. You can update a zonal shift to set a new expiration, or edit or replace the comment for the zonal shift.
 */
public suspend inline fun ArcZonalShiftClient.updateZonalShift(crossinline block: UpdateZonalShiftRequest.Builder.() -> Unit): UpdateZonalShiftResponse = updateZonalShift(UpdateZonalShiftRequest.Builder().apply(block).build())
