// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.serde

import aws.sdk.kotlin.services.apptest.model.AppTestException
import aws.sdk.kotlin.services.apptest.model.GetTestRunStepResponse
import aws.sdk.kotlin.services.apptest.model.StepRunStatus
import aws.sdk.kotlin.services.apptest.model.StepRunSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetTestRunStepOperationDeserializer: HttpDeserializer.NonStreaming<GetTestRunStepResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTestRunStepResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTestRunStepError(context, call, payload)
        }
        val builder = GetTestRunStepResponse.Builder()

        if (payload != null) {
            deserializeGetTestRunStepOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTestRunStepError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppTestException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppTestException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTestRunStepOperationBody(builder: GetTestRunStepResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AFTERSTEP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("afterStep"))
    val BEFORESTEP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("beforeStep"))
    val RUNENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("runEndTime"))
    val RUNSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("runStartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val STEPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stepName"))
    val STEPRUNSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("stepRunSummary"))
    val TESTCASEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testCaseId"))
    val TESTCASEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("testCaseVersion"))
    val TESTRUNID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testRunId"))
    val TESTSUITEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSuiteId"))
    val TESTSUITEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("testSuiteVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AFTERSTEP_DESCRIPTOR)
        field(BEFORESTEP_DESCRIPTOR)
        field(RUNENDTIME_DESCRIPTOR)
        field(RUNSTARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(STEPNAME_DESCRIPTOR)
        field(STEPRUNSUMMARY_DESCRIPTOR)
        field(TESTCASEID_DESCRIPTOR)
        field(TESTCASEVERSION_DESCRIPTOR)
        field(TESTRUNID_DESCRIPTOR)
        field(TESTSUITEID_DESCRIPTOR)
        field(TESTSUITEVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AFTERSTEP_DESCRIPTOR.index -> builder.afterStep = deserializeBoolean()
                BEFORESTEP_DESCRIPTOR.index -> builder.beforeStep = deserializeBoolean()
                RUNENDTIME_DESCRIPTOR.index -> builder.runEndTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                RUNSTARTTIME_DESCRIPTOR.index -> builder.runStartTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { StepRunStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                STEPNAME_DESCRIPTOR.index -> builder.stepName = deserializeString()
                STEPRUNSUMMARY_DESCRIPTOR.index -> builder.stepRunSummary = deserializeStepRunSummaryDocument(deserializer)
                TESTCASEID_DESCRIPTOR.index -> builder.testCaseId = deserializeString()
                TESTCASEVERSION_DESCRIPTOR.index -> builder.testCaseVersion = deserializeInt()
                TESTRUNID_DESCRIPTOR.index -> builder.testRunId = deserializeString()
                TESTSUITEID_DESCRIPTOR.index -> builder.testSuiteId = deserializeString()
                TESTSUITEVERSION_DESCRIPTOR.index -> builder.testSuiteVersion = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
