// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.serde

import aws.sdk.kotlin.services.apptest.model.AppTestException
import aws.sdk.kotlin.services.apptest.model.GetTestCaseResponse
import aws.sdk.kotlin.services.apptest.model.Step
import aws.sdk.kotlin.services.apptest.model.TestCaseLatestVersion
import aws.sdk.kotlin.services.apptest.model.TestCaseLifecycle
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetTestCaseOperationDeserializer: HttpDeserializer.NonStreaming<GetTestCaseResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTestCaseResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTestCaseError(context, call, payload)
        }
        val builder = GetTestCaseResponse.Builder()

        if (payload != null) {
            deserializeGetTestCaseOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTestCaseError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppTestException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppTestException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTestCaseOperationBody(builder: GetTestCaseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LASTUPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdateTime"))
    val LATESTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestVersion"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val STEPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("steps"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TESTCASEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testCaseArn"))
    val TESTCASEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testCaseId"))
    val TESTCASEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("testCaseVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTUPDATETIME_DESCRIPTOR)
        field(LATESTVERSION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(STEPS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TESTCASEARN_DESCRIPTOR)
        field(TESTCASEID_DESCRIPTOR)
        field(TESTCASEVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTUPDATETIME_DESCRIPTOR.index -> builder.lastUpdateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LATESTVERSION_DESCRIPTOR.index -> builder.latestVersion = deserializeTestCaseLatestVersionDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TestCaseLifecycle.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                STEPS_DESCRIPTOR.index -> builder.steps =
                    deserializer.deserializeList(STEPS_DESCRIPTOR) {
                        val col0 = mutableListOf<Step>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStepDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TESTCASEARN_DESCRIPTOR.index -> builder.testCaseArn = deserializeString()
                TESTCASEID_DESCRIPTOR.index -> builder.testCaseId = deserializeString()
                TESTCASEVERSION_DESCRIPTOR.index -> builder.testCaseVersion = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
