// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.paginators

import aws.sdk.kotlin.services.apptest.AppTestClient
import aws.sdk.kotlin.services.apptest.model.ListTestCasesRequest
import aws.sdk.kotlin.services.apptest.model.ListTestCasesResponse
import aws.sdk.kotlin.services.apptest.model.ListTestConfigurationsRequest
import aws.sdk.kotlin.services.apptest.model.ListTestConfigurationsResponse
import aws.sdk.kotlin.services.apptest.model.ListTestRunStepsRequest
import aws.sdk.kotlin.services.apptest.model.ListTestRunStepsResponse
import aws.sdk.kotlin.services.apptest.model.ListTestRunTestCasesRequest
import aws.sdk.kotlin.services.apptest.model.ListTestRunTestCasesResponse
import aws.sdk.kotlin.services.apptest.model.ListTestRunsRequest
import aws.sdk.kotlin.services.apptest.model.ListTestRunsResponse
import aws.sdk.kotlin.services.apptest.model.ListTestSuitesRequest
import aws.sdk.kotlin.services.apptest.model.ListTestSuitesResponse
import aws.sdk.kotlin.services.apptest.model.TestCaseRunSummary
import aws.sdk.kotlin.services.apptest.model.TestCaseSummary
import aws.sdk.kotlin.services.apptest.model.TestConfigurationSummary
import aws.sdk.kotlin.services.apptest.model.TestRunStepSummary
import aws.sdk.kotlin.services.apptest.model.TestRunSummary
import aws.sdk.kotlin.services.apptest.model.TestSuiteSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListTestCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestCasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestCasesResponse]
 */
public fun AppTestClient.listTestCasesPaginated(initialRequest: ListTestCasesRequest = ListTestCasesRequest { }): Flow<ListTestCasesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestCasesPaginated.listTestCases(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestCasesResponse]
 */
public fun AppTestClient.listTestCasesPaginated(block: ListTestCasesRequest.Builder.() -> Unit): Flow<ListTestCasesResponse> =
    listTestCasesPaginated(ListTestCasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTestCasesPaginated]
 * to access the nested member [TestCaseSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TestCaseSummary]
 */
@JvmName("listTestCasesResponseTestCaseSummary")
public fun Flow<ListTestCasesResponse>.testCases(): Flow<TestCaseSummary> =
    transform() { response ->
        response.testCases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTestConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestConfigurationsResponse]
 */
public fun AppTestClient.listTestConfigurationsPaginated(initialRequest: ListTestConfigurationsRequest = ListTestConfigurationsRequest { }): Flow<ListTestConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestConfigurationsPaginated.listTestConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestConfigurationsResponse]
 */
public fun AppTestClient.listTestConfigurationsPaginated(block: ListTestConfigurationsRequest.Builder.() -> Unit): Flow<ListTestConfigurationsResponse> =
    listTestConfigurationsPaginated(ListTestConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTestConfigurationsPaginated]
 * to access the nested member [TestConfigurationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TestConfigurationSummary]
 */
@JvmName("listTestConfigurationsResponseTestConfigurationSummary")
public fun Flow<ListTestConfigurationsResponse>.testConfigurations(): Flow<TestConfigurationSummary> =
    transform() { response ->
        response.testConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTestRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestRunsResponse]
 */
public fun AppTestClient.listTestRunsPaginated(initialRequest: ListTestRunsRequest = ListTestRunsRequest { }): Flow<ListTestRunsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestRunsPaginated.listTestRuns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestRunsResponse]
 */
public fun AppTestClient.listTestRunsPaginated(block: ListTestRunsRequest.Builder.() -> Unit): Flow<ListTestRunsResponse> =
    listTestRunsPaginated(ListTestRunsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTestRunsPaginated]
 * to access the nested member [TestRunSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TestRunSummary]
 */
@JvmName("listTestRunsResponseTestRunSummary")
public fun Flow<ListTestRunsResponse>.testRuns(): Flow<TestRunSummary> =
    transform() { response ->
        response.testRuns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTestRunStepsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestRunStepsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestRunStepsResponse]
 */
public fun AppTestClient.listTestRunStepsPaginated(initialRequest: ListTestRunStepsRequest): Flow<ListTestRunStepsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestRunStepsPaginated.listTestRunSteps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestRunStepsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestRunStepsResponse]
 */
public fun AppTestClient.listTestRunStepsPaginated(block: ListTestRunStepsRequest.Builder.() -> Unit): Flow<ListTestRunStepsResponse> =
    listTestRunStepsPaginated(ListTestRunStepsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTestRunStepsPaginated]
 * to access the nested member [TestRunStepSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TestRunStepSummary]
 */
@JvmName("listTestRunStepsResponseTestRunStepSummary")
public fun Flow<ListTestRunStepsResponse>.testRunSteps(): Flow<TestRunStepSummary> =
    transform() { response ->
        response.testRunSteps?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTestRunTestCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestRunTestCasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestRunTestCasesResponse]
 */
public fun AppTestClient.listTestRunTestCasesPaginated(initialRequest: ListTestRunTestCasesRequest): Flow<ListTestRunTestCasesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestRunTestCasesPaginated.listTestRunTestCases(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestRunTestCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestRunTestCasesResponse]
 */
public fun AppTestClient.listTestRunTestCasesPaginated(block: ListTestRunTestCasesRequest.Builder.() -> Unit): Flow<ListTestRunTestCasesResponse> =
    listTestRunTestCasesPaginated(ListTestRunTestCasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTestRunTestCasesPaginated]
 * to access the nested member [TestCaseRunSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TestCaseRunSummary]
 */
@JvmName("listTestRunTestCasesResponseTestCaseRunSummary")
public fun Flow<ListTestRunTestCasesResponse>.testRunTestCases(): Flow<TestCaseRunSummary> =
    transform() { response ->
        response.testRunTestCases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTestSuitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestSuitesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestSuitesResponse]
 */
public fun AppTestClient.listTestSuitesPaginated(initialRequest: ListTestSuitesRequest = ListTestSuitesRequest { }): Flow<ListTestSuitesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestSuitesPaginated.listTestSuites(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestSuitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestSuitesResponse]
 */
public fun AppTestClient.listTestSuitesPaginated(block: ListTestSuitesRequest.Builder.() -> Unit): Flow<ListTestSuitesResponse> =
    listTestSuitesPaginated(ListTestSuitesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTestSuitesPaginated]
 * to access the nested member [TestSuiteSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TestSuiteSummary]
 */
@JvmName("listTestSuitesResponseTestSuiteSummary")
public fun Flow<ListTestSuitesResponse>.testSuites(): Flow<TestSuiteSummary> =
    transform() { response ->
        response.testSuites?.forEach {
            emit(it)
        }
    }
