// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.apptest.auth.AppTestAuthSchemeProvider
import aws.sdk.kotlin.services.apptest.auth.DefaultAppTestAuthSchemeProvider
import aws.sdk.kotlin.services.apptest.endpoints.AppTestEndpointParameters
import aws.sdk.kotlin.services.apptest.endpoints.AppTestEndpointProvider
import aws.sdk.kotlin.services.apptest.endpoints.DefaultAppTestEndpointProvider
import aws.sdk.kotlin.services.apptest.model.CreateTestCaseRequest
import aws.sdk.kotlin.services.apptest.model.CreateTestCaseResponse
import aws.sdk.kotlin.services.apptest.model.CreateTestConfigurationRequest
import aws.sdk.kotlin.services.apptest.model.CreateTestConfigurationResponse
import aws.sdk.kotlin.services.apptest.model.CreateTestSuiteRequest
import aws.sdk.kotlin.services.apptest.model.CreateTestSuiteResponse
import aws.sdk.kotlin.services.apptest.model.DeleteTestCaseRequest
import aws.sdk.kotlin.services.apptest.model.DeleteTestCaseResponse
import aws.sdk.kotlin.services.apptest.model.DeleteTestConfigurationRequest
import aws.sdk.kotlin.services.apptest.model.DeleteTestConfigurationResponse
import aws.sdk.kotlin.services.apptest.model.DeleteTestRunRequest
import aws.sdk.kotlin.services.apptest.model.DeleteTestRunResponse
import aws.sdk.kotlin.services.apptest.model.DeleteTestSuiteRequest
import aws.sdk.kotlin.services.apptest.model.DeleteTestSuiteResponse
import aws.sdk.kotlin.services.apptest.model.GetTestCaseRequest
import aws.sdk.kotlin.services.apptest.model.GetTestCaseResponse
import aws.sdk.kotlin.services.apptest.model.GetTestConfigurationRequest
import aws.sdk.kotlin.services.apptest.model.GetTestConfigurationResponse
import aws.sdk.kotlin.services.apptest.model.GetTestRunStepRequest
import aws.sdk.kotlin.services.apptest.model.GetTestRunStepResponse
import aws.sdk.kotlin.services.apptest.model.GetTestSuiteRequest
import aws.sdk.kotlin.services.apptest.model.GetTestSuiteResponse
import aws.sdk.kotlin.services.apptest.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.apptest.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.apptest.model.ListTestCasesRequest
import aws.sdk.kotlin.services.apptest.model.ListTestCasesResponse
import aws.sdk.kotlin.services.apptest.model.ListTestConfigurationsRequest
import aws.sdk.kotlin.services.apptest.model.ListTestConfigurationsResponse
import aws.sdk.kotlin.services.apptest.model.ListTestRunStepsRequest
import aws.sdk.kotlin.services.apptest.model.ListTestRunStepsResponse
import aws.sdk.kotlin.services.apptest.model.ListTestRunTestCasesRequest
import aws.sdk.kotlin.services.apptest.model.ListTestRunTestCasesResponse
import aws.sdk.kotlin.services.apptest.model.ListTestRunsRequest
import aws.sdk.kotlin.services.apptest.model.ListTestRunsResponse
import aws.sdk.kotlin.services.apptest.model.ListTestSuitesRequest
import aws.sdk.kotlin.services.apptest.model.ListTestSuitesResponse
import aws.sdk.kotlin.services.apptest.model.StartTestRunRequest
import aws.sdk.kotlin.services.apptest.model.StartTestRunResponse
import aws.sdk.kotlin.services.apptest.model.TagResourceRequest
import aws.sdk.kotlin.services.apptest.model.TagResourceResponse
import aws.sdk.kotlin.services.apptest.model.UntagResourceRequest
import aws.sdk.kotlin.services.apptest.model.UntagResourceResponse
import aws.sdk.kotlin.services.apptest.model.UpdateTestCaseRequest
import aws.sdk.kotlin.services.apptest.model.UpdateTestCaseResponse
import aws.sdk.kotlin.services.apptest.model.UpdateTestConfigurationRequest
import aws.sdk.kotlin.services.apptest.model.UpdateTestConfigurationResponse
import aws.sdk.kotlin.services.apptest.model.UpdateTestSuiteRequest
import aws.sdk.kotlin.services.apptest.model.UpdateTestSuiteResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "AppTest"
public const val SdkVersion: String = "1.3.83"
public const val ServiceApiVersion: String = "2022-12-06"

/**
 * AWS Mainframe Modernization Application Testing provides tools and resources for automated functional equivalence testing for your migration projects.
 */
public interface AppTestClient : SdkClient {
    /**
     * AppTestClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppTestClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AppTest",
                "APPTEST",
                "apptest",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppTestClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppTestClient = DefaultAppTestClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppTestEndpointProvider = builder.endpointProvider ?: DefaultAppTestEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppTestAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppTestAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AppTest"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppTestEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppTestAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a test case.
     */
    public suspend fun createTestCase(input: CreateTestCaseRequest): CreateTestCaseResponse

    /**
     * Creates a test configuration.
     */
    public suspend fun createTestConfiguration(input: CreateTestConfigurationRequest): CreateTestConfigurationResponse

    /**
     * Creates a test suite.
     */
    public suspend fun createTestSuite(input: CreateTestSuiteRequest): CreateTestSuiteResponse

    /**
     * Deletes a test case.
     */
    public suspend fun deleteTestCase(input: DeleteTestCaseRequest): DeleteTestCaseResponse

    /**
     * Deletes a test configuration.
     */
    public suspend fun deleteTestConfiguration(input: DeleteTestConfigurationRequest): DeleteTestConfigurationResponse

    /**
     * Deletes a test run.
     */
    public suspend fun deleteTestRun(input: DeleteTestRunRequest): DeleteTestRunResponse

    /**
     * Deletes a test suite.
     */
    public suspend fun deleteTestSuite(input: DeleteTestSuiteRequest): DeleteTestSuiteResponse

    /**
     * Gets a test case.
     */
    public suspend fun getTestCase(input: GetTestCaseRequest): GetTestCaseResponse

    /**
     * Gets a test configuration.
     */
    public suspend fun getTestConfiguration(input: GetTestConfigurationRequest): GetTestConfigurationResponse

    /**
     * Gets a test run step.
     */
    public suspend fun getTestRunStep(input: GetTestRunStepRequest): GetTestRunStepResponse

    /**
     * Gets a test suite.
     */
    public suspend fun getTestSuite(input: GetTestSuiteRequest): GetTestSuiteResponse

    /**
     * Lists tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists test cases.
     */
    public suspend fun listTestCases(input: ListTestCasesRequest = ListTestCasesRequest { }): ListTestCasesResponse

    /**
     * Lists test configurations.
     */
    public suspend fun listTestConfigurations(input: ListTestConfigurationsRequest = ListTestConfigurationsRequest { }): ListTestConfigurationsResponse

    /**
     * Lists test run steps.
     */
    public suspend fun listTestRunSteps(input: ListTestRunStepsRequest): ListTestRunStepsResponse

    /**
     * Lists test run test cases.
     */
    public suspend fun listTestRunTestCases(input: ListTestRunTestCasesRequest): ListTestRunTestCasesResponse

    /**
     * Lists test runs.
     */
    public suspend fun listTestRuns(input: ListTestRunsRequest = ListTestRunsRequest { }): ListTestRunsResponse

    /**
     * Lists test suites.
     */
    public suspend fun listTestSuites(input: ListTestSuitesRequest = ListTestSuitesRequest { }): ListTestSuitesResponse

    /**
     * Starts a test run.
     */
    public suspend fun startTestRun(input: StartTestRunRequest): StartTestRunResponse

    /**
     * Specifies tags of a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untags a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a test case.
     */
    public suspend fun updateTestCase(input: UpdateTestCaseRequest): UpdateTestCaseResponse

    /**
     * Updates a test configuration.
     */
    public suspend fun updateTestConfiguration(input: UpdateTestConfigurationRequest): UpdateTestConfigurationResponse

    /**
     * Updates a test suite.
     */
    public suspend fun updateTestSuite(input: UpdateTestSuiteRequest): UpdateTestSuiteResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppTestClient.withConfig(block: AppTestClient.Config.Builder.() -> Unit): AppTestClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppTestClient(newConfig)
}

/**
 * Creates a test case.
 */
public suspend inline fun AppTestClient.createTestCase(crossinline block: CreateTestCaseRequest.Builder.() -> Unit): CreateTestCaseResponse = createTestCase(CreateTestCaseRequest.Builder().apply(block).build())

/**
 * Creates a test configuration.
 */
public suspend inline fun AppTestClient.createTestConfiguration(crossinline block: CreateTestConfigurationRequest.Builder.() -> Unit): CreateTestConfigurationResponse = createTestConfiguration(CreateTestConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a test suite.
 */
public suspend inline fun AppTestClient.createTestSuite(crossinline block: CreateTestSuiteRequest.Builder.() -> Unit): CreateTestSuiteResponse = createTestSuite(CreateTestSuiteRequest.Builder().apply(block).build())

/**
 * Deletes a test case.
 */
public suspend inline fun AppTestClient.deleteTestCase(crossinline block: DeleteTestCaseRequest.Builder.() -> Unit): DeleteTestCaseResponse = deleteTestCase(DeleteTestCaseRequest.Builder().apply(block).build())

/**
 * Deletes a test configuration.
 */
public suspend inline fun AppTestClient.deleteTestConfiguration(crossinline block: DeleteTestConfigurationRequest.Builder.() -> Unit): DeleteTestConfigurationResponse = deleteTestConfiguration(DeleteTestConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a test run.
 */
public suspend inline fun AppTestClient.deleteTestRun(crossinline block: DeleteTestRunRequest.Builder.() -> Unit): DeleteTestRunResponse = deleteTestRun(DeleteTestRunRequest.Builder().apply(block).build())

/**
 * Deletes a test suite.
 */
public suspend inline fun AppTestClient.deleteTestSuite(crossinline block: DeleteTestSuiteRequest.Builder.() -> Unit): DeleteTestSuiteResponse = deleteTestSuite(DeleteTestSuiteRequest.Builder().apply(block).build())

/**
 * Gets a test case.
 */
public suspend inline fun AppTestClient.getTestCase(crossinline block: GetTestCaseRequest.Builder.() -> Unit): GetTestCaseResponse = getTestCase(GetTestCaseRequest.Builder().apply(block).build())

/**
 * Gets a test configuration.
 */
public suspend inline fun AppTestClient.getTestConfiguration(crossinline block: GetTestConfigurationRequest.Builder.() -> Unit): GetTestConfigurationResponse = getTestConfiguration(GetTestConfigurationRequest.Builder().apply(block).build())

/**
 * Gets a test run step.
 */
public suspend inline fun AppTestClient.getTestRunStep(crossinline block: GetTestRunStepRequest.Builder.() -> Unit): GetTestRunStepResponse = getTestRunStep(GetTestRunStepRequest.Builder().apply(block).build())

/**
 * Gets a test suite.
 */
public suspend inline fun AppTestClient.getTestSuite(crossinline block: GetTestSuiteRequest.Builder.() -> Unit): GetTestSuiteResponse = getTestSuite(GetTestSuiteRequest.Builder().apply(block).build())

/**
 * Lists tags for a resource.
 */
public suspend inline fun AppTestClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists test cases.
 */
public suspend inline fun AppTestClient.listTestCases(crossinline block: ListTestCasesRequest.Builder.() -> Unit): ListTestCasesResponse = listTestCases(ListTestCasesRequest.Builder().apply(block).build())

/**
 * Lists test configurations.
 */
public suspend inline fun AppTestClient.listTestConfigurations(crossinline block: ListTestConfigurationsRequest.Builder.() -> Unit): ListTestConfigurationsResponse = listTestConfigurations(ListTestConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists test run steps.
 */
public suspend inline fun AppTestClient.listTestRunSteps(crossinline block: ListTestRunStepsRequest.Builder.() -> Unit): ListTestRunStepsResponse = listTestRunSteps(ListTestRunStepsRequest.Builder().apply(block).build())

/**
 * Lists test run test cases.
 */
public suspend inline fun AppTestClient.listTestRunTestCases(crossinline block: ListTestRunTestCasesRequest.Builder.() -> Unit): ListTestRunTestCasesResponse = listTestRunTestCases(ListTestRunTestCasesRequest.Builder().apply(block).build())

/**
 * Lists test runs.
 */
public suspend inline fun AppTestClient.listTestRuns(crossinline block: ListTestRunsRequest.Builder.() -> Unit): ListTestRunsResponse = listTestRuns(ListTestRunsRequest.Builder().apply(block).build())

/**
 * Lists test suites.
 */
public suspend inline fun AppTestClient.listTestSuites(crossinline block: ListTestSuitesRequest.Builder.() -> Unit): ListTestSuitesResponse = listTestSuites(ListTestSuitesRequest.Builder().apply(block).build())

/**
 * Starts a test run.
 */
public suspend inline fun AppTestClient.startTestRun(crossinline block: StartTestRunRequest.Builder.() -> Unit): StartTestRunResponse = startTestRun(StartTestRunRequest.Builder().apply(block).build())

/**
 * Specifies tags of a resource.
 */
public suspend inline fun AppTestClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untags a resource.
 */
public suspend inline fun AppTestClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a test case.
 */
public suspend inline fun AppTestClient.updateTestCase(crossinline block: UpdateTestCaseRequest.Builder.() -> Unit): UpdateTestCaseResponse = updateTestCase(UpdateTestCaseRequest.Builder().apply(block).build())

/**
 * Updates a test configuration.
 */
public suspend inline fun AppTestClient.updateTestConfiguration(crossinline block: UpdateTestConfigurationRequest.Builder.() -> Unit): UpdateTestConfigurationResponse = updateTestConfiguration(UpdateTestConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a test suite.
 */
public suspend inline fun AppTestClient.updateTestSuite(crossinline block: UpdateTestSuiteRequest.Builder.() -> Unit): UpdateTestSuiteResponse = updateTestSuite(UpdateTestSuiteRequest.Builder().apply(block).build())
