// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies a test run step summary.
 */
public class TestRunStepSummary private constructor(builder: Builder) {
    /**
     * The after step of the test run step summary.
     */
    public val afterStep: kotlin.Boolean? = builder.afterStep
    /**
     * The before step of the test run step summary.
     */
    public val beforeStep: kotlin.Boolean? = builder.beforeStep
    /**
     * The run end time of the test run step summary.
     */
    public val runEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.runEndTime
    /**
     * The run start time of the test run step summary.
     */
    public val runStartTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.runStartTime) { "A non-null value must be provided for runStartTime" }
    /**
     * The status of the test run step summary.
     */
    public val status: aws.sdk.kotlin.services.apptest.model.StepRunStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status reason of the test run step summary.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The step name of the test run step summary.
     */
    public val stepName: kotlin.String = requireNotNull(builder.stepName) { "A non-null value must be provided for stepName" }
    /**
     * The test case ID of the test run step summary.
     */
    public val testCaseId: kotlin.String? = builder.testCaseId
    /**
     * The test case version of the test run step summary.
     */
    public val testCaseVersion: kotlin.Int? = builder.testCaseVersion
    /**
     * The test run ID of the test run step summary.
     */
    public val testRunId: kotlin.String = requireNotNull(builder.testRunId) { "A non-null value must be provided for testRunId" }
    /**
     * The test suite ID of the test run step summary.
     */
    public val testSuiteId: kotlin.String? = builder.testSuiteId
    /**
     * The test suite version of the test run step summary.
     */
    public val testSuiteVersion: kotlin.Int? = builder.testSuiteVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apptest.model.TestRunStepSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestRunStepSummary(")
        append("afterStep=$afterStep,")
        append("beforeStep=$beforeStep,")
        append("runEndTime=$runEndTime,")
        append("runStartTime=$runStartTime,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("stepName=$stepName,")
        append("testCaseId=$testCaseId,")
        append("testCaseVersion=$testCaseVersion,")
        append("testRunId=$testRunId,")
        append("testSuiteId=$testSuiteId,")
        append("testSuiteVersion=$testSuiteVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = afterStep?.hashCode() ?: 0
        result = 31 * result + (beforeStep?.hashCode() ?: 0)
        result = 31 * result + (runEndTime?.hashCode() ?: 0)
        result = 31 * result + (runStartTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (stepName.hashCode())
        result = 31 * result + (testCaseId?.hashCode() ?: 0)
        result = 31 * result + (testCaseVersion ?: 0)
        result = 31 * result + (testRunId.hashCode())
        result = 31 * result + (testSuiteId?.hashCode() ?: 0)
        result = 31 * result + (testSuiteVersion ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestRunStepSummary

        if (afterStep != other.afterStep) return false
        if (beforeStep != other.beforeStep) return false
        if (runEndTime != other.runEndTime) return false
        if (runStartTime != other.runStartTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (stepName != other.stepName) return false
        if (testCaseId != other.testCaseId) return false
        if (testCaseVersion != other.testCaseVersion) return false
        if (testRunId != other.testRunId) return false
        if (testSuiteId != other.testSuiteId) return false
        if (testSuiteVersion != other.testSuiteVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apptest.model.TestRunStepSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The after step of the test run step summary.
         */
        public var afterStep: kotlin.Boolean? = null
        /**
         * The before step of the test run step summary.
         */
        public var beforeStep: kotlin.Boolean? = null
        /**
         * The run end time of the test run step summary.
         */
        public var runEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The run start time of the test run step summary.
         */
        public var runStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the test run step summary.
         */
        public var status: aws.sdk.kotlin.services.apptest.model.StepRunStatus? = null
        /**
         * The status reason of the test run step summary.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The step name of the test run step summary.
         */
        public var stepName: kotlin.String? = null
        /**
         * The test case ID of the test run step summary.
         */
        public var testCaseId: kotlin.String? = null
        /**
         * The test case version of the test run step summary.
         */
        public var testCaseVersion: kotlin.Int? = null
        /**
         * The test run ID of the test run step summary.
         */
        public var testRunId: kotlin.String? = null
        /**
         * The test suite ID of the test run step summary.
         */
        public var testSuiteId: kotlin.String? = null
        /**
         * The test suite version of the test run step summary.
         */
        public var testSuiteVersion: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apptest.model.TestRunStepSummary) : this() {
            this.afterStep = x.afterStep
            this.beforeStep = x.beforeStep
            this.runEndTime = x.runEndTime
            this.runStartTime = x.runStartTime
            this.status = x.status
            this.statusReason = x.statusReason
            this.stepName = x.stepName
            this.testCaseId = x.testCaseId
            this.testCaseVersion = x.testCaseVersion
            this.testRunId = x.testRunId
            this.testSuiteId = x.testSuiteId
            this.testSuiteVersion = x.testSuiteVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apptest.model.TestRunStepSummary = TestRunStepSummary(this)

        internal fun correctErrors(): Builder {
            if (runStartTime == null) runStartTime = Instant.fromEpochSeconds(0)
            if (status == null) status = StepRunStatus.SdkUnknown("no value provided")
            if (stepName == null) stepName = ""
            if (testRunId == null) testRunId = ""
            return this
        }
    }
}
