// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.serde

import aws.sdk.kotlin.services.apptest.model.AppTestException
import aws.sdk.kotlin.services.apptest.model.GetTestSuiteResponse
import aws.sdk.kotlin.services.apptest.model.Step
import aws.sdk.kotlin.services.apptest.model.TestCases
import aws.sdk.kotlin.services.apptest.model.TestSuiteLatestVersion
import aws.sdk.kotlin.services.apptest.model.TestSuiteLifecycle
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetTestSuiteOperationDeserializer: HttpDeserializer.NonStreaming<GetTestSuiteResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTestSuiteResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTestSuiteError(context, call, payload)
        }
        val builder = GetTestSuiteResponse.Builder()

        if (payload != null) {
            deserializeGetTestSuiteOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTestSuiteError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppTestException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppTestException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTestSuiteOperationBody(builder: GetTestSuiteResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AFTERSTEPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("afterSteps"))
    val BEFORESTEPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("beforeSteps"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LASTUPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdateTime"))
    val LATESTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestVersion"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TESTCASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("testCases"))
    val TESTSUITEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSuiteArn"))
    val TESTSUITEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSuiteId"))
    val TESTSUITEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("testSuiteVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AFTERSTEPS_DESCRIPTOR)
        field(BEFORESTEPS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTUPDATETIME_DESCRIPTOR)
        field(LATESTVERSION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TESTCASES_DESCRIPTOR)
        field(TESTSUITEARN_DESCRIPTOR)
        field(TESTSUITEID_DESCRIPTOR)
        field(TESTSUITEVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AFTERSTEPS_DESCRIPTOR.index -> builder.afterSteps =
                    deserializer.deserializeList(AFTERSTEPS_DESCRIPTOR) {
                        val col0 = mutableListOf<Step>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStepDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BEFORESTEPS_DESCRIPTOR.index -> builder.beforeSteps =
                    deserializer.deserializeList(BEFORESTEPS_DESCRIPTOR) {
                        val col0 = mutableListOf<Step>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStepDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTUPDATETIME_DESCRIPTOR.index -> builder.lastUpdateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LATESTVERSION_DESCRIPTOR.index -> builder.latestVersion = deserializeTestSuiteLatestVersionDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TestSuiteLifecycle.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TESTCASES_DESCRIPTOR.index -> builder.testCases = deserializeTestCasesDocument(deserializer)
                TESTSUITEARN_DESCRIPTOR.index -> builder.testSuiteArn = deserializeString()
                TESTSUITEID_DESCRIPTOR.index -> builder.testSuiteId = deserializeString()
                TESTSUITEVERSION_DESCRIPTOR.index -> builder.testSuiteVersion = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
