// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies a test run summary.
 */
public class TestRunSummary private constructor(builder: Builder) {
    /**
     * The run end time of the test run summary.
     */
    public val runEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.runEndTime
    /**
     * The run start time of the test run summary.
     */
    public val runStartTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.runStartTime) { "A non-null value must be provided for runStartTime" }
    /**
     * The status of the test run summary.
     */
    public val status: aws.sdk.kotlin.services.apptest.model.TestRunStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status reason of the test run summary.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The test configuration ID of the test run summary.
     */
    public val testConfigurationId: kotlin.String? = builder.testConfigurationId
    /**
     * The test configuration version of the test run summary.
     */
    public val testConfigurationVersion: kotlin.Int? = builder.testConfigurationVersion
    /**
     * The test run ARN of the test run summary.
     */
    public val testRunArn: kotlin.String = requireNotNull(builder.testRunArn) { "A non-null value must be provided for testRunArn" }
    /**
     * The test run ID of the test run summary.
     */
    public val testRunId: kotlin.String = requireNotNull(builder.testRunId) { "A non-null value must be provided for testRunId" }
    /**
     * The test suite ID of the test run summary.
     */
    public val testSuiteId: kotlin.String = requireNotNull(builder.testSuiteId) { "A non-null value must be provided for testSuiteId" }
    /**
     * The test suite version of the test run summary.
     */
    public val testSuiteVersion: kotlin.Int = requireNotNull(builder.testSuiteVersion) { "A non-null value must be provided for testSuiteVersion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apptest.model.TestRunSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestRunSummary(")
        append("runEndTime=$runEndTime,")
        append("runStartTime=$runStartTime,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("testConfigurationId=$testConfigurationId,")
        append("testConfigurationVersion=$testConfigurationVersion,")
        append("testRunArn=$testRunArn,")
        append("testRunId=$testRunId,")
        append("testSuiteId=$testSuiteId,")
        append("testSuiteVersion=$testSuiteVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = runEndTime?.hashCode() ?: 0
        result = 31 * result + (runStartTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (testConfigurationId?.hashCode() ?: 0)
        result = 31 * result + (testConfigurationVersion ?: 0)
        result = 31 * result + (testRunArn.hashCode())
        result = 31 * result + (testRunId.hashCode())
        result = 31 * result + (testSuiteId.hashCode())
        result = 31 * result + (testSuiteVersion)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestRunSummary

        if (runEndTime != other.runEndTime) return false
        if (runStartTime != other.runStartTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (testConfigurationId != other.testConfigurationId) return false
        if (testConfigurationVersion != other.testConfigurationVersion) return false
        if (testRunArn != other.testRunArn) return false
        if (testRunId != other.testRunId) return false
        if (testSuiteId != other.testSuiteId) return false
        if (testSuiteVersion != other.testSuiteVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apptest.model.TestRunSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The run end time of the test run summary.
         */
        public var runEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The run start time of the test run summary.
         */
        public var runStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the test run summary.
         */
        public var status: aws.sdk.kotlin.services.apptest.model.TestRunStatus? = null
        /**
         * The status reason of the test run summary.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The test configuration ID of the test run summary.
         */
        public var testConfigurationId: kotlin.String? = null
        /**
         * The test configuration version of the test run summary.
         */
        public var testConfigurationVersion: kotlin.Int? = null
        /**
         * The test run ARN of the test run summary.
         */
        public var testRunArn: kotlin.String? = null
        /**
         * The test run ID of the test run summary.
         */
        public var testRunId: kotlin.String? = null
        /**
         * The test suite ID of the test run summary.
         */
        public var testSuiteId: kotlin.String? = null
        /**
         * The test suite version of the test run summary.
         */
        public var testSuiteVersion: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apptest.model.TestRunSummary) : this() {
            this.runEndTime = x.runEndTime
            this.runStartTime = x.runStartTime
            this.status = x.status
            this.statusReason = x.statusReason
            this.testConfigurationId = x.testConfigurationId
            this.testConfigurationVersion = x.testConfigurationVersion
            this.testRunArn = x.testRunArn
            this.testRunId = x.testRunId
            this.testSuiteId = x.testSuiteId
            this.testSuiteVersion = x.testSuiteVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apptest.model.TestRunSummary = TestRunSummary(this)

        internal fun correctErrors(): Builder {
            if (runStartTime == null) runStartTime = Instant.fromEpochSeconds(0)
            if (status == null) status = TestRunStatus.SdkUnknown("no value provided")
            if (testRunArn == null) testRunArn = ""
            if (testRunId == null) testRunId = ""
            if (testSuiteId == null) testSuiteId = ""
            if (testSuiteVersion == null) testSuiteVersion = 0
            return this
        }
    }
}
