// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies a test case summary.
 */
public class TestCaseSummary private constructor(builder: Builder) {
    /**
     * The creation time of the test case summary.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The last update time of the test case summary.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateTime) { "A non-null value must be provided for lastUpdateTime" }
    /**
     * The latest version of the test case summary.
     */
    public val latestVersion: kotlin.Int = requireNotNull(builder.latestVersion) { "A non-null value must be provided for latestVersion" }
    /**
     * The name of the test case summary.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the test case summary.
     */
    public val status: aws.sdk.kotlin.services.apptest.model.TestCaseLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status reason of the test case summary.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The test case Amazon Resource Name (ARN) of the test case summary.
     */
    public val testCaseArn: kotlin.String = requireNotNull(builder.testCaseArn) { "A non-null value must be provided for testCaseArn" }
    /**
     * The test case ID of the test case summary.
     */
    public val testCaseId: kotlin.String = requireNotNull(builder.testCaseId) { "A non-null value must be provided for testCaseId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apptest.model.TestCaseSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestCaseSummary(")
        append("creationTime=$creationTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("latestVersion=$latestVersion,")
        append("name=$name,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("testCaseArn=$testCaseArn,")
        append("testCaseId=$testCaseId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (lastUpdateTime.hashCode())
        result = 31 * result + (latestVersion)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (testCaseArn.hashCode())
        result = 31 * result + (testCaseId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestCaseSummary

        if (creationTime != other.creationTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (latestVersion != other.latestVersion) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (testCaseArn != other.testCaseArn) return false
        if (testCaseId != other.testCaseId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apptest.model.TestCaseSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The creation time of the test case summary.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last update time of the test case summary.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The latest version of the test case summary.
         */
        public var latestVersion: kotlin.Int? = null
        /**
         * The name of the test case summary.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the test case summary.
         */
        public var status: aws.sdk.kotlin.services.apptest.model.TestCaseLifecycle? = null
        /**
         * The status reason of the test case summary.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The test case Amazon Resource Name (ARN) of the test case summary.
         */
        public var testCaseArn: kotlin.String? = null
        /**
         * The test case ID of the test case summary.
         */
        public var testCaseId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apptest.model.TestCaseSummary) : this() {
            this.creationTime = x.creationTime
            this.lastUpdateTime = x.lastUpdateTime
            this.latestVersion = x.latestVersion
            this.name = x.name
            this.status = x.status
            this.statusReason = x.statusReason
            this.testCaseArn = x.testCaseArn
            this.testCaseId = x.testCaseId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apptest.model.TestCaseSummary = TestCaseSummary(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (lastUpdateTime == null) lastUpdateTime = Instant.fromEpochSeconds(0)
            if (latestVersion == null) latestVersion = 0
            if (name == null) name = ""
            if (status == null) status = TestCaseLifecycle.SdkUnknown("no value provided")
            if (testCaseArn == null) testCaseArn = ""
            if (testCaseId == null) testCaseId = ""
            return this
        }
    }
}
