// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies the test case run summary.
 */
public class TestCaseRunSummary private constructor(builder: Builder) {
    /**
     * The run end time of the test case run summary.
     */
    public val runEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.runEndTime
    /**
     * The run start time of the test case run summary.
     */
    public val runStartTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.runStartTime) { "A non-null value must be provided for runStartTime" }
    /**
     * The status of the test case run summary.
     */
    public val status: aws.sdk.kotlin.services.apptest.model.TestCaseRunStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status reason of the test case run summary.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The test case id of the test case run summary.
     */
    public val testCaseId: kotlin.String = requireNotNull(builder.testCaseId) { "A non-null value must be provided for testCaseId" }
    /**
     * The test case version of the test case run summary.
     */
    public val testCaseVersion: kotlin.Int = requireNotNull(builder.testCaseVersion) { "A non-null value must be provided for testCaseVersion" }
    /**
     * The test run id of the test case run summary.
     */
    public val testRunId: kotlin.String = requireNotNull(builder.testRunId) { "A non-null value must be provided for testRunId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apptest.model.TestCaseRunSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestCaseRunSummary(")
        append("runEndTime=$runEndTime,")
        append("runStartTime=$runStartTime,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("testCaseId=$testCaseId,")
        append("testCaseVersion=$testCaseVersion,")
        append("testRunId=$testRunId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = runEndTime?.hashCode() ?: 0
        result = 31 * result + (runStartTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (testCaseId.hashCode())
        result = 31 * result + (testCaseVersion)
        result = 31 * result + (testRunId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestCaseRunSummary

        if (runEndTime != other.runEndTime) return false
        if (runStartTime != other.runStartTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (testCaseId != other.testCaseId) return false
        if (testCaseVersion != other.testCaseVersion) return false
        if (testRunId != other.testRunId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apptest.model.TestCaseRunSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The run end time of the test case run summary.
         */
        public var runEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The run start time of the test case run summary.
         */
        public var runStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the test case run summary.
         */
        public var status: aws.sdk.kotlin.services.apptest.model.TestCaseRunStatus? = null
        /**
         * The status reason of the test case run summary.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The test case id of the test case run summary.
         */
        public var testCaseId: kotlin.String? = null
        /**
         * The test case version of the test case run summary.
         */
        public var testCaseVersion: kotlin.Int? = null
        /**
         * The test run id of the test case run summary.
         */
        public var testRunId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apptest.model.TestCaseRunSummary) : this() {
            this.runEndTime = x.runEndTime
            this.runStartTime = x.runStartTime
            this.status = x.status
            this.statusReason = x.statusReason
            this.testCaseId = x.testCaseId
            this.testCaseVersion = x.testCaseVersion
            this.testRunId = x.testRunId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apptest.model.TestCaseRunSummary = TestCaseRunSummary(this)

        internal fun correctErrors(): Builder {
            if (runStartTime == null) runStartTime = Instant.fromEpochSeconds(0)
            if (status == null) status = TestCaseRunStatus.SdkUnknown("no value provided")
            if (testCaseId == null) testCaseId = ""
            if (testCaseVersion == null) testCaseVersion = 0
            if (testRunId == null) testRunId = ""
            return this
        }
    }
}
