// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetTestConfigurationResponse private constructor(builder: Builder) {
    /**
     * The creation time of the test configuration.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The description of the test configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The last update time of the test configuration.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateTime) { "A non-null value must be provided for lastUpdateTime" }
    /**
     * The latest version of the test configuration.
     */
    public val latestVersion: aws.sdk.kotlin.services.apptest.model.TestConfigurationLatestVersion? = builder.latestVersion
    /**
     * The test configuration name
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The properties of the test configuration.
     */
    public val properties: Map<String, String> = requireNotNull(builder.properties) { "A non-null value must be provided for properties" }
    /**
     * The resources of the test configuration.
     */
    public val resources: List<Resource> = requireNotNull(builder.resources) { "A non-null value must be provided for resources" }
    /**
     * The service settings of the test configuration.
     */
    public val serviceSettings: aws.sdk.kotlin.services.apptest.model.ServiceSettings? = builder.serviceSettings
    /**
     * The status of the test configuration.
     */
    public val status: aws.sdk.kotlin.services.apptest.model.TestConfigurationLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status reason of the test configuration.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The tags of the test configuration.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The test configuration Amazon Resource Name (ARN).
     */
    public val testConfigurationArn: kotlin.String = requireNotNull(builder.testConfigurationArn) { "A non-null value must be provided for testConfigurationArn" }
    /**
     * The response test configuration ID.
     */
    public val testConfigurationId: kotlin.String = requireNotNull(builder.testConfigurationId) { "A non-null value must be provided for testConfigurationId" }
    /**
     * The test configuration version.
     */
    public val testConfigurationVersion: kotlin.Int = requireNotNull(builder.testConfigurationVersion) { "A non-null value must be provided for testConfigurationVersion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apptest.model.GetTestConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetTestConfigurationResponse(")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("latestVersion=$latestVersion,")
        append("name=$name,")
        append("properties=$properties,")
        append("resources=$resources,")
        append("serviceSettings=$serviceSettings,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags,")
        append("testConfigurationArn=$testConfigurationArn,")
        append("testConfigurationId=$testConfigurationId,")
        append("testConfigurationVersion=$testConfigurationVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime.hashCode())
        result = 31 * result + (latestVersion?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (properties.hashCode())
        result = 31 * result + (resources.hashCode())
        result = 31 * result + (serviceSettings?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (testConfigurationArn.hashCode())
        result = 31 * result + (testConfigurationId.hashCode())
        result = 31 * result + (testConfigurationVersion)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetTestConfigurationResponse

        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (latestVersion != other.latestVersion) return false
        if (name != other.name) return false
        if (properties != other.properties) return false
        if (resources != other.resources) return false
        if (serviceSettings != other.serviceSettings) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false
        if (testConfigurationArn != other.testConfigurationArn) return false
        if (testConfigurationId != other.testConfigurationId) return false
        if (testConfigurationVersion != other.testConfigurationVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apptest.model.GetTestConfigurationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The creation time of the test configuration.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the test configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The last update time of the test configuration.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The latest version of the test configuration.
         */
        public var latestVersion: aws.sdk.kotlin.services.apptest.model.TestConfigurationLatestVersion? = null
        /**
         * The test configuration name
         */
        public var name: kotlin.String? = null
        /**
         * The properties of the test configuration.
         */
        public var properties: Map<String, String>? = null
        /**
         * The resources of the test configuration.
         */
        public var resources: List<Resource>? = null
        /**
         * The service settings of the test configuration.
         */
        public var serviceSettings: aws.sdk.kotlin.services.apptest.model.ServiceSettings? = null
        /**
         * The status of the test configuration.
         */
        public var status: aws.sdk.kotlin.services.apptest.model.TestConfigurationLifecycle? = null
        /**
         * The status reason of the test configuration.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The tags of the test configuration.
         */
        public var tags: Map<String, String>? = null
        /**
         * The test configuration Amazon Resource Name (ARN).
         */
        public var testConfigurationArn: kotlin.String? = null
        /**
         * The response test configuration ID.
         */
        public var testConfigurationId: kotlin.String? = null
        /**
         * The test configuration version.
         */
        public var testConfigurationVersion: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apptest.model.GetTestConfigurationResponse) : this() {
            this.creationTime = x.creationTime
            this.description = x.description
            this.lastUpdateTime = x.lastUpdateTime
            this.latestVersion = x.latestVersion
            this.name = x.name
            this.properties = x.properties
            this.resources = x.resources
            this.serviceSettings = x.serviceSettings
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
            this.testConfigurationArn = x.testConfigurationArn
            this.testConfigurationId = x.testConfigurationId
            this.testConfigurationVersion = x.testConfigurationVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apptest.model.GetTestConfigurationResponse = GetTestConfigurationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.apptest.model.TestConfigurationLatestVersion] inside the given [block]
         */
        public fun latestVersion(block: aws.sdk.kotlin.services.apptest.model.TestConfigurationLatestVersion.Builder.() -> kotlin.Unit) {
            this.latestVersion = aws.sdk.kotlin.services.apptest.model.TestConfigurationLatestVersion.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apptest.model.ServiceSettings] inside the given [block]
         */
        public fun serviceSettings(block: aws.sdk.kotlin.services.apptest.model.ServiceSettings.Builder.() -> kotlin.Unit) {
            this.serviceSettings = aws.sdk.kotlin.services.apptest.model.ServiceSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (lastUpdateTime == null) lastUpdateTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (properties == null) properties = emptyMap()
            if (resources == null) resources = emptyList()
            if (status == null) status = TestConfigurationLifecycle.SdkUnknown("no value provided")
            if (testConfigurationArn == null) testConfigurationArn = ""
            if (testConfigurationId == null) testConfigurationId = ""
            if (testConfigurationVersion == null) testConfigurationVersion = 0
            return this
        }
    }
}
