// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apptest.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies a test configuration summary.
 */
public class TestConfigurationSummary private constructor(builder: Builder) {
    /**
     * The creation time of the test configuration summary.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The last update time of the test configuration summary.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateTime) { "A non-null value must be provided for lastUpdateTime" }
    /**
     * The latest version of the test configuration summary.
     */
    public val latestVersion: kotlin.Int = requireNotNull(builder.latestVersion) { "A non-null value must be provided for latestVersion" }
    /**
     * The name of the test configuration summary.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the test configuration summary.
     */
    public val status: aws.sdk.kotlin.services.apptest.model.TestConfigurationLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status reason of the test configuration summary.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The test configuration ARN of the test configuration summary.
     */
    public val testConfigurationArn: kotlin.String = requireNotNull(builder.testConfigurationArn) { "A non-null value must be provided for testConfigurationArn" }
    /**
     * The test configuration ID of the test configuration summary.
     */
    public val testConfigurationId: kotlin.String = requireNotNull(builder.testConfigurationId) { "A non-null value must be provided for testConfigurationId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apptest.model.TestConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestConfigurationSummary(")
        append("creationTime=$creationTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("latestVersion=$latestVersion,")
        append("name=$name,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("testConfigurationArn=$testConfigurationArn,")
        append("testConfigurationId=$testConfigurationId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (lastUpdateTime.hashCode())
        result = 31 * result + (latestVersion)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (testConfigurationArn.hashCode())
        result = 31 * result + (testConfigurationId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestConfigurationSummary

        if (creationTime != other.creationTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (latestVersion != other.latestVersion) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (testConfigurationArn != other.testConfigurationArn) return false
        if (testConfigurationId != other.testConfigurationId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apptest.model.TestConfigurationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The creation time of the test configuration summary.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last update time of the test configuration summary.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The latest version of the test configuration summary.
         */
        public var latestVersion: kotlin.Int? = null
        /**
         * The name of the test configuration summary.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the test configuration summary.
         */
        public var status: aws.sdk.kotlin.services.apptest.model.TestConfigurationLifecycle? = null
        /**
         * The status reason of the test configuration summary.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The test configuration ARN of the test configuration summary.
         */
        public var testConfigurationArn: kotlin.String? = null
        /**
         * The test configuration ID of the test configuration summary.
         */
        public var testConfigurationId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apptest.model.TestConfigurationSummary) : this() {
            this.creationTime = x.creationTime
            this.lastUpdateTime = x.lastUpdateTime
            this.latestVersion = x.latestVersion
            this.name = x.name
            this.status = x.status
            this.statusReason = x.statusReason
            this.testConfigurationArn = x.testConfigurationArn
            this.testConfigurationId = x.testConfigurationId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apptest.model.TestConfigurationSummary = TestConfigurationSummary(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (lastUpdateTime == null) lastUpdateTime = Instant.fromEpochSeconds(0)
            if (latestVersion == null) latestVersion = 0
            if (name == null) name = ""
            if (status == null) status = TestConfigurationLifecycle.SdkUnknown("no value provided")
            if (testConfigurationArn == null) testConfigurationArn = ""
            if (testConfigurationId == null) testConfigurationId = ""
            return this
        }
    }
}
