// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.transform

import aws.sdk.kotlin.services.appsync.model.AdditionalAuthenticationProvider
import aws.sdk.kotlin.services.appsync.model.AuthenticationType
import aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig
import aws.sdk.kotlin.services.appsync.model.LogConfig
import aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig
import aws.sdk.kotlin.services.appsync.model.UpdateGraphqlApiRequest
import aws.sdk.kotlin.services.appsync.model.UserPoolConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateGraphqlApiOperationSerializer: HttpSerialize<UpdateGraphqlApiRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateGraphqlApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "apis",
                "${input.apiId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateGraphqlApiOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateGraphqlApiOperationBody(context: ExecutionContext, input: UpdateGraphqlApiRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALAUTHENTICATIONPROVIDERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalAuthenticationProviders"))
    val AUTHENTICATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authenticationType"))
    val LAMBDAAUTHORIZERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lambdaAuthorizerConfig"))
    val LOGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logConfig"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OPENIDCONNECTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("openIDConnectConfig"))
    val USERPOOLCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("userPoolConfig"))
    val XRAYENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("xrayEnabled"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALAUTHENTICATIONPROVIDERS_DESCRIPTOR)
        field(AUTHENTICATIONTYPE_DESCRIPTOR)
        field(LAMBDAAUTHORIZERCONFIG_DESCRIPTOR)
        field(LOGCONFIG_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OPENIDCONNECTCONFIG_DESCRIPTOR)
        field(USERPOOLCONFIG_DESCRIPTOR)
        field(XRAYENABLED_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.additionalAuthenticationProviders != null) {
            listField(ADDITIONALAUTHENTICATIONPROVIDERS_DESCRIPTOR) {
                for (el0 in input.additionalAuthenticationProviders) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAdditionalAuthenticationProviderDocument))
                }
            }
        }
        input.authenticationType?.let { field(AUTHENTICATIONTYPE_DESCRIPTOR, it.value) }
        input.lambdaAuthorizerConfig?.let { field(LAMBDAAUTHORIZERCONFIG_DESCRIPTOR, it, ::serializeLambdaAuthorizerConfigDocument) }
        input.logConfig?.let { field(LOGCONFIG_DESCRIPTOR, it, ::serializeLogConfigDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.openIdConnectConfig?.let { field(OPENIDCONNECTCONFIG_DESCRIPTOR, it, ::serializeOpenIdConnectConfigDocument) }
        input.userPoolConfig?.let { field(USERPOOLCONFIG_DESCRIPTOR, it, ::serializeUserPoolConfigDocument) }
        if (input.xrayEnabled != false) field(XRAYENABLED_DESCRIPTOR, input.xrayEnabled)
    }
    return serializer.toByteArray()
}
