// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a Sync configuration for a resolver.
 *
 * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
 */
public class SyncConfig private constructor(builder: Builder) {
    /**
     * The Conflict Detection strategy to use.
     * + **VERSION**: Detect conflicts based on object versions for this resolver.
     * + **NONE**: Do not detect conflicts when invoking this resolver.
     */
    public val conflictDetection: aws.sdk.kotlin.services.appsync.model.ConflictDetectionType? = builder.conflictDetection
    /**
     * The Conflict Resolution strategy to perform in the event of a conflict.
     * + **OPTIMISTIC_CONCURRENCY**: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
     * + **AUTOMERGE**: Resolve conflicts with the Automerge conflict resolution strategy.
     * + **LAMBDA**: Resolve conflicts with an Lambda function supplied in the `LambdaConflictHandlerConfig`.
     */
    public val conflictHandler: aws.sdk.kotlin.services.appsync.model.ConflictHandlerType? = builder.conflictHandler
    /**
     * The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
     */
    public val lambdaConflictHandlerConfig: aws.sdk.kotlin.services.appsync.model.LambdaConflictHandlerConfig? = builder.lambdaConflictHandlerConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.SyncConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SyncConfig(")
        append("conflictDetection=$conflictDetection,")
        append("conflictHandler=$conflictHandler,")
        append("lambdaConflictHandlerConfig=$lambdaConflictHandlerConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = conflictDetection?.hashCode() ?: 0
        result = 31 * result + (conflictHandler?.hashCode() ?: 0)
        result = 31 * result + (lambdaConflictHandlerConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SyncConfig

        if (conflictDetection != other.conflictDetection) return false
        if (conflictHandler != other.conflictHandler) return false
        if (lambdaConflictHandlerConfig != other.lambdaConflictHandlerConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.SyncConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Conflict Detection strategy to use.
         * + **VERSION**: Detect conflicts based on object versions for this resolver.
         * + **NONE**: Do not detect conflicts when invoking this resolver.
         */
        public var conflictDetection: aws.sdk.kotlin.services.appsync.model.ConflictDetectionType? = null
        /**
         * The Conflict Resolution strategy to perform in the event of a conflict.
         * + **OPTIMISTIC_CONCURRENCY**: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
         * + **AUTOMERGE**: Resolve conflicts with the Automerge conflict resolution strategy.
         * + **LAMBDA**: Resolve conflicts with an Lambda function supplied in the `LambdaConflictHandlerConfig`.
         */
        public var conflictHandler: aws.sdk.kotlin.services.appsync.model.ConflictHandlerType? = null
        /**
         * The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
         */
        public var lambdaConflictHandlerConfig: aws.sdk.kotlin.services.appsync.model.LambdaConflictHandlerConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.SyncConfig) : this() {
            this.conflictDetection = x.conflictDetection
            this.conflictHandler = x.conflictHandler
            this.lambdaConflictHandlerConfig = x.lambdaConflictHandlerConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.SyncConfig = SyncConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaConflictHandlerConfig] inside the given [block]
         */
        public fun lambdaConflictHandlerConfig(block: aws.sdk.kotlin.services.appsync.model.LambdaConflictHandlerConfig.Builder.() -> kotlin.Unit) {
            this.lambdaConflictHandlerConfig = aws.sdk.kotlin.services.appsync.model.LambdaConflictHandlerConfig.invoke(block)
        }
    }
}
